/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporter;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporterImpl;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectsWorkspaceImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ModifiableWorkspace;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.TestModuleProperties;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.DefaultManifestFileProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIdeModifiableModelsProvider
extends IdeModelsProviderImpl
implements IdeModifiableModelsProvider {
    private static final Logger LOG = Logger.getInstance(AbstractIdeModifiableModelsProvider.class);
    private ModifiableModuleModel myModifiableModuleModel;
    private final Map<Module, ModifiableRootModel> myModifiableRootModels;
    private final Map<Module, ModifiableFacetModel> myModifiableFacetModels;
    private final Map<Module, String> myProductionModulesForTestModules;
    private final Map<Library, Library.ModifiableModel> myModifiableLibraryModels;
    private ModifiableArtifactModel myModifiableArtifactModel;
    private MyPackagingElementResolvingContext myPackagingElementResolvingContext;
    private final ArtifactExternalDependenciesImporter myArtifactExternalDependenciesImporter;
    @Nullable
    private ModifiableWorkspace myModifiableWorkspace;
    private final MyUserDataHolderBase myUserData;
    private volatile boolean myDisposed;

    public AbstractIdeModifiableModelsProvider(@NotNull Project project) {
        if (project == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(0);
        }
        super(project);
        this.myModifiableRootModels = new THashMap();
        this.myModifiableFacetModels = new THashMap();
        this.myProductionModulesForTestModules = new THashMap();
        this.myModifiableLibraryModels = new IdentityHashMap<Library, Library.ModifiableModel>();
        this.myUserData = new MyUserDataHolderBase();
        this.myArtifactExternalDependenciesImporter = new ArtifactExternalDependenciesImporterImpl();
    }

    protected abstract ModifiableArtifactModel doGetModifiableArtifactModel();

    protected abstract ModifiableModuleModel doGetModifiableModuleModel();

    protected abstract ModifiableRootModel doGetModifiableRootModel(Module var1);

    protected abstract ModifiableFacetModel doGetModifiableFacetModel(Module var1);

    protected abstract Library.ModifiableModel doGetModifiableLibraryModel(Library var1);

    @NotNull
    public abstract LibraryTable.ModifiableModel getModifiableProjectLibrariesModel();

    @Override
    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = this.getModifiableModuleModel().getModules();
        if (moduleArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(1);
        }
        return moduleArray;
    }

    protected void processExternalArtifactDependencies() {
        this.myArtifactExternalDependenciesImporter.applyChanges(this.getModifiableArtifactModel(), this.getPackagingElementResolvingContext());
    }

    public PackagingElementResolvingContext getPackagingElementResolvingContext() {
        if (this.myPackagingElementResolvingContext == null) {
            this.myPackagingElementResolvingContext = new MyPackagingElementResolvingContext();
        }
        return this.myPackagingElementResolvingContext;
    }

    @Override
    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull Module module) {
        if (module == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(2);
        }
        OrderEntry[] orderEntryArray = this.getRootModel(module).getOrderEntries();
        if (orderEntryArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(3);
        }
        return orderEntryArray;
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(4);
        }
        Module module = this.getModifiableModuleModel().newModule(filePath, moduleTypeId);
        String moduleName = FileUtil.getNameWithoutExtension((File)new File(filePath));
        if (!module.getName().equals(moduleName)) {
            try {
                this.getModifiableModuleModel().renameModule(module, moduleName);
            }
            catch (ModuleWithNameAlreadyExists exists) {
                LOG.warn((Throwable)exists);
            }
        }
        module.setModuleType(moduleTypeId);
        Module module2 = module;
        if (module2 == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(5);
        }
        return module2;
    }

    @NotNull
    public Module newModule(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(6);
        }
        String imlName = null;
        for (String candidate : this.suggestModuleNameCandidates(moduleData)) {
            Module module = this.findIdeModule(candidate);
            if (module != null) continue;
            imlName = candidate;
            break;
        }
        assert (imlName != null) : "Too many duplicated module names";
        String filePath = ExternalSystemApiUtil.toCanonicalPath((String)(moduleData.getModuleFileDirectoryPath() + "/" + imlName + ".iml"));
        Module module = this.newModule(filePath, moduleData.getModuleTypeId());
        if (module == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(7);
        }
        return module;
    }

    @Override
    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        Module module;
        if (ideModuleName == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(8);
        }
        return (module = this.getModifiableModuleModel().findModuleByName(ideModuleName)) == null ? this.getModifiableModuleModel().getModuleToBeRenamed(ideModuleName) : module;
    }

    @Override
    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(9);
        }
        LibraryTable.ModifiableModel libraryTable = this.getModifiableProjectLibrariesModel();
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Override
    @NotNull
    public VirtualFile[] getContentRoots(Module module) {
        VirtualFile[] virtualFileArray = this.getRootModel(module).getContentRoots();
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(10);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots(Module module) {
        VirtualFile[] virtualFileArray = this.getRootModel(module).getSourceRoots();
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(11);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots(Module module, boolean includingTests) {
        VirtualFile[] virtualFileArray = this.getRootModel(module).getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(12);
        }
        return virtualFileArray;
    }

    @NotNull
    public ModifiableModuleModel getModifiableModuleModel() {
        if (this.myModifiableModuleModel == null) {
            this.myModifiableModuleModel = this.doGetModifiableModuleModel();
        }
        ModifiableModuleModel modifiableModuleModel = this.myModifiableModuleModel;
        if (modifiableModuleModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(13);
        }
        return modifiableModuleModel;
    }

    @NotNull
    public ModifiableRootModel getModifiableRootModel(Module module) {
        ModifiableRootModel modifiableRootModel = (ModifiableRootModel)this.getRootModel(module);
        if (modifiableRootModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(14);
        }
        return modifiableRootModel;
    }

    @NotNull
    private ModuleRootModel getRootModel(Module module) {
        ModuleRootModel moduleRootModel = (ModuleRootModel)this.myModifiableRootModels.computeIfAbsent(module, k -> this.doGetModifiableRootModel(module));
        if (moduleRootModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(15);
        }
        return moduleRootModel;
    }

    @NotNull
    public ModifiableFacetModel getModifiableFacetModel(Module module) {
        ModifiableFacetModel modifiableFacetModel = this.myModifiableFacetModels.computeIfAbsent(module, k -> this.doGetModifiableFacetModel(module));
        if (modifiableFacetModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(16);
        }
        return modifiableFacetModel;
    }

    @NotNull
    public ModifiableArtifactModel getModifiableArtifactModel() {
        if (this.myModifiableArtifactModel == null) {
            this.myModifiableArtifactModel = this.doGetModifiableArtifactModel();
        }
        ModifiableArtifactModel modifiableArtifactModel = this.myModifiableArtifactModel;
        if (modifiableArtifactModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(17);
        }
        return modifiableArtifactModel;
    }

    @Override
    @NotNull
    public Library[] getAllLibraries() {
        Library[] libraryArray = this.getModifiableProjectLibrariesModel().getLibraries();
        if (libraryArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(18);
        }
        return libraryArray;
    }

    @Override
    @Nullable
    public Library getLibraryByName(String name) {
        return this.getModifiableProjectLibrariesModel().getLibraryByName(name);
    }

    public Library createLibrary(String name) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name);
    }

    public Library createLibrary(String name, @Nullable ProjectModelExternalSource externalSource) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name, null, externalSource);
    }

    public void removeLibrary(Library library) {
        this.getModifiableProjectLibrariesModel().removeLibrary(library);
    }

    public Library.ModifiableModel getModifiableLibraryModel(Library library) {
        return this.myModifiableLibraryModels.computeIfAbsent(library, k -> this.doGetModifiableLibraryModel(library));
    }

    @Nullable
    public ModifiableWorkspace getModifiableWorkspace() {
        if (this.myModifiableWorkspace == null && ExternalProjectsWorkspaceImpl.isDependencySubstitutionEnabled()) {
            this.myModifiableWorkspace = this.doGetModifiableWorkspace();
        }
        return this.myModifiableWorkspace;
    }

    @Override
    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        Library.ModifiableModel model;
        if (library == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(19);
        }
        if (type == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(20);
        }
        if ((model = this.myModifiableLibraryModels.get(library)) != null) {
            String[] stringArray = model.getUrls(type);
            if (stringArray == null) {
                AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(21);
            }
            return stringArray;
        }
        String[] stringArray = library.getUrls(type);
        if (stringArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(22);
        }
        return stringArray;
    }

    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.NON_MODAL;
    }

    public ArtifactExternalDependenciesImporter getArtifactExternalDependenciesImporter() {
        return this.myArtifactExternalDependenciesImporter;
    }

    @Override
    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module) {
        if (module == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(23);
        }
        ArrayList<Module> list = new ArrayList<Module>();
        Graph<Module> graph = this.getModuleGraph();
        Iterator i = graph.getOut((Object)module);
        while (i.hasNext()) {
            list.add((Module)i.next());
        }
        ArrayList<Module> arrayList = list;
        if (arrayList == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private ModifiableWorkspace doGetModifiableWorkspace() {
        return (ModifiableWorkspace)ReadAction.compute(() -> ((ExternalProjectsWorkspaceImpl)ServiceManager.getService((Project)this.myProject, ExternalProjectsWorkspaceImpl.class)).createModifiableWorkspace(this));
    }

    private Graph<Module> getModuleGraph() {
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

            @NotNull
            public Collection<Module> getNodes() {
                List list = ContainerUtil.list((Object[])AbstractIdeModifiableModelsProvider.this.getModules());
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            public Iterator<Module> getIn(Module m) {
                Module[] dependentModules = AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(m).getModuleDependencies(true);
                Iterator<Module> iterator = Arrays.asList(dependentModules).iterator();
                if (iterator == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
    }

    public void commit() {
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            if (ExternalProjectsWorkspaceImpl.isDependencySubstitutionEnabled()) {
                this.updateSubstitutions();
            }
            this.processExternalArtifactDependencies();
            for (Map.Entry<Library, Library.ModifiableModel> entry : this.myModifiableLibraryModels.entrySet()) {
                Library fromLibrary = entry.getKey();
                Library.ModifiableModel modifiableModel = entry.getValue();
                if (fromLibrary instanceof LibraryEx && ((LibraryEx)fromLibrary).isDisposed()) {
                    Disposer.dispose((Disposable)modifiableModel);
                    continue;
                }
                modifiableModel.commit();
            }
            this.getModifiableProjectLibrariesModel().commit();
            Collection<ModifiableRootModel> rootModels = this.myModifiableRootModels.values();
            ModifiableRootModel[] rootModels1 = rootModels.toArray(new ModifiableRootModel[0]);
            for (Object model : rootModels1) {
                assert (!model.isDisposed()) : "Already disposed: " + model;
            }
            if (this.myModifiableModuleModel != null) {
                ModifiableModelCommitter.multiCommit((ModifiableRootModel[])rootModels1, (ModifiableModuleModel)this.myModifiableModuleModel);
            } else {
                for (Object model : rootModels1) {
                    model.commit();
                }
            }
            for (Map.Entry entry : this.myProductionModulesForTestModules.entrySet()) {
                TestModuleProperties.getInstance((Module)((Module)entry.getKey())).setProductionModuleName((String)entry.getValue());
            }
            for (Map.Entry entry : this.myModifiableFacetModels.entrySet()) {
                if (((Module)entry.getKey()).isDisposed()) continue;
                ((ModifiableFacetModel)entry.getValue()).commit();
            }
            if (this.myModifiableArtifactModel != null) {
                this.myModifiableArtifactModel.commit();
            }
        });
        this.myUserData.clear();
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!this.myDisposed) : "Already disposed!";
        this.myDisposed = true;
        for (ModifiableRootModel modifiableRootModel : this.myModifiableRootModels.values()) {
            if (modifiableRootModel.isDisposed()) continue;
            modifiableRootModel.dispose();
        }
        Disposer.dispose((Disposable)this.getModifiableProjectLibrariesModel());
        for (Library.ModifiableModel modifiableModel : this.myModifiableLibraryModels.values()) {
            if (modifiableModel instanceof LibraryEx && ((LibraryEx)modifiableModel).isDisposed()) continue;
            Disposer.dispose((Disposable)modifiableModel);
        }
        if (this.myModifiableModuleModel != null && this.myModifiableModuleModel.isChanged()) {
            this.myModifiableModuleModel.dispose();
        }
        if (this.myModifiableArtifactModel != null) {
            this.myModifiableArtifactModel.dispose();
        }
        this.myModifiableRootModels.clear();
        this.myModifiableFacetModels.clear();
        this.myModifiableLibraryModels.clear();
        this.myUserData.clear();
    }

    public void setTestModuleProperties(Module testModule, String productionModuleName) {
        this.myProductionModulesForTestModules.put(testModule, productionModuleName);
    }

    @Nullable
    public String getProductionModuleName(Module module) {
        return this.myProductionModulesForTestModules.get(module);
    }

    public ModuleOrderEntry trySubstitute(Module ownerModule, LibraryOrderEntry libraryOrderEntry, ProjectCoordinate publicationId) {
        Module workspaceModule;
        String workspaceModuleCandidate = this.findModuleByPublication(publicationId);
        Module module = workspaceModule = workspaceModuleCandidate == null ? null : this.findIdeModule(workspaceModuleCandidate);
        if (workspaceModule == null) {
            return null;
        }
        ModifiableRootModel modifiableRootModel = this.getModifiableRootModel(ownerModule);
        ModuleOrderEntry moduleOrderEntry = modifiableRootModel.addModuleOrderEntry(workspaceModule);
        moduleOrderEntry.setScope(libraryOrderEntry.getScope());
        moduleOrderEntry.setExported(libraryOrderEntry.isExported());
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        assert (workspace != null);
        workspace.addSubstitution(ownerModule.getName(), workspaceModule.getName(), libraryOrderEntry.getLibraryName(), libraryOrderEntry.getScope());
        modifiableRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
        return moduleOrderEntry;
    }

    public void registerModulePublication(Module module, ProjectCoordinate modulePublication) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace != null) {
            workspace.register(modulePublication, module);
        }
    }

    public boolean isSubstituted(String libraryName) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace == null) {
            return false;
        }
        return workspace.isSubstituted(libraryName);
    }

    @Nullable
    public <T> T getUserData(@NotNull com.intellij.openapi.util.Key<T> key) {
        if (key == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(25);
        }
        return (T)this.myUserData.getUserData(key);
    }

    public <T> void putUserData(@NotNull com.intellij.openapi.util.Key<T> key, @Nullable T value) {
        if (key == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(26);
        }
        this.myUserData.putUserData(key, value);
    }

    @Nullable
    public String findModuleByPublication(ProjectCoordinate publicationId) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        return workspace == null ? null : workspace.findModule(publicationId);
    }

    private void updateSubstitutions() {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace == null) {
            return;
        }
        List oldModules = Arrays.stream(ModuleManager.getInstance((Project)this.myProject).getModules()).map(module -> module.getName()).collect(Collectors.toList());
        List newModules = Arrays.stream(this.myModifiableModuleModel.getModules()).map(module -> module.getName()).collect(Collectors.toList());
        THashSet removedModules = new THashSet(oldModules);
        removedModules.removeAll(newModules);
        HashMap toSubstitute = ContainerUtil.newHashMap();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(this.myProject, manager.getSystemId());
            for (ExternalProjectInfo projectInfo : projectsData) {
                if (projectInfo.getExternalProjectStructure() == null) continue;
                Collection libraryNodes = ExternalSystemApiUtil.findAll((DataNode)projectInfo.getExternalProjectStructure(), (Key)ProjectKeys.LIBRARY);
                for (DataNode libraryNode : libraryNodes) {
                    String substitutionModuleCandidate = this.findModuleByPublication((ProjectCoordinate)libraryNode.getData());
                    if (substitutionModuleCandidate == null) continue;
                    toSubstitute.put(((LibraryData)libraryNode.getData()).getInternalName(), substitutionModuleCandidate);
                }
            }
        }
        for (Module module2 : this.getModules()) {
            ModifiableRootModel modifiableRootModel = this.getModifiableRootModel(module2);
            boolean changed = false;
            OrderEntry[] entries = modifiableRootModel.getOrderEntries();
            int length = entries.length;
            for (int i = 0; i < length; ++i) {
                Module ideModule;
                String workspaceModule;
                LibraryOrderEntry libraryOrderEntry;
                String workspaceModule2;
                OrderEntry orderEntry = entries[i];
                if (orderEntry instanceof ModuleOrderEntry && removedModules.contains(workspaceModule2 = ((ModuleOrderEntry)orderEntry).getModuleName())) {
                    Library library;
                    String libraryName;
                    DependencyScope scope = ((ModuleOrderEntry)orderEntry).getScope();
                    if (workspace.isSubstitution(module2.getName(), workspaceModule2, scope) && (libraryName = workspace.getSubstitutedLibrary(workspaceModule2)) != null && (library = this.getLibraryByName(libraryName)) != null) {
                        modifiableRootModel.removeOrderEntry(orderEntry);
                        entries[i] = modifiableRootModel.addLibraryEntry(library);
                        changed = true;
                        workspace.removeSubstitution(module2.getName(), workspaceModule2, libraryName, scope);
                    }
                }
                if (!(orderEntry instanceof LibraryOrderEntry) || (libraryOrderEntry = (LibraryOrderEntry)orderEntry).isModuleLevel() || libraryOrderEntry.getLibraryName() == null || (workspaceModule = (String)toSubstitute.get(libraryOrderEntry.getLibraryName())) == null || (ideModule = this.findIdeModule(workspaceModule)) == null) continue;
                ModuleOrderEntry moduleOrderEntry = modifiableRootModel.addModuleOrderEntry(ideModule);
                moduleOrderEntry.setScope(libraryOrderEntry.getScope());
                modifiableRootModel.removeOrderEntry(orderEntry);
                entries[i] = moduleOrderEntry;
                changed = true;
                workspace.addSubstitution(module2.getName(), workspaceModule, libraryOrderEntry.getLibraryName(), libraryOrderEntry.getScope());
            }
            if (!changed) continue;
            modifiableRootModel.rearrangeOrderEntries(entries);
        }
        workspace.commit();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModuleName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModuleModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableRootModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableFacetModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableArtifactModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibraries";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryUrls";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findIdeLibrary";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryUrls";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFacetsProvider
    implements FacetsProvider {
        private MyFacetsProvider() {
        }

        @NotNull
        public Facet[] getAllFacets(Module module) {
            Facet[] facetArray = AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module).getAllFacets();
            if (facetArray == null) {
                MyFacetsProvider.$$$reportNull$$$0(0);
            }
            return facetArray;
        }

        @NotNull
        public <F extends Facet> Collection<F> getFacetsByType(Module module, FacetTypeId<F> type) {
            Collection collection = AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module).getFacetsByType(type);
            if (collection == null) {
                MyFacetsProvider.$$$reportNull$$$0(1);
            }
            return collection;
        }

        public <F extends Facet> F findFacet(Module module, FacetTypeId<F> type, String name) {
            return (F)AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module).findFacet(type, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyFacetsProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllFacets";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFacetsByType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class MyModulesProvider
    implements ModulesProvider {
        private MyModulesProvider() {
        }

        @NotNull
        public Module[] getModules() {
            Module[] moduleArray = AbstractIdeModifiableModelsProvider.this.getModules();
            if (moduleArray == null) {
                MyModulesProvider.$$$reportNull$$$0(0);
            }
            return moduleArray;
        }

        public Module getModule(String name) {
            return AbstractIdeModifiableModelsProvider.this.findIdeModule(name);
        }

        public ModuleRootModel getRootModel(@NotNull Module module) {
            if (module == null) {
                MyModulesProvider.$$$reportNull$$$0(1);
            }
            return AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(module);
        }

        public FacetModel getFacetModel(@NotNull Module module) {
            if (module == null) {
                MyModulesProvider.$$$reportNull$$$0(2);
            }
            return AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyModulesProvider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyModulesProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFacetModel";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyPackagingElementResolvingContext
    implements PackagingElementResolvingContext {
        private final ModulesProvider myModulesProvider;
        private final MyFacetsProvider myFacetsProvider;
        private final ManifestFileProvider myManifestFileProvider;

        private MyPackagingElementResolvingContext() {
            this.myModulesProvider = new MyModulesProvider();
            this.myFacetsProvider = new MyFacetsProvider();
            this.myManifestFileProvider = new DefaultManifestFileProvider((PackagingElementResolvingContext)this);
        }

        @NotNull
        public Project getProject() {
            Project project = AbstractIdeModifiableModelsProvider.this.myProject;
            if (project == null) {
                MyPackagingElementResolvingContext.$$$reportNull$$$0(0);
            }
            return project;
        }

        @NotNull
        public ArtifactModel getArtifactModel() {
            ModifiableArtifactModel modifiableArtifactModel = AbstractIdeModifiableModelsProvider.this.getModifiableArtifactModel();
            if (modifiableArtifactModel == null) {
                MyPackagingElementResolvingContext.$$$reportNull$$$0(1);
            }
            return modifiableArtifactModel;
        }

        @NotNull
        public ModulesProvider getModulesProvider() {
            ModulesProvider modulesProvider = this.myModulesProvider;
            if (modulesProvider == null) {
                MyPackagingElementResolvingContext.$$$reportNull$$$0(2);
            }
            return modulesProvider;
        }

        @NotNull
        public FacetsProvider getFacetsProvider() {
            MyFacetsProvider myFacetsProvider = this.myFacetsProvider;
            if (myFacetsProvider == null) {
                MyPackagingElementResolvingContext.$$$reportNull$$$0(3);
            }
            return myFacetsProvider;
        }

        public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
            if (level == null) {
                MyPackagingElementResolvingContext.$$$reportNull$$$0(4);
            }
            if (libraryName == null) {
                MyPackagingElementResolvingContext.$$$reportNull$$$0(5);
            }
            if (level.equals("project")) {
                return AbstractIdeModifiableModelsProvider.this.getLibraryByName(libraryName);
            }
            LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, AbstractIdeModifiableModelsProvider.this.myProject);
            return table != null ? table.getLibraryByName(libraryName) : null;
        }

        @NotNull
        public ManifestFileProvider getManifestFileProvider() {
            ManifestFileProvider manifestFileProvider = this.myManifestFileProvider;
            if (manifestFileProvider == null) {
                MyPackagingElementResolvingContext.$$$reportNull$$$0(6);
            }
            return manifestFileProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArtifactModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModulesProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFacetsProvider";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getManifestFileProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findLibrary";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyUserDataHolderBase
    extends UserDataHolderBase {
        private MyUserDataHolderBase() {
        }

        void clear() {
            this.clearUserData();
        }
    }
}

