/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class PreferenceButton
extends JComponent {
    private final String myLabel;
    private final Icon myIcon;

    public PreferenceButton(String label2, Icon icon) {
        this.myLabel = label2;
        this.myIcon = icon;
        if (SystemInfo.isMac) {
            this.setFont(new Font("Lucida Grande", 0, 11));
        } else {
            this.setFont(UIUtil.getLabelFont());
        }
        this.setPreferredSize((Dimension)JBUI.size((int)100, (int)70));
        this.setOpaque(false);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Border border;
        Color bg = this.getBackground();
        if (bg == null) {
            bg = UIUtil.getPanelBackground();
        }
        g.setColor(bg);
        if (this.isOpaque()) {
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        Insets insets = (border = this.getBorder()) == null ? new Insets(0, 0, 0, 0) : border.getBorderInsets(this);
        int x = (this.getWidth() - insets.left - insets.right - this.myIcon.getIconWidth()) / 2;
        int y = insets.top;
        this.myIcon.paintIcon(this, g, x, y);
        g.setFont(this.getFont());
        y += this.myIcon.getIconHeight();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        x = (this.getWidth() - insets.left - insets.right - metrics.stringWidth(this.myLabel)) / 2;
        y = (int)((double)y + 1.5 * (double)metrics.getHeight());
        g.setColor(UIUtil.getLabelForeground());
        GraphicsUtil.setupAAPainting((Graphics)g);
        g.drawString(this.myLabel, x, y);
    }
}

