/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.ex.ComponentManagerEx;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.InstanceComponentAdapter;

public class ServiceManagerImpl
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ServiceManagerImpl.class);
    private static final ExtensionPointName<ServiceDescriptor> APP_SERVICES = new ExtensionPointName("com.intellij.applicationService");
    private static final ExtensionPointName<ServiceDescriptor> PROJECT_SERVICES = new ExtensionPointName("com.intellij.projectService");
    private ExtensionPointName<ServiceDescriptor> myExtensionPointName;
    private ExtensionPointListener<ServiceDescriptor> myExtensionPointListener;

    public ServiceManagerImpl() {
        this.installEP(APP_SERVICES, (ComponentManager)ApplicationManager.getApplication());
    }

    public ServiceManagerImpl(Project project) {
        this.installEP(PROJECT_SERVICES, (ComponentManager)project);
    }

    protected ServiceManagerImpl(boolean ignoreInit) {
    }

    protected void installEP(@NotNull ExtensionPointName<ServiceDescriptor> pointName, final @NotNull ComponentManager componentManager) {
        if (pointName == null) {
            ServiceManagerImpl.$$$reportNull$$$0(0);
        }
        if (componentManager == null) {
            ServiceManagerImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(this.myExtensionPointName == null, (Object)("Already called installEP with " + this.myExtensionPointName));
        this.myExtensionPointName = pointName;
        ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(pointName);
        final MutablePicoContainer picoContainer = (MutablePicoContainer)componentManager.getPicoContainer();
        this.myExtensionPointListener = new ExtensionPointListener<ServiceDescriptor>(){

            public void extensionAdded(@NotNull ServiceDescriptor descriptor, PluginDescriptor pluginDescriptor) {
                ComponentAdapter oldAdapter;
                if (descriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (descriptor.overrides && (oldAdapter = picoContainer.unregisterComponent((Object)descriptor.getInterface())) == null) {
                    throw new PluginException("Service: " + descriptor.getInterface() + " doesn't override anything", pluginDescriptor != null ? pluginDescriptor.getPluginId() : null);
                }
                if (!Extensions.isComponentSuitableForOs((String)descriptor.os)) {
                    return;
                }
                if (!StringUtil.isEmpty((String)descriptor.getImplementation())) {
                    picoContainer.registerComponent((ComponentAdapter)new MyComponentAdapter(descriptor, pluginDescriptor, (ComponentManagerEx)componentManager));
                }
            }

            public void extensionRemoved(@NotNull ServiceDescriptor extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(1);
                }
                picoContainer.unregisterComponent((Object)extension.getInterface());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/components/impl/ServiceManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        extensionPoint.addExtensionPointListener(this.myExtensionPointListener);
    }

    @NotNull
    public List<ServiceDescriptor> getAllDescriptors() {
        List list2 = this.myExtensionPointName.getExtensionList();
        if (list2 == null) {
            ServiceManagerImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public static void processAllImplementationClasses(@NotNull ComponentManagerImpl componentManager, @NotNull BiPredicate<? super Class<?>, ? super PluginDescriptor> processor2) {
        Collection adapters;
        if (componentManager == null) {
            ServiceManagerImpl.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            ServiceManagerImpl.$$$reportNull$$$0(4);
        }
        if ((adapters = componentManager.getPicoContainer().getComponentAdapters()).isEmpty()) {
            return;
        }
        for (ComponentAdapter o : adapters) {
            PluginId pluginId;
            Class<?> aClass;
            if (o instanceof MyComponentAdapter) {
                MyComponentAdapter adapter = (MyComponentAdapter)o;
                PluginDescriptor pluginDescriptor = adapter.myPluginDescriptor;
                try {
                    ComponentAdapter delegate = adapter.myDelegate;
                    if (delegate == null) {
                        ClassLoader classLoader = pluginDescriptor == null ? ServiceManagerImpl.class.getClassLoader() : pluginDescriptor.getPluginClassLoader();
                        aClass = Class.forName(adapter.myDescriptor.getImplementation(), false, classLoader);
                    } else {
                        aClass = delegate.getComponentImplementation();
                    }
                }
                catch (Throwable e) {
                    if (PlatformUtils.isIdeaUltimate()) {
                        LOG.error(e);
                        continue;
                    }
                    LOG.warn(e);
                    continue;
                }
                if (processor2.test(aClass, (PluginDescriptor)pluginDescriptor)) continue;
                break;
            }
            if (o instanceof ExtensionComponentAdapter || (pluginId = componentManager.getConfig(o)) == null && !(o instanceof InstanceComponentAdapter)) continue;
            try {
                aClass = o.getComponentImplementation();
            }
            catch (Throwable e) {
                LOG.error(e);
                continue;
            }
            if (processor2.test(aClass, (PluginDescriptor)(pluginId == null ? null : PluginManager.getPlugin(pluginId)))) continue;
            break;
        }
    }

    public void dispose() {
        ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(this.myExtensionPointName);
        extensionPoint.removeExtensionPointListener(this.myExtensionPointListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/ServiceManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/ServiceManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installEP";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAllImplementationClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyComponentAdapter
    implements AssignableToComponentAdapter,
    DefaultPicoContainer.LazyComponentAdapter {
        private ComponentAdapter myDelegate;
        private final ServiceDescriptor myDescriptor;
        private final PluginDescriptor myPluginDescriptor;
        private final ComponentManagerEx myComponentManager;
        private volatile Object myInitializedComponentInstance;

        MyComponentAdapter(ServiceDescriptor descriptor, PluginDescriptor pluginDescriptor, ComponentManagerEx componentManager) {
            this.myDescriptor = descriptor;
            this.myPluginDescriptor = pluginDescriptor;
            this.myComponentManager = componentManager;
            this.myDelegate = null;
        }

        public String getComponentKey() {
            return this.myDescriptor.getInterface();
        }

        public Class getComponentImplementation() {
            return this.getDelegate().getComponentImplementation();
        }

        public boolean isComponentInstantiated() {
            return this.myInitializedComponentInstance != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getComponentInstance(@NotNull PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
            Object instance;
            if (container == null) {
                MyComponentAdapter.$$$reportNull$$$0(0);
            }
            if ((instance = this.myInitializedComponentInstance) != null) {
                return instance;
            }
            MyComponentAdapter myComponentAdapter = this;
            synchronized (myComponentAdapter) {
                Object object;
                instance = this.myInitializedComponentInstance;
                if (instance != null) {
                    return instance;
                }
                ComponentAdapter delegate = this.getDelegate();
                if (LOG.isDebugEnabled() && ApplicationManager.getApplication().isWriteAccessAllowed() && !ApplicationManager.getApplication().isUnitTestMode() && PersistentStateComponent.class.isAssignableFrom(delegate.getComponentImplementation())) {
                    LOG.warn(new Throwable("Getting service from write-action leads to possible deadlock. Service implementation " + this.myDescriptor.getImplementation()));
                }
                AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Creating component '" + this.myDescriptor.getImplementation() + "'");
                try {
                    instance = delegate.getComponentInstance(container);
                    if (instance instanceof Disposable) {
                        Disposer.register((Disposable)this.myComponentManager, (Disposable)((Disposable)instance));
                    }
                    this.myComponentManager.initializeComponent(instance, true);
                    this.myInitializedComponentInstance = instance;
                    object = instance;
                }
                catch (Throwable throwable) {
                    token.finish();
                    throw throwable;
                }
                token.finish();
                return object;
            }
        }

        @NotNull
        private synchronized ComponentAdapter getDelegate() {
            if (this.myDelegate == null) {
                Class<?> implClass;
                try {
                    ClassLoader classLoader = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginClassLoader() : this.getClass().getClassLoader();
                    implClass = Class.forName(this.myDescriptor.getImplementation(), true, classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.myDelegate = new CachingConstructorInjectionComponentAdapter((Object)this.getComponentKey(), implClass, null, true);
            }
            ComponentAdapter componentAdapter = this.myDelegate;
            if (componentAdapter == null) {
                MyComponentAdapter.$$$reportNull$$$0(1);
            }
            return componentAdapter;
        }

        public void verify(PicoContainer container) throws PicoIntrospectionException {
            this.getDelegate().verify(container);
        }

        public void accept(PicoVisitor visitor) {
            visitor.visitComponentAdapter((ComponentAdapter)this);
        }

        public String getAssignableToClassName() {
            return this.myDescriptor.getInterface();
        }

        public String toString() {
            return "ServiceComponentAdapter[" + this.myDescriptor.getInterface() + "]: implementation=" + this.myDescriptor.getImplementation() + ", plugin=" + this.myPluginDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/components/impl/ServiceManagerImpl$MyComponentAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/components/impl/ServiceManagerImpl$MyComponentAdapter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponentInstance";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

