/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JsonStringPropertyInsertHandler
implements InsertHandler<LookupElement> {
    private final String myNewValue;

    public JsonStringPropertyInsertHandler(@NotNull String newValue) {
        if (newValue == null) {
            JsonStringPropertyInsertHandler.$$$reportNull$$$0(0);
        }
        this.myNewValue = newValue;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        TextRange toDelete;
        PsiElement element;
        JsonStringLiteral literal;
        if (context == null) {
            JsonStringPropertyInsertHandler.$$$reportNull$$$0(1);
        }
        if (item == null) {
            JsonStringPropertyInsertHandler.$$$reportNull$$$0(2);
        }
        if ((literal = (JsonStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)(element = context.getFile().findElementAt(context.getStartOffset())), JsonStringLiteral.class, (boolean)false)) == null) {
            return;
        }
        JsonProperty property = (JsonProperty)ObjectUtils.tryCast((Object)literal.getParent(), JsonProperty.class);
        if (property == null) {
            return;
        }
        String textToInsert = "";
        TextRange literalRange = literal.getTextRange();
        if (literal.getValue().equals(this.myNewValue)) {
            toDelete = new TextRange(literalRange.getEndOffset(), literalRange.getEndOffset());
        } else {
            toDelete = literalRange;
            textToInsert = StringUtil.wrapWithDoubleQuote((String)this.myNewValue);
        }
        int newCaretOffset = literalRange.getStartOffset() + 1 + this.myNewValue.length();
        boolean showAutoPopup = false;
        if (property.getNameElement().equals(literal) && property.getValue() == null) {
            textToInsert = textToInsert + ":\"\"";
            newCaretOffset += 3;
            if (JsonStringPropertyInsertHandler.needCommaAfter(property)) {
                textToInsert = textToInsert + ",";
            }
            showAutoPopup = true;
        }
        context.getDocument().replaceString(toDelete.getStartOffset(), toDelete.getEndOffset(), (CharSequence)textToInsert);
        context.getEditor().getCaretModel().moveToOffset(newCaretOffset);
        JsonStringPropertyInsertHandler.reformat(context, toDelete.getStartOffset(), toDelete.getStartOffset() + textToInsert.length());
        if (showAutoPopup) {
            AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        }
    }

    private static boolean needCommaAfter(@NotNull JsonProperty property) {
        if (property == null) {
            JsonStringPropertyInsertHandler.$$$reportNull$$$0(3);
        }
        for (PsiElement element = property.getNextSibling(); element != null; element = element.getNextSibling()) {
            if (element instanceof JsonProperty) {
                return true;
            }
            if (element.getNode().getElementType() != JsonElementTypes.COMMA) continue;
            return false;
        }
        return false;
    }

    private static void reformat(@NotNull InsertionContext context, int startOffset, int endOffset) {
        if (context == null) {
            JsonStringPropertyInsertHandler.$$$reportNull$$$0(4);
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)context.getProject());
        codeStyleManager.reformatText(context.getFile(), startOffset, endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/codeinsight/JsonStringPropertyInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "needCommaAfter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reformat";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

