/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionListStep
implements ListPopupStep<IntentionActionWithTextCaching>,
SpeedSearchFilter<IntentionActionWithTextCaching> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionListStep");
    private final CachedIntentions myCachedIntentions;
    @Nullable
    private final IntentionHintComponent myIntentionHintComponent;
    private Runnable myFinalRunnable;
    private final Project myProject;
    private final PsiFile myFile;
    @Nullable
    private final Editor myEditor;

    public IntentionListStep(@Nullable IntentionHintComponent intentionHintComponent, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull Project project, CachedIntentions intentions) {
        if (file2 == null) {
            IntentionListStep.$$$reportNull$$$0(0);
        }
        if (project == null) {
            IntentionListStep.$$$reportNull$$$0(1);
        }
        this.myIntentionHintComponent = intentionHintComponent;
        this.myProject = project;
        this.myFile = file2;
        this.myEditor = editor;
        this.myCachedIntentions = intentions;
    }

    public String getTitle() {
        return null;
    }

    public boolean isSelectable(IntentionActionWithTextCaching action) {
        return true;
    }

    public PopupStep onChosen(IntentionActionWithTextCaching action, boolean finalChoice) {
        IntentionAction a = action.getAction();
        while (a instanceof IntentionActionDelegate) {
            a = ((IntentionActionDelegate)a).getDelegate();
        }
        if (finalChoice && !(a instanceof AbstractEmptyIntentionAction)) {
            this.applyAction(action);
            return FINAL_CHOICE;
        }
        if (this.hasSubstep(action)) {
            return this.getSubStep(action, action.getToolName());
        }
        return FINAL_CHOICE;
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    private void applyAction(@NotNull IntentionActionWithTextCaching cachedAction) {
        if (cachedAction == null) {
            IntentionListStep.$$$reportNull$$$0(2);
        }
        this.myFinalRunnable = () -> {
            PsiFile file2;
            if (cachedAction == null) {
                IntentionListStep.$$$reportNull$$$0(7);
            }
            HintManager.getInstance().hideAllHints();
            if (this.myProject.isDisposed() || this.myEditor != null && (this.myEditor.isDisposed() || !this.myEditor.getComponent().isShowing())) {
                return;
            }
            if (DumbService.isDumb((Project)this.myProject) && !DumbService.isDumbAware((Object)cachedAction)) {
                DumbService.getInstance((Project)this.myProject).showDumbModeNotification(cachedAction.getText() + " is not available during indexing");
                return;
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            PsiFile psiFile = file2 = this.myEditor != null ? PsiUtilBase.getPsiFileInEditor((Editor)this.myEditor, (Project)this.myProject) : this.myFile;
            if (file2 == null) {
                return;
            }
            ShowIntentionActionsHandler.chooseActionAndInvoke(file2, this.myEditor, cachedAction.getAction(), cachedAction.getText(), this.myProject);
        };
    }

    @NotNull
    IntentionListStep getSubStep(@NotNull IntentionActionWithTextCaching action, final String title) {
        if (action == null) {
            IntentionListStep.$$$reportNull$$$0(3);
        }
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        for (IntentionAction optionIntention : action.getOptionIntentions()) {
            intentions.intentionsToShow.add(new HighlightInfo.IntentionActionDescriptor(optionIntention, IntentionListStep.getIcon(optionIntention)));
        }
        for (IntentionAction optionFix : action.getOptionErrorFixes()) {
            intentions.errorFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        for (IntentionAction optionFix : action.getOptionInspectionFixes()) {
            intentions.inspectionFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        IntentionListStep intentionListStep = new IntentionListStep(this.myIntentionHintComponent, this.myEditor, this.myFile, this.myProject, CachedIntentions.create(this.myProject, this.myFile, this.myEditor, intentions)){

            @Override
            public String getTitle() {
                return title;
            }
        };
        if (intentionListStep == null) {
            IntentionListStep.$$$reportNull$$$0(4);
        }
        return intentionListStep;
    }

    private static Icon getIcon(IntentionAction optionIntention) {
        return optionIntention instanceof Iconable ? ((Iconable)optionIntention).getIcon(0) : null;
    }

    public Map<IntentionAction, List<IntentionAction>> getActionsWithSubActions() {
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        for (IntentionActionWithTextCaching cached : this.getValues()) {
            IntentionAction action = cached.getAction();
            if (ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, action) == null) continue;
            List<IntentionActionWithTextCaching> subActions = this.getSubStep(cached, cached.getToolName()).getValues();
            List options = subActions.stream().map(IntentionActionWithTextCaching::getAction).filter(option -> ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, option) != null).collect(Collectors.toList());
            result2.put(action, options);
        }
        return result2;
    }

    public boolean hasSubstep(IntentionActionWithTextCaching action) {
        return action.getOptionIntentions().size() + action.getOptionErrorFixes().size() > 0;
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getValues() {
        List<IntentionActionWithTextCaching> list2 = this.myCachedIntentions.getAllActions();
        if (list2 == null) {
            IntentionListStep.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public String getTextFor(IntentionActionWithTextCaching action) {
        String text = action.getAction().getText();
        if (LOG.isDebugEnabled() && text.startsWith("<html>")) {
            LOG.info("IntentionAction.getText() returned HTML: action=" + action + " text=" + text);
        }
        String string = text;
        if (string == null) {
            IntentionListStep.$$$reportNull$$$0(6);
        }
        return string;
    }

    public Icon getIconFor(IntentionActionWithTextCaching value) {
        return this.myCachedIntentions.getIcon(value);
    }

    public void canceled() {
        if (this.myIntentionHintComponent != null) {
            this.myIntentionHintComponent.canceled(this);
        }
    }

    public int getDefaultOptionIndex() {
        return 0;
    }

    public ListSeparator getSeparatorAbove(IntentionActionWithTextCaching value) {
        List<IntentionActionWithTextCaching> values = this.getValues();
        int index = values.indexOf(value);
        if (index <= 0) {
            return null;
        }
        IntentionActionWithTextCaching prev2 = values.get(index - 1);
        if (this.myCachedIntentions.getGroup(value) != this.myCachedIntentions.getGroup(prev2)) {
            return new ListSeparator();
        }
        return null;
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter<IntentionActionWithTextCaching> getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    public SpeedSearchFilter<IntentionActionWithTextCaching> getSpeedSearchFilter() {
        return this;
    }

    public String getIndexedString(IntentionActionWithTextCaching value) {
        return this.getTextFor(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/IntentionListStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionListStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubStep";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSubStep";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyAction$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

