/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class PostfixPrefixIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                IElementType tokenType;
                if (element instanceof PsiPrefixExpression) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
                    tokenType = prefixExpression.getOperationTokenType();
                    if (prefixExpression.getOperand() == null) {
                        return false;
                    }
                } else if (element instanceof PsiPostfixExpression) {
                    PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
                    tokenType = postfixExpression.getOperationTokenType();
                } else {
                    return false;
                }
                return JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType);
            }
        };
        if (psiElementPredicate == null) {
            PostfixPrefixIntention.$$$reportNull$$$0(0);
        }
        return psiElementPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{PostfixPrefixIntention.getReplacementText(element)});
    }

    @NotNull
    private static String getReplacementText(PsiElement element) {
        if (element instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
            PsiExpression operand2 = prefixExpression.getOperand();
            assert (operand2 != null);
            PsiJavaToken sign = prefixExpression.getOperationSign();
            String string = operand2.getText() + sign.getText();
            if (string == null) {
                PostfixPrefixIntention.$$$reportNull$$$0(1);
            }
            return string;
        }
        PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
        PsiExpression operand3 = postfixExpression.getOperand();
        PsiJavaToken sign = postfixExpression.getOperationSign();
        String string = sign.getText() + operand3.getText();
        if (string == null) {
            PostfixPrefixIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            PostfixPrefixIntention.$$$reportNull$$$0(3);
        }
        PsiUnaryExpression expression2 = (PsiUnaryExpression)element;
        CommentTracker commentTracker = new CommentTracker();
        PsiExpression operand2 = expression2.getOperand();
        assert (operand2 != null);
        commentTracker.markUnchanged(operand2);
        PsiReplacementUtil.replaceExpression((PsiExpression)expression2, PostfixPrefixIntention.getReplacementText(element), commentTracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/opassign/PostfixPrefixIntention";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/opassign/PostfixPrefixIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

