/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.PsiElementPredicate;

class CStyleCommentPredicate
implements PsiElementPredicate {
    CStyleCommentPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        if (element instanceof PsiDocComment) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType type2 = comment.getTokenType();
        if (!JavaTokenType.C_STYLE_COMMENT.equals(type2)) {
            return false;
        }
        PsiElement sibling = PsiTreeUtil.nextLeaf((PsiElement)comment);
        if (!(sibling instanceof PsiWhiteSpace)) {
            return false;
        }
        String whitespaceText = sibling.getText();
        return whitespaceText.indexOf(10) >= 0 || whitespaceText.indexOf(13) >= 0;
    }
}

