/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.annotation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.annotation.AnnotateOverriddenMethodsPredicate;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotateOverriddenMethodsIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AnnotateOverriddenMethodsPredicate annotateOverriddenMethodsPredicate = new AnnotateOverriddenMethodsPredicate();
        if (annotateOverriddenMethodsPredicate == null) {
            AnnotateOverriddenMethodsIntention.$$$reportNull$$$0(0);
        }
        return annotateOverriddenMethodsPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiAnnotation annotation = (PsiAnnotation)element;
        String annotationText = annotation.getText();
        PsiElement grandParent = element.getParent().getParent();
        if (grandParent instanceof PsiMethod) {
            return IntentionPowerPackBundle.message("annotate.overridden.methods.intention.method.name", annotationText);
        }
        return IntentionPowerPackBundle.message("annotate.overridden.methods.intention.parameters.name", annotationText);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiMethod method;
        int parameterIndex;
        PsiAnnotation annotation;
        String annotationName;
        if (element == null) {
            AnnotateOverriddenMethodsIntention.$$$reportNull$$$0(1);
        }
        if ((annotationName = (annotation = (PsiAnnotation)element).getQualifiedName()) == null) {
            return;
        }
        Project project = element.getProject();
        NullableNotNullManager notNullManager = NullableNotNullManager.getInstance((Project)project);
        List notNulls = notNullManager.getNotNulls();
        List<String> nullables = notNullManager.getNullables();
        List<Object> annotationsToRemove = notNulls.contains(annotationName) ? nullables : (nullables.contains(annotationName) ? notNulls : Collections.emptyList());
        PsiElement parent = annotation.getParent();
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiMethod)) {
            if (!(grandParent instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter2 = (PsiParameter)grandParent;
            PsiElement greatGrandParent = grandParent.getParent();
            if (!(greatGrandParent instanceof PsiParameterList)) {
                return;
            }
            PsiParameterList parameterList = (PsiParameterList)greatGrandParent;
            parameterIndex = parameterList.getParameterIndex(parameter2);
            PsiElement greatGreatGrandParent = greatGrandParent.getParent();
            if (!(greatGreatGrandParent instanceof PsiMethod)) {
                return;
            }
            method = (PsiMethod)greatGreatGrandParent;
        } else {
            parameterIndex = -1;
            method = (PsiMethod)grandParent;
        }
        Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)method).findAll();
        ArrayList<PsiMethod> prepare = new ArrayList<PsiMethod>();
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        for (PsiMethod overridingMethod : overridingMethods) {
            if (annotationsManager.chooseAnnotationsPlace((PsiElement)overridingMethod) != ExternalAnnotationsManager.AnnotationPlace.IN_CODE) continue;
            prepare.add(overridingMethod);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(prepare)) {
            return;
        }
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        try {
            for (PsiMethod overridingMethod : overridingMethods) {
                if (parameterIndex == -1) {
                    AnnotateOverriddenMethodsIntention.annotate((PsiModifierListOwner)overridingMethod, annotationName, attributes, annotationsToRemove, annotationsManager);
                    continue;
                }
                PsiParameterList parameterList = overridingMethod.getParameterList();
                PsiParameter[] parameters2 = parameterList.getParameters();
                PsiParameter parameter3 = parameters2[parameterIndex];
                AnnotateOverriddenMethodsIntention.annotate((PsiModifierListOwner)parameter3, annotationName, attributes, annotationsToRemove, annotationsManager);
            }
        }
        catch (ExternalAnnotationsManager.CanceledConfigurationException canceledConfigurationException) {
            // empty catch block
        }
        if (!prepare.isEmpty()) {
            UndoUtil.markPsiFileForUndo((PsiFile)annotation.getContainingFile());
        }
    }

    private static void annotate(PsiModifierListOwner modifierListOwner, String annotationName, PsiNameValuePair[] attributes, List<String> annotationsToRemove, ExternalAnnotationsManager annotationsManager) throws ProcessCanceledException {
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (modifierList.hasAnnotation(annotationName)) {
            return;
        }
        ExternalAnnotationsManager.AnnotationPlace annotationAnnotationPlace = annotationsManager.chooseAnnotationsPlace((PsiElement)modifierListOwner);
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.NOWHERE) {
            return;
        }
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.EXTERNAL) {
            for (String annotationToRemove : annotationsToRemove) {
                annotationsManager.deannotate(modifierListOwner, annotationToRemove);
            }
            try {
                annotationsManager.annotateExternally(modifierListOwner, annotationName, modifierListOwner.getContainingFile(), attributes);
            }
            catch (ExternalAnnotationsManager.CanceledConfigurationException canceledConfigurationException) {}
        } else {
            WriteAction.run(() -> {
                for (String annotationToRemove : annotationsToRemove) {
                    PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierListOwner, (String[])new String[]{annotationToRemove});
                    if (annotation == null) continue;
                    annotation.delete();
                }
                PsiAnnotation inserted = modifierList.addAnnotation(annotationName);
                for (PsiNameValuePair pair : attributes) {
                    inserted.setDeclaredAttributeValue(pair.getName(), pair.getValue());
                }
                JavaCodeStyleManager.getInstance((Project)modifierListOwner.getProject()).shortenClassReferences((PsiElement)inserted);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/annotation/AnnotateOverriddenMethodsIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/annotation/AnnotateOverriddenMethodsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

