/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.SuggestVariableNameMacro;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class HighlightUtils {
    private HighlightUtils() {
    }

    public static void highlightElement(@NotNull PsiElement element) {
        if (element == null) {
            HighlightUtils.$$$reportNull$$$0(0);
        }
        HighlightUtils.highlightElements(Collections.singleton(element));
    }

    public static void highlightElements(@NotNull Collection<? extends PsiElement> elementCollection) {
        if (elementCollection == null) {
            HighlightUtils.$$$reportNull$$$0(1);
        }
        if (elementCollection.isEmpty()) {
            return;
        }
        if (elementCollection.contains(null)) {
            throw new IllegalArgumentException("Nulls passed in collection: " + elementCollection);
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            if (elementCollection == null) {
                HighlightUtils.$$$reportNull$$$0(2);
            }
            Object[] elements = PsiUtilCore.toPsiElementArray((Collection)elementCollection);
            PsiElement firstElement = elements[0];
            if (ContainerUtil.exists((Object[])elements, element -> !element.isValid())) {
                return;
            }
            Project project = firstElement.getProject();
            if (project.isDisposed()) {
                return;
            }
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
            Editor editor = editorManager.getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            EditorColorsScheme globalScheme = editorColorsManager.getGlobalScheme();
            TextAttributes textattributes = globalScheme.getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            highlightManager.addOccurrenceHighlights(editor, (PsiElement[])elements, textattributes, true, null);
            WindowManager windowManager = WindowManager.getInstance();
            StatusBar statusBar = windowManager.getStatusBar(project);
            statusBar.setInfo(InspectionGadgetsBundle.message("press.escape.to.remove.highlighting.message", new Object[0]));
            FindManager findmanager = FindManager.getInstance((Project)project);
            FindModel findmodel = findmanager.getFindNextModel();
            if (findmodel == null) {
                findmodel = findmanager.getFindInFileModel();
            }
            findmodel.setSearchHighlighters(true);
            findmanager.setFindWasPerformed();
            findmanager.setFindNextModel(findmodel);
        });
    }

    public static void showRenameTemplate(PsiElement context, PsiNameIdentifierOwner element, PsiReference ... references) {
        Project project = (context = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)context)).getProject();
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Editor editor = fileEditorManager.getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl(context);
        MacroCallNode macroCallNode = new MacroCallNode((Macro)new SuggestVariableNameMacro());
        PsiElement identifier = element.getNameIdentifier();
        builder.replaceElement(identifier, "PATTERN", (Expression)macroCallNode, true);
        for (PsiReference reference : references) {
            builder.replaceElement(reference, "PATTERN", "PATTERN", false);
        }
        Template template = builder.buildInlineTemplate();
        TextRange textRange = context.getTextRange();
        int startOffset = textRange.getStartOffset();
        editor.getCaretModel().moveToOffset(startOffset);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        templateManager.startTemplate(editor, template);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementCollection";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/HighlightUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$highlightElements$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

