/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.JdomKt;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.FormBuilder;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.performance.CollectionsListSettings;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionsMustHaveInitialCapacityInspection
extends BaseInspection {
    private final CollectionsListSettings mySettings = new CollectionsListSettings(){

        protected Set<String> getDefaultSettings() {
            TreeSet<String> classes2 = new TreeSet<String>(DEFAULT_COLLECTION_LIST);
            classes2.add("java.util.BitSet");
            return classes2;
        }
    };
    public boolean myIgnoreFields;

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            CollectionsMustHaveInitialCapacityInspection.$$$reportNull$$$0(0);
        }
        this.mySettings.readSettings(node);
        this.myIgnoreFields = JDOMExternalizer.readBoolean((Element)node, (String)"ignoreFields");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            CollectionsMustHaveInitialCapacityInspection.$$$reportNull$$$0(1);
        }
        this.mySettings.writeSettings(node);
        if (this.myIgnoreFields) {
            JdomKt.addOptionTag((Element)node, (String)"ignoreFields", (String)Boolean.toString(true), (String)"setting");
        }
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new FormBuilder().addComponentFillVertically(this.mySettings.createOptionsPanel(), 0).addComponent((JComponent)new CheckBox("Don't report field initializers", (InspectionProfileEntry)this, "myIgnoreFields")).getPanel();
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("CollectionWithoutInitialCapacity" == null) {
            CollectionsMustHaveInitialCapacityInspection.$$$reportNull$$$0(2);
        }
        return "CollectionWithoutInitialCapacity";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("collections.must.have.initial.capacity.display.name", new Object[0]);
        if (string == null) {
            CollectionsMustHaveInitialCapacityInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("collections.must.have.initial.capacity.problem.descriptor", new Object[0]);
        if (string == null) {
            CollectionsMustHaveInitialCapacityInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionInitialCapacityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/performance/CollectionsMustHaveInitialCapacityInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/performance/CollectionsMustHaveInitialCapacityInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CollectionInitialCapacityVisitor
    extends BaseInspectionVisitor {
        private CollectionInitialCapacityVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                CollectionInitialCapacityVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression2);
            if (CollectionsMustHaveInitialCapacityInspection.this.myIgnoreFields && expression2.getParent() instanceof PsiField) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (!CollectionsMustHaveInitialCapacityInspection.this.mySettings.getCollectionClassesRequiringCapacity().contains(TypeUtils.resolvedClassName(type2))) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null || !argumentList.isEmpty()) {
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/CollectionsMustHaveInitialCapacityInspection$CollectionInitialCapacityVisitor", "visitNewExpression"));
        }
    }
}

