/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class CastThatLosesPrecisionInspection
extends BaseInspection {
    public boolean ignoreIntegerCharCasts = false;
    public boolean ignoreOverflowingByteCasts = false;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("NumericCastThatLosesPrecision" == null) {
            CastThatLosesPrecisionInspection.$$$reportNull$$$0(0);
        }
        return "NumericCastThatLosesPrecision";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cast.that.loses.precision.display.name", new Object[0]);
        if (string == null) {
            CastThatLosesPrecisionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType operandType = (PsiType)infos[0];
        boolean negativeOnly = (Boolean)infos[1];
        String string = InspectionGadgetsBundle.message(negativeOnly ? "cast.that.loses.precision.negative.problem.descriptor" : "cast.that.loses.precision.problem.descriptor", operandType.getPresentableText());
        if (string == null) {
            CastThatLosesPrecisionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("cast.that.loses.precision.option", new Object[0]), "ignoreIntegerCharCasts");
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.overflowing.byte.casts.option", new Object[0]), "ignoreOverflowingByteCasts");
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastThatLosesPrecisionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CastThatLosesPrecisionVisitor
    extends BaseInspectionVisitor {
        private CastThatLosesPrecisionVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression2) {
            LongRangeSet valueRange;
            PsiTypeElement castTypeElement;
            PsiMethod method;
            PsiType castType;
            if (expression2 == null) {
                CastThatLosesPrecisionVisitor.$$$reportNull$$$0(0);
            }
            if (!ClassUtils.isPrimitiveNumericType(castType = expression2.getType())) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiType operandType = operand2.getType();
            if (!ClassUtils.isPrimitiveNumericType(operandType) || !TypeUtils.isNarrowingConversion(operandType, castType)) {
                return;
            }
            if (CastThatLosesPrecisionInspection.this.ignoreIntegerCharCasts && PsiType.INT.equals((Object)operandType) && PsiType.CHAR.equals((Object)castType)) {
                return;
            }
            if (PsiType.LONG.equals((Object)operandType) && PsiType.INT.equals((Object)castType) && MethodUtils.isHashCode(method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}))) {
                return;
            }
            Object result = ExpressionUtils.computeConstantExpression(operand2);
            if (result instanceof Character) {
                result = (int)((Character)result).charValue();
            }
            if (result instanceof Number) {
                int i;
                Number number = (Number)result;
                if (CastThatLosesPrecisionInspection.this.ignoreOverflowingByteCasts && PsiType.INT.equals((Object)operandType) && PsiType.BYTE.equals((Object)castType) && (i = number.intValue()) > -128 && i <= 255) {
                    return;
                }
                if (this.valueIsContainableInType(number, castType)) {
                    return;
                }
            }
            if ((castTypeElement = expression2.getCastType()) == null) {
                return;
            }
            LongRangeSet targetRange = LongRangeSet.fromType(castType);
            LongRangeSet lostRange = LongRangeSet.all();
            if (targetRange != null && LongRangeSet.fromType(operandType) != null && (lostRange = (valueRange = this.getValueRange(operand2)).subtract(targetRange)).isEmpty()) {
                return;
            }
            this.registerError((PsiElement)castTypeElement, operandType, lostRange.max() < 0L);
        }

        private LongRangeSet getValueRange(@NotNull PsiExpression operand2) {
            LongRangeSet fact;
            if (operand2 == null) {
                CastThatLosesPrecisionVisitor.$$$reportNull$$$0(1);
            }
            return (fact = CommonDataflow.getExpressionFact(operand2, DfaFactType.RANGE)) == null ? LongRangeSet.all() : fact;
        }

        private boolean valueIsContainableInType(Number value2, PsiType type2) {
            long longValue = value2.longValue();
            double doubleValue = value2.doubleValue();
            if (PsiType.BYTE.equals((Object)type2)) {
                return longValue >= -128L && longValue <= 127L && doubleValue >= -128.0 && doubleValue <= 127.0;
            }
            if (PsiType.CHAR.equals((Object)type2)) {
                return longValue >= 0L && longValue <= 65535L && doubleValue >= 0.0 && doubleValue <= 65535.0;
            }
            if (PsiType.SHORT.equals((Object)type2)) {
                return longValue >= -32768L && longValue <= 32767L && doubleValue >= -32768.0 && doubleValue <= 32767.0;
            }
            if (PsiType.INT.equals((Object)type2)) {
                return longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE && doubleValue >= -2.147483648E9 && doubleValue <= 2.147483647E9;
            }
            if (PsiType.LONG.equals((Object)type2)) {
                return doubleValue >= -9.223372036854776E18 && doubleValue <= 9.223372036854776E18;
            }
            if (PsiType.FLOAT.equals((Object)type2)) {
                return doubleValue == (double)value2.floatValue();
            }
            return PsiType.DOUBLE.equals((Object)type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection$CastThatLosesPrecisionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeCastExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValueRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

