/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.RefactoringInspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RenameFix
extends RefactoringInspectionGadgetsFix {
    private final String m_targetName;
    private boolean m_searchInStrings = true;
    private boolean m_searchInNonJavaFiles = true;

    public RenameFix() {
        this.m_targetName = null;
    }

    public RenameFix(@NonNls String targetName) {
        this.m_targetName = targetName;
    }

    public RenameFix(@NonNls String targetName, boolean searchInStrings, boolean searchInNonJavaFiles) {
        this.m_targetName = targetName;
        this.m_searchInStrings = searchInStrings;
        this.m_searchInNonJavaFiles = searchInNonJavaFiles;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("rename.quickfix", new Object[0]);
        if (string == null) {
            RenameFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getName() {
        if (this.m_targetName == null) {
            String string = InspectionGadgetsBundle.message("rename.quickfix", new Object[0]);
            if (string == null) {
                RenameFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("renameto.quickfix", this.m_targetName);
        if (string == null) {
            RenameFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String getTargetName() {
        return this.m_targetName;
    }

    @NotNull
    public RefactoringActionHandler getHandler() {
        RefactoringActionHandler refactoringActionHandler = RefactoringActionHandlerFactory.getInstance().createRenameHandler();
        if (refactoringActionHandler == null) {
            RenameFix.$$$reportNull$$$0(3);
        }
        return refactoringActionHandler;
    }

    @NotNull
    public RefactoringActionHandler getHandler(DataContext context) {
        RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(context);
        Object object = renameHandler != null ? renameHandler : this.getHandler();
        if (object == null) {
            RenameFix.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        if (this.m_targetName == null) {
            super.doFix(project, descriptor);
        } else {
            PsiElement nameIdentifier = descriptor.getPsiElement();
            PsiElement elementToRename = nameIdentifier.getParent();
            RefactoringFactory factory = RefactoringFactory.getInstance((Project)project);
            RenameRefactoring renameRefactoring = factory.createRename(elementToRename, this.m_targetName, this.m_searchInStrings, this.m_searchInNonJavaFiles);
            renameRefactoring.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/RenameFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

