/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InitializationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryDefaultInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.default.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryDefaultInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.default.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryDefaultInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryDefaultVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/UnnecessaryDefaultInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryDefaultVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryDefaultVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                UnnecessaryDefaultVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(statement);
            PsiSwitchLabelStatement defaultStatement = UnnecessaryDefaultVisitor.retrieveUnnecessaryDefault(statement);
            if (defaultStatement == null) {
                return;
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)defaultStatement, PsiStatement.class);
            while (nextStatement != null && !(nextStatement instanceof PsiBreakStatement) && !(nextStatement instanceof PsiSwitchLabelStatement)) {
                if (nextStatement instanceof PsiThrowStatement || UnnecessaryDefaultVisitor.isStatementNeededForInitializationOfVariable(statement, nextStatement)) {
                    return;
                }
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            }
            this.registerStatementError((PsiStatement)defaultStatement, new Object[0]);
        }

        private static boolean isStatementNeededForInitializationOfVariable(PsiSwitchStatement switchStatement, PsiStatement statement) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiLocalVariable)) {
                return false;
            }
            PsiLocalVariable variable = (PsiLocalVariable)target;
            return InitializationUtils.switchStatementAssignsVariableOrFails(switchStatement, (PsiVariable)variable, true);
        }

        @Nullable
        private static PsiSwitchLabelStatement retrieveUnnecessaryDefault(PsiSwitchStatement statement) {
            PsiExpression expression2 = statement.getExpression();
            if (expression2 == null) {
                return null;
            }
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (aClass == null || !aClass.isEnum()) {
                return null;
            }
            PsiCodeBlock body2 = statement.getBody();
            if (body2 == null) {
                return null;
            }
            PsiStatement[] statements = body2.getStatements();
            int numCases = 0;
            PsiSwitchLabelStatement result = null;
            for (PsiStatement child : statements) {
                if (!(child instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)child;
                if (labelStatement.isDefaultCase()) {
                    result = labelStatement;
                    continue;
                }
                ++numCases;
            }
            if (result == null) {
                return null;
            }
            PsiField[] fields = aClass.getFields();
            int numEnums = 0;
            for (PsiField field : fields) {
                PsiType fieldType = field.getType();
                if (!fieldType.equals(type2)) continue;
                ++numEnums;
            }
            if (numEnums != numCases) {
                return null;
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/UnnecessaryDefaultInspection$UnnecessaryDefaultVisitor", "visitSwitchStatement"));
        }
    }
}

