/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EqualsWithItselfInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.with.itself.display.name", new Object[0]);
        if (string == null) {
            EqualsWithItselfInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.with.itself.problem.descriptor", new Object[0]);
        if (string == null) {
            EqualsWithItselfInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsWithItselfVisitor();
    }

    public static boolean isEqualsWithItself(PsiMethodCallExpression expression2) {
        if (!(MethodCallUtils.isEqualsCall(expression2) || MethodCallUtils.isEqualsIgnoreCaseCall(expression2) || MethodCallUtils.isCompareToCall(expression2) || MethodCallUtils.isCompareToIgnoreCaseCall(expression2))) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 1) {
            return false;
        }
        PsiExpression argument = ParenthesesUtils.stripParentheses(arguments[0]);
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null) {
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(qualifier, argument) && !SideEffectChecker.mayHaveSideEffects(qualifier);
        }
        return argument instanceof PsiThisExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/EqualsWithItselfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class EqualsWithItselfVisitor
    extends BaseInspectionVisitor {
        private EqualsWithItselfVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (EqualsWithItselfInspection.isEqualsWithItself(expression2)) {
                this.registerMethodCallError(expression2, new Object[0]);
            }
        }
    }
}

