/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.JavaSliceDereferenceUsage;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.util.BitUtil;
import com.intellij.util.FontUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

class SliceUsageCellRenderer
extends SliceUsageCellRendererBase {
    SliceUsageCellRenderer() {
    }

    public void customizeCellRendererFor(@NotNull SliceUsage sliceUsage) {
        SliceLanguageSupportProvider foreignSlicing;
        JavaLanguage language;
        String location;
        PsiMethod method;
        PsiClass aClass;
        if (sliceUsage == null) {
            SliceUsageCellRenderer.$$$reportNull$$$0(0);
        }
        boolean isForcedLeaf = sliceUsage instanceof JavaSliceDereferenceUsage;
        JavaSliceUsage javaSliceUsage = sliceUsage instanceof JavaSliceUsage ? (JavaSliceUsage)sliceUsage : null;
        TextChunk[] text2 = sliceUsage.getText();
        boolean isInsideContainer = javaSliceUsage != null && javaSliceUsage.indexNesting != 0;
        int length = text2.length;
        for (int i = 0; i < length; ++i) {
            TextChunk textChunk = text2[i];
            SimpleTextAttributes attributes = textChunk.getSimpleAttributesIgnoreBackground();
            if (isForcedLeaf) {
                attributes = attributes.derive(attributes.getStyle(), (Color)JBColor.LIGHT_GRAY, attributes.getBgColor(), attributes.getWaveColor());
            }
            boolean inUsage = BitUtil.isSet((int)attributes.getFontStyle(), (int)1);
            if (!isInsideContainer || inUsage) {
                // empty if block
            }
            this.append(textChunk.getText(), attributes);
            if (i != 0) continue;
            this.append(FontUtil.spaceAndThinSpace());
        }
        if (javaSliceUsage != null && javaSliceUsage.indexNesting != 0) {
            this.append(" (Tracking container '" + SliceUsageCellRenderer.getContainerName(javaSliceUsage) + (javaSliceUsage.syntheticField.isEmpty() ? "" : "." + javaSliceUsage.syntheticField) + "' contents)", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        PsiElement element = sliceUsage.getElement();
        while (true) {
            PsiClass psiClass = aClass = (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) : method.getContainingClass();
            if (!(aClass instanceof PsiAnonymousClass)) break;
            element = aClass;
        }
        int methodOptions = 4353;
        String string = method != null ? PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)methodOptions, (int)2, (int)2) : (location = aClass != null ? PsiFormatUtil.formatClass((PsiClass)aClass, (int)1) : null);
        if (location != null) {
            SimpleTextAttributes attributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
            this.append(" in " + location, attributes);
        }
        Object object = language = element == null ? JavaLanguage.INSTANCE : element.getLanguage();
        if (language != JavaLanguage.INSTANCE && (foreignSlicing = LanguageSlicing.getProvider((PsiElement)element)) == null) {
            this.append(" (in " + language.getDisplayName() + " file - stopped here)", SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
        }
    }

    @NotNull
    private static String getContainerName(@NotNull JavaSliceUsage usage) {
        if (usage == null) {
            SliceUsageCellRenderer.$$$reportNull$$$0(1);
        }
        String result = "";
        JavaSliceUsage prev = usage;
        String name = "";
        while (usage != null) {
            PsiElement element;
            if (usage.indexNesting != prev.indexNesting) {
                result = name + (result.isEmpty() ? "" : ".") + result;
                if (usage.indexNesting == 0) break;
            }
            if ((element = usage.getElement()) instanceof PsiNamedElement) {
                name = ((PsiNamedElement)element).getName();
            } else if (element instanceof PsiReference) {
                name = ((PsiReference)element).getCanonicalText();
            }
            prev = usage;
            usage = (JavaSliceUsage)usage.getParent();
        }
        String string = result;
        if (string == null) {
            SliceUsageCellRenderer.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sliceUsage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/SliceUsageCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/SliceUsageCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRendererFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContainerName";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

