/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.MatchUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class MethodDuplicatesMatchProvider
implements MatchProvider {
    private final PsiMethod myMethod;
    private final List<Match> myDuplicates;
    private static final Logger LOG = Logger.getInstance(MethodDuplicatesMatchProvider.class);

    MethodDuplicatesMatchProvider(PsiMethod method, List<Match> duplicates) {
        this.myMethod = method;
        this.myDuplicates = duplicates;
    }

    @Override
    public void prepareSignature(Match match) {
        MatchUtil.changeSignature(match, this.myMethod);
    }

    @Override
    public PsiElement processMatch(Match match) throws IncorrectOperationException {
        PsiElement var;
        PsiExpression value2;
        PsiParameter[] parameters2;
        PsiClass containingClass = this.myMethod.getContainingClass();
        if (this.isEssentialStaticContextAbsent(match)) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)this.myMethod, (String)"static", (boolean)true);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myMethod.getProject());
        boolean needQualifier = match.getInstanceExpression() != null;
        boolean needStaticQualifier = this.isExternal(match);
        boolean nameConflicts = this.nameConflicts(match);
        String methodName = this.myMethod.isConstructor() ? "this" : this.myMethod.getName();
        String text2 = needQualifier || needStaticQualifier || nameConflicts ? "q." + methodName + "()" : methodName + "()";
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)factory.createExpressionFromText(text2, null);
        methodCallExpression = (PsiMethodCallExpression)CodeStyleManager.getInstance((PsiManager)this.myMethod.getManager()).reformat((PsiElement)methodCallExpression);
        for (PsiParameter parameter2 : parameters2 = this.myMethod.getParameterList().getParameters()) {
            List<PsiElement> parameterValue = match.getParameterValues((PsiVariable)parameter2);
            if (parameterValue != null) {
                for (PsiElement val : parameterValue) {
                    methodCallExpression.getArgumentList().add(val);
                }
                continue;
            }
            methodCallExpression.getArgumentList().add((PsiElement)factory.createExpressionFromText(PsiTypesUtil.getDefaultValueOfType((PsiType)parameter2.getType()), (PsiElement)parameter2));
        }
        if (needQualifier || needStaticQualifier || nameConflicts) {
            PsiExpression qualifierExpression2 = methodCallExpression.getMethodExpression().getQualifierExpression();
            LOG.assertTrue(qualifierExpression2 != null);
            if (needQualifier) {
                qualifierExpression2.replace((PsiElement)match.getInstanceExpression());
            } else if (needStaticQualifier || this.myMethod.hasModifierProperty("static")) {
                qualifierExpression2.replace((PsiElement)factory.createReferenceExpression(containingClass));
            } else {
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)match.getMatchStart(), PsiClass.class);
                if (psiClass != null && psiClass.isInheritor(containingClass, true)) {
                    qualifierExpression2.replace((PsiElement)RefactoringChangeUtil.createSuperExpression(containingClass.getManager(), null));
                } else {
                    qualifierExpression2.replace((PsiElement)RefactoringChangeUtil.createThisExpression(containingClass.getManager(), containingClass));
                }
            }
        }
        VisibilityUtil.escalateVisibility((PsiMember)this.myMethod, (PsiElement)match.getMatchStart());
        PsiCodeBlock body2 = this.myMethod.getBody();
        assert (body2 != null);
        PsiStatement[] statements = body2.getStatements();
        if (statements[statements.length - 1] instanceof PsiReturnStatement && (value2 = ((PsiReturnStatement)statements[statements.length - 1]).getReturnValue()) instanceof PsiReferenceExpression && (var = ((PsiReferenceExpression)value2).resolve()) instanceof PsiVariable) {
            match.replace(this.myMethod, methodCallExpression, (PsiVariable)var);
            return methodCallExpression;
        }
        return match.replace(this.myMethod, methodCallExpression, null);
    }

    private boolean isExternal(Match match) {
        PsiElement matchStart = match.getMatchStart();
        PsiClass containingClass = this.myMethod.getContainingClass();
        if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)matchStart, (boolean)false)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)matchStart, PsiClass.class);
        while (psiClass != null) {
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)containingClass, (boolean)true)) {
                return false;
            }
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
        }
        return true;
    }

    private boolean nameConflicts(Match match) {
        PsiClass matchClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)match.getMatchStart(), PsiClass.class);
        while (matchClass != null && matchClass != this.myMethod.getContainingClass()) {
            if (matchClass.findMethodsBySignature(this.myMethod, false).length > 0) {
                return true;
            }
            matchClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)matchClass, PsiClass.class);
        }
        return false;
    }

    private boolean isEssentialStaticContextAbsent(Match match) {
        if (!this.myMethod.hasModifierProperty("static")) {
            PsiExpression instanceExpression = match.getInstanceExpression();
            if (instanceExpression != null) {
                return false;
            }
            if (this.isExternal(match)) {
                return true;
            }
            PsiElement matchStart = match.getMatchStart();
            PsiClass containingClass = this.myMethod.getContainingClass();
            if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)matchStart, (boolean)false)) {
                if (RefactoringUtil.isInStaticContext(matchStart, containingClass)) {
                    return true;
                }
            } else {
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)matchStart, PsiClass.class);
                while (psiClass != null) {
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)containingClass, (boolean)true)) {
                        if (!RefactoringUtil.isInStaticContext(matchStart, psiClass)) break;
                        return true;
                    }
                    psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
                }
            }
        }
        return false;
    }

    @Override
    public List<Match> getDuplicates() {
        return this.myDuplicates;
    }

    @Override
    public Boolean hasDuplicates() {
        return this.myDuplicates.isEmpty();
    }

    @Override
    @Nullable
    public String getConfirmDuplicatePrompt(Match match) {
        boolean needToEscalateVisibility;
        PsiElement matchStart = match.getMatchStart();
        String visibility = VisibilityUtil.getPossibleVisibility((PsiMember)this.myMethod, (PsiElement)matchStart);
        boolean shouldBeStatic = this.isEssentialStaticContextAbsent(match);
        String signature = MatchUtil.getChangedSignature(match, this.myMethod, this.myMethod.hasModifierProperty("static") || shouldBeStatic, visibility);
        if (signature != null) {
            return RefactoringBundle.message((String)"replace.this.code.fragment.and.change.signature", (Object[])new Object[]{signature});
        }
        boolean bl = needToEscalateVisibility = !PsiUtil.isAccessible((PsiMember)this.myMethod, (PsiElement)matchStart, null);
        if (needToEscalateVisibility) {
            String visibilityPresentation = VisibilityUtil.toPresentableText((String)visibility);
            return shouldBeStatic ? RefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.static.visible", (Object[])new Object[]{visibilityPresentation}) : RefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.visible", (Object[])new Object[]{visibilityPresentation});
        }
        if (shouldBeStatic) {
            return RefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.static");
        }
        return null;
    }

    @Override
    public String getReplaceDuplicatesTitle(int idx, int size) {
        return RefactoringBundle.message((String)"process.methods.duplicates.title", (Object[])new Object[]{idx, size, this.myMethod.getName()});
    }
}

