/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesHelper;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaMoveDirectoryWithClassesHelper
extends MoveDirectoryWithClassesHelper {
    public void findUsages(Collection<PsiFile> filesToMove, PsiDirectory[] directoriesToMove, Collection<UsageInfo> usages, boolean searchInComments, boolean searchInNonJavaFiles, Project project) {
        HashSet<String> packageNames = new HashSet<String>();
        for (PsiFile psiFile : filesToMove) {
            PsiClass[] classes2;
            if (!(psiFile instanceof PsiClassOwner)) continue;
            for (PsiClass aClass : classes2 = ((PsiClassOwner)psiFile).getClasses()) {
                Collections.addAll(usages, MoveClassesOrPackagesUtil.findUsages((PsiElement)aClass, searchInComments, searchInNonJavaFiles, aClass.getName()));
            }
            packageNames.add(((PsiClassOwner)psiFile).getPackageName());
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        for (String packageName : packageNames) {
            PsiPackage aPackage = psiFacade.findPackage(packageName);
            if (aPackage == null) continue;
            boolean remainsNothing = true;
            for (PsiDirectory packageDirectory : aPackage.getDirectories()) {
                if (JavaMoveDirectoryWithClassesHelper.isUnderRefactoring((PsiElement)packageDirectory, directoriesToMove)) continue;
                remainsNothing = false;
                break;
            }
            if (!remainsNothing) continue;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)aPackage, (SearchScope)GlobalSearchScope.projectScope((Project)project))) {
                PsiElement element = reference.getElement();
                PsiImportStatementBase statementBase = (PsiImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatementBase.class);
                if (statementBase == null || !statementBase.isOnDemand() || JavaMoveDirectoryWithClassesHelper.isUnderRefactoring((PsiElement)statementBase, directoriesToMove)) continue;
                usages.add(new RemoveOnDemandImportStatementsUsageInfo(statementBase));
            }
        }
    }

    private static boolean isUnderRefactoring(PsiElement psiElement, PsiDirectory[] directoriesToMove) {
        for (PsiDirectory directory : directoriesToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)directory, (PsiElement)psiElement, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public boolean move(PsiFile file, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewElementsMapping, List<PsiFile> movedFiles, RefactoringElementListener listener) {
        if (!(file instanceof PsiClassOwner)) {
            return false;
        }
        PsiClass[] classes2 = ((PsiClassOwner)file).getClasses();
        if (classes2.length == 0) {
            return false;
        }
        if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
            return false;
        }
        for (PsiClass psiClass : classes2) {
            PsiClass newClass = MoveClassesOrPackagesUtil.doMoveClass(psiClass, moveDestination);
            oldToNewElementsMapping.put((PsiElement)psiClass, (PsiElement)newClass);
            listener.elementMoved((PsiElement)newClass);
        }
        return true;
    }

    public void postProcessUsages(UsageInfo[] usages, Function<PsiDirectory, PsiDirectory> newDirMapper) {
        for (UsageInfo usage : usages) {
            PsiElement element;
            if (!(usage instanceof RemoveOnDemandImportStatementsUsageInfo) || (element = usage.getElement()) == null) continue;
            element.delete();
        }
    }

    public void preprocessUsages(Project project, Set<PsiFile> files, UsageInfo[] infos, PsiDirectory directory, MultiMap<PsiElement, String> conflicts) {
        PsiPackage aPackage;
        RefactoringConflictsUtil.analyzeModuleConflicts(project, files, infos, (PsiElement)directory, conflicts);
        if (directory != null && (aPackage = JavaDirectoryService.getInstance().getPackage(directory)) != null) {
            MoveClassesOrPackagesProcessor.detectPackageLocalsUsed(conflicts, files.toArray(PsiElement.EMPTY_ARRAY), new PackageWrapper(aPackage));
        }
    }

    public void beforeMove(PsiFile psiFile) {
        ChangeContextUtil.encodeContextInfo((PsiElement)psiFile, true);
    }

    public void afterMove(PsiElement newElement) {
        ChangeContextUtil.decodeContextInfo(newElement, null, null);
    }

    private static class RemoveOnDemandImportStatementsUsageInfo
    extends UsageInfo {
        RemoveOnDemandImportStatementsUsageInfo(PsiImportStatementBase statementBase) {
            super((PsiElement)statementBase);
        }
    }
}

