/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceParameterReferenceWithCall
extends FixableUsageInfo {
    private final PsiReferenceExpression expression;
    private final String newParameterName;
    private final String parameterGetterName;

    public ReplaceParameterReferenceWithCall(PsiReferenceExpression element, String newParameterName, String parameterGetterName) {
        super((PsiElement)element);
        this.parameterGetterName = parameterGetterName;
        this.newParameterName = newParameterName;
        this.expression = element;
    }

    public void fixUsage() throws IncorrectOperationException {
        String newExpression = this.newParameterName + '.' + this.parameterGetterName + "()";
        if (this.expression.isValid()) {
            MutationUtils.replaceExpression(newExpression, (PsiExpression)this.expression);
        }
    }
}

