/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ReferencedElementsCollector
extends JavaRecursiveElementVisitor {
    final HashSet<PsiMember> myReferencedMembers = new HashSet();

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        PsiElement psiElement = reference.resolve();
        if (psiElement instanceof PsiMember) {
            this.checkAddMember((PsiMember)psiElement);
        }
        super.visitReferenceElement(reference);
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        PsiMethod method = expression2.resolveMethod();
        if (method != null) {
            this.checkAddMember((PsiMember)method);
        }
        super.visitNewExpression(expression2);
    }

    protected void checkAddMember(@NotNull PsiMember member) {
        if (member == null) {
            ReferencedElementsCollector.$$$reportNull$$$0(0);
        }
        this.myReferencedMembers.add(member);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/inline/ReferencedElementsCollector", "checkAddMember"));
    }
}

