/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.extractclass.EnumTypeConversionRule;
import com.intellij.refactoring.extractclass.usageInfo.ReplaceStaticVariableAccess;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ExtractEnumProcessor {
    private final Project myProject;
    private final List<PsiField> myEnumConstants;
    private final PsiClass myClass;
    private TypeMigrationProcessor myTypeMigrationProcessor;

    public ExtractEnumProcessor(Project project, List<PsiField> enumConstants, PsiClass aClass) {
        this.myProject = project;
        this.myEnumConstants = enumConstants;
        this.myClass = aClass;
    }

    public void findEnumConstantConflicts(Ref<UsageInfo[]> refUsages) {
        if (this.hasUsages2Migrate()) {
            ArrayList<Object> resolvableConflicts = new ArrayList<Object>();
            for (UsageInfo failedUsage : this.myTypeMigrationProcessor.getLabeler().getFailedUsages()) {
                final PsiElement psiElement = failedUsage.getElement();
                if (psiElement instanceof PsiReferenceExpression) {
                    resolvableConflicts.add(new FixableUsageInfo(psiElement){

                        public void fixUsage() throws IncorrectOperationException {
                            PsiReferenceExpression expression2 = (PsiReferenceExpression)psiElement;
                            String link = GenerateMembersUtil.suggestGetterName("value", expression2.getType(), ExtractEnumProcessor.this.myProject) + "()";
                            MutationUtils.replaceExpression(expression2.getReferenceName() + "." + link, (PsiExpression)expression2);
                        }
                    });
                    continue;
                }
                if (psiElement == null) continue;
                resolvableConflicts.add((Object)new ConflictUsageInfo(psiElement, null));
            }
            if (!resolvableConflicts.isEmpty()) {
                ArrayList<Object> usageInfos = new ArrayList<Object>(Arrays.asList((Object[])refUsages.get()));
                Iterator iterator = resolvableConflicts.iterator();
                block1: while (iterator.hasNext()) {
                    UsageInfo conflict = (UsageInfo)iterator.next();
                    for (UsageInfo usageInfo : usageInfos) {
                        if (conflict.getElement() != usageInfo.getElement()) continue;
                        iterator.remove();
                        continue block1;
                    }
                }
                resolvableConflicts.addAll(0, usageInfos);
                refUsages.set((Object)resolvableConflicts.toArray(UsageInfo.EMPTY_ARRAY));
            }
        }
    }

    private boolean hasUsages2Migrate() {
        return this.myTypeMigrationProcessor != null;
    }

    public List<FixableUsageInfo> findEnumConstantUsages(List<? extends FixableUsageInfo> fieldUsages) {
        ArrayList<FixableUsageInfo> result = new ArrayList<FixableUsageInfo>();
        if (!this.myEnumConstants.isEmpty()) {
            HashSet<PsiSwitchStatement> switchStatements = new HashSet<PsiSwitchStatement>();
            for (UsageInfo usageInfo : fieldUsages) {
                Object element;
                PsiSwitchStatement psiSwitchStatement;
                if (!(usageInfo instanceof ReplaceStaticVariableAccess) || (psiSwitchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)(element = usageInfo.getElement()), PsiSwitchStatement.class)) == null) continue;
                switchStatements.add(psiSwitchStatement);
            }
            PsiConstantEvaluationHelper evaluationHelper = JavaPsiFacade.getInstance((Project)this.myProject).getConstantEvaluationHelper();
            HashSet<Object> hashSet = new HashSet<Object>();
            for (PsiField psiField : this.myEnumConstants) {
                hashSet.add(evaluationHelper.computeConstantExpression((PsiElement)psiField.getInitializer()));
            }
            PsiType enumValueType = this.myEnumConstants.get(0).getType();
            for (PsiSwitchStatement switchStatement : switchStatements) {
                PsiStatement errStatement = EnumConstantsUtil.isEnumSwitch(switchStatement, enumValueType, hashSet);
                if (errStatement != null) {
                    PsiExpression caseValue;
                    String description = null;
                    if (errStatement instanceof PsiSwitchLabelStatement && (caseValue = ((PsiSwitchLabelStatement)errStatement).getCaseValue()) != null) {
                        description = caseValue.getText() + " can not be replaced with enum";
                    }
                    result.add(new ConflictUsageInfo((PsiElement)errStatement, description));
                    continue;
                }
                PsiExpression expression2 = switchStatement.getExpression();
                if (expression2 instanceof PsiReferenceExpression) {
                    PsiElement element = ((PsiReferenceExpression)expression2).resolve();
                    if (element == null || element.getManager().isInProject(element)) continue;
                    result.add(new ConflictUsageInfo((PsiElement)expression2, StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false)) + " is out of project"));
                    continue;
                }
                result.add(new ConflictUsageInfo((PsiElement)expression2, null));
            }
            TypeMigrationRules typeMigrationRules = new TypeMigrationRules(this.myProject);
            typeMigrationRules.addConversionDescriptor(new EnumTypeConversionRule(this.myEnumConstants));
            typeMigrationRules.setBoundScope((SearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
            this.myTypeMigrationProcessor = new TypeMigrationProcessor(this.myProject, PsiUtilCore.toPsiElementArray(this.myEnumConstants), (Function<PsiElement, PsiType>)Functions.constant((Object)JavaPsiFacade.getElementFactory((Project)this.myProject).createType(this.myClass)), typeMigrationRules, true);
            for (UsageInfo usageInfo : this.myTypeMigrationProcessor.findUsages()) {
                PsiField enumConstantField;
                PsiElement migrateElement = usageInfo.getElement();
                if (migrateElement instanceof PsiField && (enumConstantField = (PsiField)migrateElement).hasModifierProperty("static") && enumConstantField.hasModifierProperty("final") && enumConstantField.hasInitializer() && !this.myEnumConstants.contains(enumConstantField)) continue;
                result.add(new EnumTypeMigrationUsageInfo(usageInfo));
            }
        }
        return result;
    }

    public void performEnumConstantTypeMigration(UsageInfo[] usageInfos) {
        if (this.hasUsages2Migrate()) {
            ArrayList<UsageInfo> migrationInfos = new ArrayList<UsageInfo>();
            for (UsageInfo usageInfo : usageInfos) {
                if (!(usageInfo instanceof EnumTypeMigrationUsageInfo)) continue;
                migrationInfos.add(((EnumTypeMigrationUsageInfo)usageInfo).getUsageInfo());
            }
            this.myTypeMigrationProcessor.performRefactoring(migrationInfos.toArray(UsageInfo.EMPTY_ARRAY));
        }
    }

    private static class ConflictUsageInfo
    extends FixableUsageInfo {
        private final String myDescription;

        ConflictUsageInfo(PsiElement expression2, String description) {
            super(expression2);
            this.myDescription = description;
        }

        public void fixUsage() throws IncorrectOperationException {
        }

        public String getConflictMessage() {
            return "Unable to migrate statement to enum constant." + (this.myDescription != null ? " " + this.myDescription : "");
        }
    }

    private static class EnumTypeMigrationUsageInfo
    extends FixableUsageInfo {
        private final UsageInfo myUsageInfo;

        EnumTypeMigrationUsageInfo(UsageInfo usageInfo) {
            super(usageInfo.getElement());
            this.myUsageInfo = usageInfo;
        }

        public void fixUsage() throws IncorrectOperationException {
        }

        public UsageInfo getUsageInfo() {
            return this.myUsageInfo;
        }
    }
}

