/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.DelegatingMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.extractInterface.ExtractInterfaceHandler;
import com.intellij.refactoring.extractInterface.ExtractInterfaceProcessor;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseProcessor;
import com.intellij.refactoring.extractSuperclass.JavaExtractSuperBaseDialog;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

class ExtractInterfaceDialog
extends JavaExtractSuperBaseDialog {
    ExtractInterfaceDialog(Project project, PsiClass sourceClass) {
        super(project, sourceClass, ExtractInterfaceDialog.collectMembers(sourceClass), ExtractInterfaceHandler.REFACTORING_NAME);
        for (MemberInfo memberInfo : this.myMemberInfos) {
            PsiMember member = (PsiMember)memberInfo.getMember();
            if (member instanceof PsiMethod && (member.hasModifierProperty("static") || member.hasModifierProperty("private"))) continue;
            memberInfo.setToAbstract(true);
        }
        this.init();
    }

    private static List<MemberInfo> collectMembers(PsiClass c) {
        return MemberInfo.extractClassMembers(c, new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                if (element instanceof PsiMethod) {
                    if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)element)) {
                        return true;
                    }
                    return element.hasModifierProperty("public") && (PsiUtil.isLanguageLevel8OrHigher((PsiElement)element) || !element.hasModifierProperty("static"));
                }
                if (element instanceof PsiField && !(element instanceof PsiEnumConstant)) {
                    return element.hasModifierProperty("final") && element.hasModifierProperty("static") && element.hasModifierProperty("public");
                }
                if (element instanceof PsiClass) {
                    return ((PsiClass)element).isInterface() || element.hasModifierProperty("static");
                }
                return false;
            }
        }, true);
    }

    protected String getClassNameLabelText() {
        return this.isExtractSuperclass() ? RefactoringBundle.message((String)"interface.name.prompt") : RefactoringBundle.message((String)"rename.implementation.class.to");
    }

    protected String getPackageNameLabelText() {
        return this.isExtractSuperclass() ? RefactoringBundle.message((String)"package.for.new.interface") : RefactoringBundle.message((String)"package.for.original.class");
    }

    protected String getEntityName() {
        return RefactoringBundle.message((String)"extractSuperInterface.interface");
    }

    protected String getTopLabelText() {
        return RefactoringBundle.message((String)"extract.interface.from");
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        MemberSelectionPanel memberSelectionPanel = new MemberSelectionPanel(RefactoringBundle.message((String)"members.to.form.interface"), this.myMemberInfos, RefactoringBundle.message((String)"make.abstract"));
        memberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)new DelegatingMemberInfoModel<PsiMember, MemberInfo>(memberSelectionPanel.getTable().getMemberInfoModel()){

            public Boolean isFixedAbstract(MemberInfo member) {
                return Boolean.TRUE;
            }
        });
        panel.add((Component)((Object)memberSelectionPanel), "Center");
        panel.add((Component)this.myDocCommentPanel, "East");
        return panel;
    }

    protected String getDocCommentPanelName() {
        return RefactoringBundle.message((String)"extractSuperInterface.javadoc");
    }

    protected String getExtractedSuperNameNotSpecifiedMessage() {
        return RefactoringBundle.message((String)"no.interface.name.specified");
    }

    protected int getDocCommentPolicySetting() {
        return JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_JAVADOC;
    }

    protected void setDocCommentPolicySetting(int policy) {
        JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_JAVADOC = policy;
    }

    protected ExtractSuperBaseProcessor createProcessor() {
        return new ExtractInterfaceProcessor(this.myProject, false, this.getTargetDirectory(), this.getExtractedSuperName(), (PsiClass)this.mySourceClass, (MemberInfo[])ArrayUtil.toObjectArray((Collection)this.getSelectedMemberInfos(), MemberInfo.class), new DocCommentPolicy(this.getDocCommentPolicy()));
    }

    protected String getHelpId() {
        return "refactoring.extractInterface";
    }
}

