/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiPackageReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    private final PackageReferenceSet myReferenceSet;
    protected final int myIndex;

    public PsiPackageReference(PackageReferenceSet set, TextRange range, int index) {
        super(set.getElement(), range, set.isSoft());
        this.myReferenceSet = set;
        this.myIndex = index;
    }

    @NotNull
    protected Set<PsiPackage> getContext() {
        if (this.myIndex == 0) {
            Set<PsiPackage> set = this.myReferenceSet.getInitialContext();
            if (set == null) {
                PsiPackageReference.$$$reportNull$$$0(0);
            }
            return set;
        }
        HashSet<PsiPackage> psiPackages = new HashSet<PsiPackage>();
        for (ResolveResult resolveResult : ((PsiPackageReference)this.myReferenceSet.getReference(this.myIndex - 1)).doMultiResolve()) {
            PsiElement psiElement = resolveResult.getElement();
            if (!(psiElement instanceof PsiPackage)) continue;
            psiPackages.add((PsiPackage)psiElement);
        }
        HashSet<PsiPackage> hashSet = psiPackages;
        if (hashSet == null) {
            PsiPackageReference.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public Object[] getVariants() {
        HashSet subPackages = new HashSet();
        for (PsiPackage psiPackage : this.getContext()) {
            ContainerUtil.addAll(subPackages, (Object[])psiPackage.getSubPackages(this.myReferenceSet.getResolveScope()));
        }
        Object[] objectArray = subPackages.toArray();
        if (objectArray == null) {
            PsiPackageReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = JavaErrorMessages.message("cannot.resolve.package", new Object[0]);
        if (string == null) {
            PsiPackageReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = this.doMultiResolve();
        if (resolveResultArray == null) {
            PsiPackageReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @NotNull
    protected ResolveResult[] doMultiResolve() {
        HashSet<PsiPackage> packages = new HashSet<PsiPackage>();
        for (PsiPackage parentPackage : this.getContext()) {
            packages.addAll(this.myReferenceSet.resolvePackageName(parentPackage, this.getValue()));
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(packages);
        if (resolveResultArray == null) {
            PsiPackageReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiPackageReference.$$$reportNull$$$0(6);
        }
        if (!(element instanceof PsiPackage)) {
            throw new IncorrectOperationException("Cannot bind to " + element);
        }
        TextRange range = new TextRange(((PsiPackageReference)this.getReferenceSet().getReference(0)).getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset());
        String newName = ((PsiPackage)element).getQualifiedName();
        return ElementManipulators.getManipulator((PsiElement)this.getElement()).handleContentChange(this.getElement(), range, newName);
    }

    public PackageReferenceSet getReferenceSet() {
        return this.myReferenceSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doMultiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

