/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.jsp.JspElementType;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class ShiftIndentInsideHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.Helper");
    private final CommonCodeStyleSettings mySettings;
    private final PsiFile myFile;
    private final IndentHelper myIndentIndentHelper;

    public ShiftIndentInsideHelper(@NotNull PsiFile file) {
        if (file == null) {
            ShiftIndentInsideHelper.$$$reportNull$$$0(0);
        }
        this.myFile = file;
        this.mySettings = CodeStyle.getLanguageSettings((PsiFile)file, (Language)JavaLanguage.INSTANCE);
        this.myIndentIndentHelper = IndentHelper.getInstance();
    }

    private static int getStartOffset(ASTNode root, ASTNode child) {
        if (child == root) {
            return 0;
        }
        ASTNode parent = child.getTreeParent();
        int offset = 0;
        for (ASTNode child1 = parent.getFirstChildNode(); child1 != child; child1 = child1.getTreeNext()) {
            offset += child1.getTextLength();
        }
        return ShiftIndentInsideHelper.getStartOffset(root, parent) + offset;
    }

    public ASTNode shiftIndentInside(ASTNode element, int indentShift) {
        if (indentShift == 0) {
            return element;
        }
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree((ASTNode)element);
        String text2 = element.getText();
        for (int offset = 0; offset < text2.length(); ++offset) {
            int commentIndent;
            ASTNode next;
            int offset1;
            char c = text2.charAt(offset);
            if (c != '\n' && c != '\r') continue;
            for (offset1 = offset + 1; offset1 < text2.length() && ((c = text2.charAt(offset1)) == ' ' || c == '\t'); ++offset1) {
            }
            if (c == '\n' || c == '\r') continue;
            String space = text2.substring(offset + 1, offset1);
            int indent = IndentHelperImpl.getIndent((PsiFile)this.myFile, (String)space, (boolean)true);
            int newIndent = indent + indentShift;
            newIndent = Math.max(newIndent, 0);
            String newSpace = IndentHelperImpl.fillIndent((CommonCodeStyleSettings.IndentOptions)CodeStyle.getIndentOptions((PsiFile)this.myFile), (int)newIndent);
            ASTNode leaf = element.findLeafElementAt(offset);
            if (!ShiftIndentInsideHelper.mayShiftIndentInside(leaf)) {
                LOG.error("Error", new String[]{leaf.getElementType().toString(), "Type: " + leaf.getElementType() + " text: " + leaf.getText()});
            }
            if (offset1 < text2.length() && (((next = element.findLeafElementAt(offset1)).getElementType() == JavaTokenType.END_OF_LINE_COMMENT || next.getElementType() == JavaTokenType.C_STYLE_COMMENT || next.getElementType() == JspTokenType.JSP_COMMENT) && next != element ? this.mySettings.KEEP_FIRST_COLUMN_COMMENT && (commentIndent = this.myIndentIndentHelper.getIndent(this.myFile, next, true)) == 0 : next.getElementType() == XmlTokenType.XML_DATA_CHARACTERS)) continue;
            int leafOffset = ShiftIndentInsideHelper.getStartOffset(element, leaf);
            if (leaf.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA && leafOffset + leaf.getTextLength() == offset + 1) {
                ASTNode next2 = element.findLeafElementAt(offset + 1);
                if (next2.getElementType() == TokenType.WHITE_SPACE) {
                    leaf = next2;
                    leafOffset = ShiftIndentInsideHelper.getStartOffset(element, leaf);
                } else {
                    if (!newSpace.isEmpty()) {
                        LeafElement newLeaf = ASTFactory.whitespace((CharSequence)newSpace);
                        next2.getTreeParent().addChild((ASTNode)newLeaf, next2);
                    }
                    text2 = text2.substring(0, offset + 1) + newSpace + text2.substring(offset1);
                    continue;
                }
            }
            int startOffset = offset + 1 - leafOffset;
            int endOffset = offset1 - leafOffset;
            if (!LOG.assertTrue(0 <= startOffset && startOffset <= endOffset && endOffset <= leaf.getTextLength())) continue;
            String leafText = leaf.getText();
            String newLeafText = leafText.substring(0, startOffset) + newSpace + leafText.substring(endOffset);
            if (!newLeafText.isEmpty()) {
                LeafElement newLeaf = Factory.createSingleLeafElement((IElementType)leaf.getElementType(), (CharSequence)newLeafText, (CharTable)charTableByTree, (PsiManager)SharedImplUtil.getManagerByTree((ASTNode)leaf));
                if (leaf.getTreeParent() != null) {
                    leaf.getTreeParent().replaceChild(leaf, (ASTNode)newLeaf);
                }
                if (leaf == element) {
                    element = newLeaf;
                }
            } else {
                ASTNode parent = leaf.getTreeParent();
                if (parent != null) {
                    parent.removeChild(leaf);
                }
            }
            text2 = text2.substring(0, offset + 1) + newSpace + text2.substring(offset1);
        }
        return element;
    }

    public static boolean mayShiftIndentInside(ASTNode leaf) {
        return ShiftIndentInsideHelper.isComment(leaf) && !ShiftIndentInsideHelper.checkJspTexts(leaf) || leaf.getElementType() == TokenType.WHITE_SPACE || leaf.getElementType() == XmlTokenType.XML_DATA_CHARACTERS || leaf.getElementType() == JspTokenType.JAVA_CODE || leaf.getElementType() == JspElementType.JSP_SCRIPTLET || leaf.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
    }

    private static boolean checkJspTexts(ASTNode leaf) {
        for (ASTNode child = leaf.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!(child instanceof OuterLanguageElement)) continue;
            return true;
        }
        return false;
    }

    private static boolean isComment(ASTNode node) {
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (psiElement instanceof PsiComment) {
            return true;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(psiElement.getLanguage());
        if (parserDefinition == null) {
            return false;
        }
        TokenSet commentTokens = parserDefinition.getCommentTokens();
        return commentTokens.contains(node.getElementType());
    }

    public FileType getFileType() {
        return this.myFile.getFileType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ShiftIndentInsideHelper", "<init>"));
    }
}

