/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaIndexPatternBuilder
implements IndexPatternBuilder {
    public static final TokenSet XML_DATA_CHARS = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_DATA_CHARACTERS});
    public static final TokenSet XML_COMMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_COMMENT_CHARACTERS});

    @Nullable
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (file == null) {
            JavaIndexPatternBuilder.$$$reportNull$$$0(0);
        }
        if (file instanceof PsiJavaFile && !(file instanceof JspFile)) {
            return JavaParserDefinition.createLexer(((PsiJavaFile)file).getLanguageLevel());
        }
        return null;
    }

    @Nullable
    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (file == null) {
            JavaIndexPatternBuilder.$$$reportNull$$$0(1);
        }
        if (file instanceof PsiJavaFile && !(file instanceof ServerPageFile)) {
            return TokenSet.orSet((TokenSet[])new TokenSet[]{StdTokenSets.COMMENT_BIT_SET, XML_COMMENT_BIT_SET, JavaDocTokenType.ALL_JAVADOC_TOKENS, XML_DATA_CHARS});
        }
        return null;
    }

    public int getCommentStartDelta(IElementType tokenType) {
        return tokenType == JavaTokenType.END_OF_LINE_COMMENT || tokenType == JavaTokenType.C_STYLE_COMMENT ? 2 : (tokenType == JavaDocElementType.DOC_COMMENT ? 3 : 0);
    }

    public int getCommentEndDelta(IElementType tokenType) {
        return tokenType == JavaTokenType.C_STYLE_COMMENT || tokenType == JavaDocElementType.DOC_COMMENT ? 2 : 0;
    }

    @NotNull
    public String getCharsAllowedInContinuationPrefix(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            JavaIndexPatternBuilder.$$$reportNull$$$0(2);
        }
        String string = tokenType == JavaTokenType.C_STYLE_COMMENT || tokenType == JavaDocElementType.DOC_COMMENT ? "*" : "";
        if (string == null) {
            JavaIndexPatternBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaIndexPatternBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaIndexPatternBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsAllowedInContinuationPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCommentTokenSet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCharsAllowedInContinuationPrefix";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

