/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightVariableBase
extends LightElement
implements PsiVariable,
OriginInfoAwareElement {
    protected PsiElement myScope;
    protected PsiIdentifier myNameIdentifier;
    protected PsiType myType;
    protected final PsiModifierList myModifierList;
    protected boolean myWritable;
    private String myOriginInfo;

    public LightVariableBase(PsiManager manager, PsiIdentifier nameIdentifier, PsiType type2, boolean writable, PsiElement scope) {
        this(manager, nameIdentifier, (Language)JavaLanguage.INSTANCE, type2, writable, scope);
    }

    public LightVariableBase(PsiManager manager, PsiIdentifier nameIdentifier, Language language, PsiType type2, boolean writable, PsiElement scope) {
        super(manager, language);
        this.myNameIdentifier = nameIdentifier;
        this.myWritable = writable;
        this.myType = type2;
        this.myScope = scope;
        this.myModifierList = this.createModifierList();
    }

    protected PsiModifierList createModifierList() {
        return new LightModifierList(this.getManager());
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement psiElement = this.myScope;
        if (psiElement == null) {
            LightVariableBase.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    public boolean isValid() {
        return this.myNameIdentifier == null || this.myNameIdentifier.isValid();
    }

    @NotNull
    public String getName() {
        String string = StringUtil.notNullize((String)this.getNameIdentifier().getText());
        if (string == null) {
            LightVariableBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            LightVariableBase.$$$reportNull$$$0(2);
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    @NotNull
    public PsiType getType() {
        if (this.myType == null) {
            this.myType = this.computeType();
        }
        PsiType psiType = this.myType;
        if (psiType == null) {
            LightVariableBase.$$$reportNull$$$0(3);
        }
        return psiType;
    }

    @NotNull
    protected PsiType computeType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
        if (psiPrimitiveType == null) {
            LightVariableBase.$$$reportNull$$$0(4);
        }
        return psiPrimitiveType;
    }

    @NotNull
    public PsiTypeElement getTypeElement() {
        PsiTypeElement psiTypeElement = JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeElement(this.myType);
        if (psiTypeElement == null) {
            LightVariableBase.$$$reportNull$$$0(5);
        }
        return psiTypeElement;
    }

    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            LightVariableBase.$$$reportNull$$$0(6);
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public String getText() {
        return this.myNameIdentifier.getText();
    }

    public Object computeConstantValue() {
        return null;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    public boolean isWritable() {
        return this.myWritable;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.VARIABLE_ICON, (PsiModifierListOwner)this, false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(String originInfo) {
        this.myOriginInfo = originInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightVariableBase";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightVariableBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

