/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtendsListBlock
extends AbstractJavaBlock {
    public ExtendsListBlock(ASTNode node, Wrap wrap, Alignment alignment, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (formattingMode == null) {
            ExtendsListBlock.$$$reportNull$$$0(0);
        }
        super(node, wrap, alignment, Indent.getNoneIndent(), settings, javaSettings, formattingMode);
    }

    public ExtendsListBlock(ASTNode node, Wrap wrap, AlignmentStrategy alignmentStrategy, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (formattingMode == null) {
            ExtendsListBlock.$$$reportNull$$$0(1);
        }
        super(node, wrap, alignmentStrategy, Indent.getNoneIndent(), settings, javaSettings, formattingMode);
    }

    protected List<Block> buildChildren() {
        Alignment alignment;
        ArrayList<Block> result = new ArrayList<Block>();
        ArrayList<Object> elementsExceptKeyword = new ArrayList<Block>();
        this.myChildAlignment = this.createChildAlignment();
        this.myChildIndent = Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
        this.myUseChildAttributes = true;
        Wrap childWrap = this.createChildWrap();
        Object object = alignment = this.alignList() ? Alignment.createAlignment() : null;
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) || child.getTextLength() <= 0) continue;
            IElementType elementType = child.getElementType();
            if (ElementType.KEYWORD_BIT_SET.contains(elementType)) {
                if (!elementsExceptKeyword.isEmpty()) {
                    result.add(new SyntheticCodeBlock(elementsExceptKeyword, null, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null));
                    elementsExceptKeyword = new ArrayList();
                }
                Indent indent = this.mySettings.ALIGN_THROWS_KEYWORD && elementType == JavaTokenType.THROWS_KEYWORD ? Indent.getNoneIndent() : this.myChildIndent;
                result.add(this.createJavaBlock(child, this.mySettings, this.myJavaSettings, indent, this.arrangeChildWrap(child, childWrap), alignment, this.getFormattingMode()));
                continue;
            }
            Alignment candidate = this.myAlignmentStrategy.getAlignment(elementType);
            if (candidate != null) {
                alignment = this.myChildAlignment = candidate;
            }
            this.processChild(elementsExceptKeyword, child, this.myChildAlignment, childWrap, this.myChildIndent);
        }
        if (!elementsExceptKeyword.isEmpty()) {
            result.add(new SyntheticCodeBlock(elementsExceptKeyword, alignment, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null));
        }
        return result;
    }

    private boolean alignList() {
        if (this.myNode.getElementType() == JavaElementType.EXTENDS_LIST || this.myNode.getElementType() == JavaElementType.IMPLEMENTS_LIST) {
            return this.mySettings.ALIGN_MULTILINE_EXTENDS_LIST;
        }
        if (this.myNode.getElementType() == JavaElementType.THROWS_LIST) {
            return this.mySettings.ALIGN_MULTILINE_THROWS_LIST;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formattingMode", "com/intellij/psi/formatter/java/ExtendsListBlock", "<init>"));
    }
}

