/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerProjectExtensionImpl
extends CompilerProjectExtension {
    @NonNls
    private static final String OUTPUT_TAG = "output";
    @NonNls
    private static final String URL = "url";
    private VirtualFilePointer myCompilerOutput;
    private LocalFileSystem.WatchRequest myCompilerOutputWatchRequest;
    private final Project myProject;

    public CompilerProjectExtensionImpl(Project project) {
        this.myProject = project;
    }

    private void readExternal(Element element) {
        Element outputPathChild = element.getChild(OUTPUT_TAG);
        if (outputPathChild != null) {
            String outputPath = outputPathChild.getAttributeValue(URL);
            this.myCompilerOutput = VirtualFilePointerManager.getInstance().create(outputPath, (Disposable)this.myProject, null);
        }
    }

    private void writeExternal(Element element) {
        if (this.myCompilerOutput != null) {
            Element pathElement = new Element(OUTPUT_TAG);
            pathElement.setAttribute(URL, this.myCompilerOutput.getUrl());
            element.addContent(pathElement);
        }
    }

    @Nullable
    public VirtualFile getCompilerOutput() {
        if (this.myCompilerOutput == null) {
            return null;
        }
        return this.myCompilerOutput.getFile();
    }

    @Nullable
    public String getCompilerOutputUrl() {
        if (this.myCompilerOutput == null) {
            return null;
        }
        return this.myCompilerOutput.getUrl();
    }

    public VirtualFilePointer getCompilerOutputPointer() {
        return this.myCompilerOutput;
    }

    public void setCompilerOutputPointer(VirtualFilePointer pointer) {
        this.myCompilerOutput = pointer;
    }

    public void setCompilerOutputUrl(String compilerOutputUrl) {
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(compilerOutputUrl, (Disposable)this.myProject, null);
        this.setCompilerOutputPointer(pointer);
        String path = VfsUtilCore.urlToPath((String)compilerOutputUrl);
        this.myCompilerOutputWatchRequest = LocalFileSystem.getInstance().replaceWatchedRoot(this.myCompilerOutputWatchRequest, path, true);
    }

    @NotNull
    private Set<String> getRootsToWatch() {
        Module[] modules;
        HashSet<String> rootsToWatch = new HashSet<String>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String compilerOutputPathForTests;
            String compilerOutputPath = ProjectRootManagerImpl.extractLocalPath((String)CompilerModuleExtension.getInstance((Module)module).getCompilerOutputUrl());
            if (compilerOutputPath.length() > 0) {
                rootsToWatch.add(compilerOutputPath);
            }
            if ((compilerOutputPathForTests = ProjectRootManagerImpl.extractLocalPath((String)CompilerModuleExtension.getInstance((Module)module).getCompilerOutputUrlForTests())).length() <= 0) continue;
            rootsToWatch.add(compilerOutputPathForTests);
        }
        if (this.myCompilerOutput != null) {
            String url = this.myCompilerOutput.getUrl();
            rootsToWatch.add(ProjectRootManagerImpl.extractLocalPath((String)url));
        }
        HashSet<String> hashSet = rootsToWatch;
        if (hashSet == null) {
            CompilerProjectExtensionImpl.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static CompilerProjectExtensionImpl getImpl(Project project) {
        return (CompilerProjectExtensionImpl)CompilerProjectExtension.getInstance((Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/CompilerProjectExtensionImpl", "getRootsToWatch"));
    }

    public static class MyWatchedRootsProvider
    implements WatchedRootsProvider {
        private final Project myProject;

        public MyWatchedRootsProvider(Project project) {
            this.myProject = project;
        }

        @NotNull
        public Set<String> getRootsToWatch() {
            Set set = CompilerProjectExtensionImpl.getImpl(this.myProject).getRootsToWatch();
            if (set == null) {
                MyWatchedRootsProvider.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/CompilerProjectExtensionImpl$MyWatchedRootsProvider", "getRootsToWatch"));
        }
    }

    public static class MyProjectExtension
    extends ProjectExtension {
        private final Project myProject;

        public MyProjectExtension(Project project) {
            this.myProject = project;
        }

        public void readExternal(@NotNull Element element) {
            if (element == null) {
                MyProjectExtension.$$$reportNull$$$0(0);
            }
            CompilerProjectExtensionImpl.getImpl(this.myProject).readExternal(element);
        }

        public void writeExternal(@NotNull Element element) {
            if (element == null) {
                MyProjectExtension.$$$reportNull$$$0(1);
            }
            CompilerProjectExtensionImpl.getImpl(this.myProject).writeExternal(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/openapi/roots/impl/CompilerProjectExtensionImpl$MyProjectExtension";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readExternal";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeExternal";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

