/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class SuperMethodWarningDialog
extends DialogWrapper {
    static final int NO_EXIT_CODE = 3;
    private final String myName;
    private final String[] myClassNames;
    private final String myActionString;
    private final boolean myIsSuperAbstract;
    private final boolean myIsParentInterface;
    private final boolean myIsContainedInInterface;

    SuperMethodWarningDialog(@NotNull Project project, @NotNull String name, @NotNull String actionString, boolean isSuperAbstract, boolean isParentInterface, boolean isContainedInInterface, String ... classNames) {
        if (project == null) {
            SuperMethodWarningDialog.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SuperMethodWarningDialog.$$$reportNull$$$0(1);
        }
        if (actionString == null) {
            SuperMethodWarningDialog.$$$reportNull$$$0(2);
        }
        if (classNames == null) {
            SuperMethodWarningDialog.$$$reportNull$$$0(3);
        }
        super(project, true);
        this.myName = name;
        this.myClassNames = classNames;
        this.myActionString = actionString;
        this.myIsSuperAbstract = isSuperAbstract;
        this.myIsParentInterface = isParentInterface;
        this.myIsContainedInInterface = isContainedInInterface;
        this.setTitle(IdeBundle.message((String)"title.warning", (Object[])new Object[0]));
        this.setButtonsAlignment(0);
        this.setOKButtonText(CommonBundle.getYesButtonText());
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), new NoAction(), this.getCancelAction()};
        if (actionArray == null) {
            SuperMethodWarningDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    public JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JLabel iconLabel = new JLabel(Messages.getQuestionIcon());
        panel.add((Component)iconLabel, "West");
        JPanel labelsPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        labelsPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 10));
        String classType = this.myIsParentInterface ? IdeBundle.message((String)"element.of.interface", (Object[])new Object[0]) : IdeBundle.message((String)"element.of.class", (Object[])new Object[0]);
        String methodString = IdeBundle.message((String)"element.method", (Object[])new Object[0]);
        labelsPanel.add(new JLabel(IdeBundle.message((String)"label.method", (Object[])new Object[]{this.myName})));
        if (this.myClassNames.length == 1) {
            String className = this.myClassNames[0];
            labelsPanel.add(new JLabel(this.myIsContainedInInterface || !this.myIsSuperAbstract ? IdeBundle.message((String)"label.overrides.method.of_class_or_interface.name", (Object[])new Object[]{methodString, classType, className}) : IdeBundle.message((String)"label.implements.method.of_class_or_interface.name", (Object[])new Object[]{methodString, classType, className})));
        } else {
            JLabel multLabel = new JLabel(IdeBundle.message((String)"label.implements.method.of_interfaces", (Object[])new Object[0]));
            multLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            labelsPanel.add(multLabel);
            for (String className : this.myClassNames) {
                labelsPanel.add(new JLabel("    " + className));
            }
        }
        JLabel doYouWantLabel = new JLabel(IdeBundle.message((String)"prompt.do.you.want.to.action_verb.the.method.from_class", (Object[])new Object[]{this.myActionString, this.myClassNames.length}));
        doYouWantLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        labelsPanel.add(doYouWantLabel);
        panel.add((Component)labelsPanel, "Center");
        return panel;
    }

    public static String capitalize(String text2) {
        return Character.toUpperCase(text2.charAt(0)) + text2.substring(1);
    }

    public JComponent createCenterPanel() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/SuperMethodWarningDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/SuperMethodWarningDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NoAction
    extends AbstractAction {
        private NoAction() {
            super(CommonBundle.getNoButtonText());
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                NoAction.$$$reportNull$$$0(0);
            }
            SuperMethodWarningDialog.this.close(3);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/SuperMethodWarningDialog$NoAction", "actionPerformed"));
        }
    }
}

