/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.ClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class ClassesTreeStructureProvider
implements SelectableTreeStructureProvider,
DumbAware {
    private final Project myProject;

    public ClassesTreeStructureProvider(@NotNull Project project) {
        if (project == null) {
            ClassesTreeStructureProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            ClassesTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (children == null) {
            ClassesTreeStructureProvider.$$$reportNull$$$0(2);
        }
        Collection collection = (Collection)AbstractTreeUi.calculateYieldingToWriteAction(() -> {
            if (parent == null) {
                ClassesTreeStructureProvider.$$$reportNull$$$0(7);
            }
            if (children == null) {
                ClassesTreeStructureProvider.$$$reportNull$$$0(8);
            }
            return this.doModify(parent, children);
        });
        if (collection == null) {
            ClassesTreeStructureProvider.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    private Collection<AbstractTreeNode> doModify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children) {
        if (parent == null) {
            ClassesTreeStructureProvider.$$$reportNull$$$0(4);
        }
        if (children == null) {
            ClassesTreeStructureProvider.$$$reportNull$$$0(5);
        }
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode child : children) {
            ProgressManager.checkCanceled();
            Object o = child.getValue();
            if (o instanceof PsiClassOwner && !(o instanceof ServerPageFile)) {
                ViewSettings settings1 = ((ProjectViewNode)parent).getSettings();
                PsiClassOwner classOwner = (PsiClassOwner)o;
                VirtualFile file = classOwner.getVirtualFile();
                if (!(classOwner instanceof PsiCompiledElement)) {
                    PsiFile classFile;
                    VirtualFile virtualClassFile;
                    PsiElement originalElement;
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
                    if (file != null && fileIndex.isInLibrarySource(file) && (originalElement = classOwner.getOriginalElement()) instanceof PsiFile && (virtualClassFile = (classFile = (PsiFile)originalElement).getVirtualFile()) != null && fileIndex.isInLibraryClasses(virtualClassFile) && !classOwner.getManager().areElementsEquivalent((PsiElement)classOwner, (PsiElement)classFile) && classOwner.getManager().areElementsEquivalent((PsiElement)classOwner.getContainingDirectory(), (PsiElement)classFile.getContainingDirectory())) continue;
                }
                if (this.fileInRoots(file)) {
                    PsiClass[] classes2 = (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)classOwner).getClasses());
                    if (classes2.length == 1 && ClassesTreeStructureProvider.isClassForTreeNode(file, classes2[0])) {
                        result.add((AbstractTreeNode)new ClassTreeNode(this.myProject, classes2[0], settings1));
                        continue;
                    }
                    result.add((AbstractTreeNode)new PsiClassOwnerTreeNode(classOwner, settings1));
                    continue;
                }
            }
            result.add(child);
        }
        ArrayList<AbstractTreeNode> arrayList = result;
        if (arrayList == null) {
            ClassesTreeStructureProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static boolean isClassForTreeNode(VirtualFile file, PsiClass psiClass) {
        if (psiClass == null || psiClass instanceof SyntheticElement) {
            return false;
        }
        if (file == null || file.getNameWithoutExtension().equals(psiClass.getName())) {
            return true;
        }
        Project project = psiClass.getProject();
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            TextEditor textEditor = (TextEditor)fileEditor;
            Template template = TemplateManager.getInstance((Project)project).getActiveTemplate(textEditor.getEditor());
            if (template == null) continue;
            return true;
        }
        return false;
    }

    private boolean fileInRoots(VirtualFile file) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return file != null && (index.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) || index.isInLibraryClasses(file) || index.isInLibrarySource(file));
    }

    public PsiElement getTopLevelElement(PsiElement element) {
        PsiClass[] classes2;
        PsiElement current;
        PsiFile baseRootFile = ClassesTreeStructureProvider.getBaseRootFile(element);
        if (baseRootFile == null) {
            return null;
        }
        if (!this.fileInRoots(baseRootFile.getVirtualFile())) {
            return baseRootFile;
        }
        for (current = element; current != null && !ClassesTreeStructureProvider.isSelectable(current) && !ClassesTreeStructureProvider.isTopLevelClass(current); current = current.getParent()) {
        }
        if (current instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)current).getClasses()).length == 1 && !(classes2[0] instanceof SyntheticElement) && ClassesTreeStructureProvider.isTopLevelClass((PsiElement)classes2[0])) {
            current = classes2[0];
        }
        return current != null ? current : baseRootFile;
    }

    private static boolean isSelectable(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return true;
        }
        if (element instanceof PsiJavaModule) {
            return true;
        }
        if (element instanceof PsiField || element instanceof PsiClass || element instanceof PsiMethod) {
            return !(element instanceof PsiAnonymousClass) && !(element.getParent() instanceof PsiAnonymousClass);
        }
        return false;
    }

    @Nullable
    private static PsiFile getBaseRootFile(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    private static boolean isTopLevelClass(PsiElement element) {
        return element instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)((PsiClass)element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ClassesTreeStructureProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ClassesTreeStructureProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doModify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doModify";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modify$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PsiClassOwnerTreeNode
    extends PsiFileNode {
        PsiClassOwnerTreeNode(@NotNull PsiClassOwner classOwner, ViewSettings settings) {
            if (classOwner == null) {
                PsiClassOwnerTreeNode.$$$reportNull$$$0(0);
            }
            super(classOwner.getProject(), (PsiFile)classOwner, settings);
        }

        public Collection<AbstractTreeNode> getChildrenImpl() {
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            PsiFile value2 = (PsiFile)this.getValue();
            if (value2 instanceof PsiClassOwner) {
                ViewSettings settings = this.getSettings();
                for (PsiClass aClass : ((PsiClassOwner)value2).getClasses()) {
                    if (aClass instanceof SyntheticElement) continue;
                    result.add((AbstractTreeNode)new ClassTreeNode(this.myProject, aClass, settings));
                }
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOwner", "com/intellij/ide/projectView/impl/ClassesTreeStructureProvider$PsiClassOwnerTreeNode", "<init>"));
        }
    }
}

