/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.smartPointerPsiNodes.MethodSmartPointerNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiMethodFavoriteNodeProvider
extends FavoriteNodeProvider {
    public Collection<AbstractTreeNode> getFavoriteNodes(DataContext context, @NotNull ViewSettings viewSettings) {
        PsiElement element;
        Project project;
        if (viewSettings == null) {
            PsiMethodFavoriteNodeProvider.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
            return null;
        }
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (elements == null && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) != null) {
            elements = new PsiElement[]{element};
        }
        if (elements != null) {
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            for (PsiElement element2 : elements) {
                if (!(element2 instanceof PsiMethod)) continue;
                result.add((AbstractTreeNode)new MethodSmartPointerNode(project, (PsiMethod)element2, viewSettings));
            }
            return result.isEmpty() ? null : result;
        }
        return null;
    }

    public AbstractTreeNode createNode(Project project, Object element, @NotNull ViewSettings viewSettings) {
        if (viewSettings == null) {
            PsiMethodFavoriteNodeProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiMethod) {
            return new MethodSmartPointerNode(project, (PsiMethod)element, viewSettings);
        }
        return super.createNode(project, element, viewSettings);
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        return false;
    }

    public int getElementWeight(Object value2, boolean isSortByType) {
        if (value2 instanceof PsiMethod) {
            return 5;
        }
        return -1;
    }

    public String getElementLocation(Object element) {
        PsiClass parent;
        if (element instanceof PsiMethod && (parent = ((PsiMethod)element).getContainingClass()) != null) {
            return ClassPresentationUtil.getNameForClass(parent, true);
        }
        return null;
    }

    public boolean isInvalidElement(Object element) {
        return element instanceof PsiMethod && !((PsiMethod)element).isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        if ("method" == null) {
            PsiMethodFavoriteNodeProvider.$$$reportNull$$$0(2);
        }
        return "method";
    }

    public String getElementUrl(Object element) {
        if (element instanceof PsiMethod) {
            PsiMethod aMethod = (PsiMethod)element;
            if (DumbService.isDumb((Project)aMethod.getProject())) {
                return null;
            }
            return PsiFormatUtil.getExternalName((PsiModifierListOwner)aMethod);
        }
        return null;
    }

    public String getElementModuleName(Object element) {
        if (element instanceof PsiMethod) {
            PsiMethod aMethod = (PsiMethod)element;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aMethod);
            return module != null ? module.getName() : null;
        }
        return null;
    }

    public Object[] createPathFromUrl(Project project, String url, String moduleName) {
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        PsiMethod method = RefMethodImpl.findPsiMethod(PsiManager.getInstance((Project)project), url);
        if (method == null) {
            return null;
        }
        return new Object[]{method};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/PsiMethodFavoriteNodeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/PsiMethodFavoriteNodeProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoriteTypeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFavoriteNodes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

