/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandler;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.lang.java.JavaFindUsagesProvider;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class JavaFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    private final JavaClassFindUsagesOptions myFindClassOptions;
    private final JavaMethodFindUsagesOptions myFindMethodOptions;
    private final JavaPackageFindUsagesOptions myFindPackageOptions;
    private final JavaThrowFindUsagesOptions myFindThrowOptions;
    private final JavaVariableFindUsagesOptions myFindVariableOptions;

    public static JavaFindUsagesHandlerFactory getInstance(@NotNull Project project) {
        if (project == null) {
            JavaFindUsagesHandlerFactory.$$$reportNull$$$0(0);
        }
        return (JavaFindUsagesHandlerFactory)((Object)ContainerUtil.findInstance((Object[])EP_NAME.getExtensions((AreaInstance)project), JavaFindUsagesHandlerFactory.class));
    }

    public JavaFindUsagesHandlerFactory(Project project) {
        this.myFindClassOptions = new JavaClassFindUsagesOptions(project);
        this.myFindMethodOptions = new JavaMethodFindUsagesOptions(project);
        this.myFindPackageOptions = new JavaPackageFindUsagesOptions(project);
        this.myFindThrowOptions = new JavaThrowFindUsagesOptions(project);
        this.myFindVariableOptions = new JavaVariableFindUsagesOptions(project);
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            JavaFindUsagesHandlerFactory.$$$reportNull$$$0(1);
        }
        return new JavaFindUsagesProvider().canFindUsagesFor(element);
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            JavaFindUsagesHandlerFactory.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiDirectory) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
            return psiPackage == null ? null : new JavaFindUsagesHandler((PsiElement)psiPackage, this);
        }
        if (element instanceof PsiMethod && !forHighlightUsages) {
            PsiMethod[] methods = SuperMethodWarningUtil.checkSuperMethods((PsiMethod)element, JavaFindUsagesHandler.ACTION_STRING);
            if (methods.length > 1) {
                return new JavaFindUsagesHandler(element, (PsiElement[])methods, this);
            }
            if (methods.length == 1) {
                return new JavaFindUsagesHandler((PsiElement)methods[0], this);
            }
            return FindUsagesHandler.NULL_HANDLER;
        }
        return new JavaFindUsagesHandler(element, this);
    }

    @NotNull
    public JavaClassFindUsagesOptions getFindClassOptions() {
        JavaClassFindUsagesOptions javaClassFindUsagesOptions = this.myFindClassOptions;
        if (javaClassFindUsagesOptions == null) {
            JavaFindUsagesHandlerFactory.$$$reportNull$$$0(3);
        }
        return javaClassFindUsagesOptions;
    }

    @NotNull
    public JavaMethodFindUsagesOptions getFindMethodOptions() {
        JavaMethodFindUsagesOptions javaMethodFindUsagesOptions = this.myFindMethodOptions;
        if (javaMethodFindUsagesOptions == null) {
            JavaFindUsagesHandlerFactory.$$$reportNull$$$0(4);
        }
        return javaMethodFindUsagesOptions;
    }

    @NotNull
    public JavaPackageFindUsagesOptions getFindPackageOptions() {
        JavaPackageFindUsagesOptions javaPackageFindUsagesOptions = this.myFindPackageOptions;
        if (javaPackageFindUsagesOptions == null) {
            JavaFindUsagesHandlerFactory.$$$reportNull$$$0(5);
        }
        return javaPackageFindUsagesOptions;
    }

    @NotNull
    public JavaThrowFindUsagesOptions getFindThrowOptions() {
        JavaThrowFindUsagesOptions javaThrowFindUsagesOptions = this.myFindThrowOptions;
        if (javaThrowFindUsagesOptions == null) {
            JavaFindUsagesHandlerFactory.$$$reportNull$$$0(6);
        }
        return javaThrowFindUsagesOptions;
    }

    @NotNull
    public JavaVariableFindUsagesOptions getFindVariableOptions() {
        JavaVariableFindUsagesOptions javaVariableFindUsagesOptions = this.myFindVariableOptions;
        if (javaVariableFindUsagesOptions == null) {
            JavaFindUsagesHandlerFactory.$$$reportNull$$$0(7);
        }
        return javaVariableFindUsagesOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/JavaFindUsagesHandlerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/JavaFindUsagesHandlerFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindClassOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindMethodOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindPackageOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindThrowOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindVariableOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFindUsagesHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

