/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reflectiveAccess.JavaLangInvokeHandleSignatureInspection;
import com.intellij.codeInspection.reflectiveAccess.JavaReflectionInvocationInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaLangReflectHandleInvocationChecker {
    private static final Logger LOG = Logger.getInstance(JavaLangReflectHandleInvocationChecker.class);
    private static final String INVOKE = "invoke";
    private static final String INVOKE_EXACT = "invokeExact";
    private static final String INVOKE_WITH_ARGUMENTS = "invokeWithArguments";
    private static final String JAVA_LANG_INVOKE_METHOD_HANDLE = "java.lang.invoke.MethodHandle";
    private static final Set<String> METHOD_HANDLE_INVOKE_NAMES = ContainerUtil.set((Object[])new String[]{"invoke", "invokeExact", "invokeWithArguments"});

    JavaLangReflectHandleInvocationChecker() {
    }

    static boolean checkMethodHandleInvocation(@NotNull PsiMethodCallExpression methodCall, @NotNull ProblemsHolder holder) {
        String referenceName;
        if (methodCall == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(1);
        }
        if (METHOD_HANDLE_INVOKE_NAMES.contains(referenceName = methodCall.getMethodExpression().getReferenceName())) {
            PsiMethod method = methodCall.resolveMethod();
            if (method != null && JavaReflectionReferenceUtil.isClassWithName(method.getContainingClass(), JAVA_LANG_INVOKE_METHOD_HANDLE)) {
                if (JavaLangReflectHandleInvocationChecker.isWithDynamicArguments(methodCall)) {
                    return true;
                }
                PsiExpression qualifierDefinition = JavaReflectionReferenceUtil.findDefinition(methodCall.getMethodExpression().getQualifierExpression());
                if (qualifierDefinition instanceof PsiMethodCallExpression) {
                    JavaLangReflectHandleInvocationChecker.checkMethodHandleInvocation((PsiMethodCallExpression)qualifierDefinition, methodCall, holder);
                }
            }
            return true;
        }
        return false;
    }

    private static void checkMethodHandleInvocation(@NotNull PsiMethodCallExpression handleFactoryCall, @NotNull PsiMethodCallExpression invokeCall, @NotNull ProblemsHolder holder) {
        String factoryMethodName;
        if (handleFactoryCall == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(2);
        }
        if (invokeCall == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(4);
        }
        if ((factoryMethodName = handleFactoryCall.getMethodExpression().getReferenceName()) != null && JavaLangInvokeHandleSignatureInspection.KNOWN_METHOD_NAMES.contains(factoryMethodName)) {
            PsiMethod factoryMethod;
            PsiExpression[] handleFactoryArguments = handleFactoryCall.getArgumentList().getExpressions();
            boolean isFindConstructor = "findConstructor".equals(factoryMethodName);
            if ((handleFactoryArguments.length == 3 && !isFindConstructor || handleFactoryArguments.length == 2 && isFindConstructor || handleFactoryArguments.length == 4 && "findSpecial".equals(factoryMethodName)) && (factoryMethod = handleFactoryCall.resolveMethod()) != null && JavaReflectionReferenceUtil.isClassWithName(factoryMethod.getContainingClass(), "java.lang.invoke.MethodHandles.Lookup")) {
                JavaReflectionReferenceUtil.ReflectiveType receiverType2 = JavaReflectionReferenceUtil.getReflectiveType(handleFactoryArguments[0]);
                boolean isExact = INVOKE_EXACT.equals(invokeCall.getMethodExpression().getReferenceName());
                if (isFindConstructor) {
                    if (!JavaLangReflectHandleInvocationChecker.checkMethodSignature(invokeCall, handleFactoryArguments[1], isExact, true, 0, holder)) {
                        return;
                    }
                    JavaLangReflectHandleInvocationChecker.checkReturnType(invokeCall, receiverType2, isExact, holder);
                    return;
                }
                PsiExpression typeExpression = handleFactoryArguments[2];
                switch (factoryMethodName) {
                    case "findVirtual": 
                    case "findSpecial": {
                        if (!JavaLangReflectHandleInvocationChecker.checkMethodSignature(invokeCall, typeExpression, isExact, false, 1, holder)) {
                            return;
                        }
                        JavaLangReflectHandleInvocationChecker.checkCallReceiver(invokeCall, receiverType2, holder);
                        break;
                    }
                    case "findStatic": {
                        JavaLangReflectHandleInvocationChecker.checkMethodSignature(invokeCall, typeExpression, isExact, false, 0, holder);
                        break;
                    }
                    case "findGetter": {
                        if (!JavaLangReflectHandleInvocationChecker.checkGetter(invokeCall, typeExpression, isExact, 1, holder)) {
                            return;
                        }
                        JavaLangReflectHandleInvocationChecker.checkCallReceiver(invokeCall, receiverType2, holder);
                        break;
                    }
                    case "findSetter": {
                        if (!JavaLangReflectHandleInvocationChecker.checkSetter(invokeCall, typeExpression, isExact, 1, holder)) {
                            return;
                        }
                        JavaLangReflectHandleInvocationChecker.checkCallReceiver(invokeCall, receiverType2, holder);
                        break;
                    }
                    case "findStaticGetter": {
                        JavaLangReflectHandleInvocationChecker.checkGetter(invokeCall, typeExpression, isExact, 0, holder);
                        break;
                    }
                    case "findStaticSetter": {
                        JavaLangReflectHandleInvocationChecker.checkSetter(invokeCall, typeExpression, isExact, 0, holder);
                        break;
                    }
                    case "findVarHandle": {
                        break;
                    }
                }
            }
        }
    }

    static void checkCallReceiver(@NotNull PsiMethodCallExpression invokeCall, @Nullable JavaReflectionReferenceUtil.ReflectiveType expectedType, ProblemsHolder holder) {
        PsiExpressionList argumentList;
        PsiExpression[] arguments;
        if (invokeCall == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(5);
        }
        if ((arguments = (argumentList = invokeCall.getArgumentList()).getExpressions()).length == 0) {
            return;
        }
        PsiExpression receiverArgument = arguments[0];
        LOG.assertTrue(receiverArgument != null);
        PsiExpression receiverDefinition = JavaReflectionReferenceUtil.findDefinition(receiverArgument);
        if (ExpressionUtils.isNullLiteral(receiverDefinition)) {
            holder.registerProblem((PsiElement)receiverArgument, InspectionsBundle.message((String)"inspection.reflect.handle.invocation.receiver.null", (Object[])new Object[0]), new LocalQuickFix[0]);
            return;
        }
        if (expectedType != null) {
            if (!JavaLangReflectHandleInvocationChecker.isCompatible(expectedType.getType(), receiverArgument.getType())) {
                holder.registerProblem((PsiElement)receiverArgument, InspectionsBundle.message((String)"inspection.reflect.handle.invocation.receiver.incompatible", (Object[])new Object[]{expectedType.getQualifiedName()}), new LocalQuickFix[0]);
            } else if (receiverArgument != receiverDefinition && receiverDefinition != null && !JavaLangReflectHandleInvocationChecker.isCompatible(expectedType.getType(), receiverDefinition.getType())) {
                holder.registerProblem((PsiElement)receiverArgument, InspectionsBundle.message((String)"inspection.reflect.handle.invocation.receiver.incompatible", (Object[])new Object[]{expectedType.getQualifiedName()}), new LocalQuickFix[0]);
            }
        }
    }

    private static boolean checkMethodSignature(@NotNull PsiMethodCallExpression invokeCall, @NotNull PsiExpression signatureExpression, boolean isExact, boolean isConstructor, int argumentOffset, @NotNull ProblemsHolder holder) {
        PsiExpressionList argumentList;
        PsiExpression[] arguments;
        JavaReflectionInvocationInspection.Arguments actualArguments;
        List<Supplier<JavaReflectionReferenceUtil.ReflectiveType>> lazyMethodSignature;
        if (invokeCall == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(6);
        }
        if (signatureExpression == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(8);
        }
        if ((lazyMethodSignature = JavaLangReflectHandleInvocationChecker.getLazyMethodSignature(signatureExpression)) == null) {
            return true;
        }
        if (!isConstructor && lazyMethodSignature.size() != 0) {
            JavaReflectionReferenceUtil.ReflectiveType returnType = lazyMethodSignature.get(0).get();
            JavaLangReflectHandleInvocationChecker.checkReturnType(invokeCall, returnType, isExact, holder);
        }
        if ((actualArguments = JavaReflectionInvocationInspection.getActualMethodArguments(arguments = (argumentList = invokeCall.getArgumentList()).getExpressions(), argumentOffset, false)) == null) {
            return true;
        }
        int requiredArgumentCount = lazyMethodSignature.size() - 1;
        if (!JavaLangReflectHandleInvocationChecker.checkArgumentCount(actualArguments.expressions, requiredArgumentCount, argumentOffset, (PsiElement)argumentList, holder)) {
            return false;
        }
        LOG.assertTrue(actualArguments.expressions.length == requiredArgumentCount);
        for (int i = 0; i < requiredArgumentCount; ++i) {
            JavaReflectionReferenceUtil.ReflectiveType requiredType = lazyMethodSignature.get(i + 1).get();
            JavaLangReflectHandleInvocationChecker.checkArgumentType(actualArguments.expressions[i], requiredType, argumentList, isExact, holder);
        }
        return true;
    }

    static void checkArgumentType(@NotNull PsiExpression argument, @Nullable JavaReflectionReferenceUtil.ReflectiveType requiredType, @NotNull PsiExpressionList argumentList, boolean isExact, @NotNull ProblemsHolder holder) {
        PsiType actualType;
        if (argument == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(9);
        }
        if (argumentList == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(11);
        }
        if (requiredType != null && (actualType = argument.getType()) != null) {
            PsiExpression definition;
            if (!JavaLangReflectHandleInvocationChecker.isCompatible(requiredType, actualType, isExact)) {
                if (PsiTreeUtil.isAncestor((PsiElement)argumentList, (PsiElement)argument, (boolean)false)) {
                    holder.registerProblem((PsiElement)argument, InspectionsBundle.message((String)(isExact ? "inspection.reflect.handle.invocation.argument.not.exact" : "inspection.reflection.invocation.argument.not.assignable"), (Object[])new Object[]{requiredType.getQualifiedName()}), new LocalQuickFix[0]);
                }
            } else if (requiredType.isPrimitive() && (definition = JavaReflectionReferenceUtil.findDefinition(argument)) != null && PsiType.NULL.equals((Object)definition.getType()) && PsiTreeUtil.isAncestor((PsiElement)argumentList, (PsiElement)argument, (boolean)false)) {
                holder.registerProblem((PsiElement)argument, InspectionsBundle.message((String)"inspection.reflect.handle.invocation.primitive.argument.null", (Object[])new Object[]{requiredType.getQualifiedName()}), new LocalQuickFix[0]);
            }
        }
    }

    static void checkReturnType(@NotNull PsiMethodCallExpression invokeCall, @Nullable JavaReflectionReferenceUtil.ReflectiveType requiredType, boolean isExact, @NotNull ProblemsHolder holder) {
        if (invokeCall == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(12);
        }
        if (holder == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(13);
        }
        if (requiredType == null) {
            return;
        }
        PsiElement invokeParent = invokeCall.getParent();
        PsiType actualType = null;
        PsiTypeElement problemElement = null;
        if (invokeParent instanceof PsiTypeCastExpression) {
            PsiTypeElement castTypeElement = ((PsiTypeCastExpression)invokeParent).getCastType();
            if (castTypeElement != null) {
                actualType = castTypeElement.getType();
                problemElement = castTypeElement;
            }
        } else if (invokeParent instanceof PsiAssignmentExpression) {
            actualType = ((PsiAssignmentExpression)invokeParent).getLExpression().getType();
        } else if (invokeParent instanceof PsiVariable) {
            actualType = ((PsiVariable)invokeParent).getType();
        }
        if (actualType != null && !JavaLangReflectHandleInvocationChecker.isCompatible(requiredType, actualType, isExact)) {
            if (problemElement == null) {
                problemElement = invokeCall.getMethodExpression();
            }
            holder.registerProblem((PsiElement)problemElement, InspectionsBundle.message((String)(isExact || requiredType.isPrimitive() ? "inspection.reflect.handle.invocation.result.not.exact" : "inspection.reflect.handle.invocation.result.not.assignable"), (Object[])new Object[]{requiredType.getQualifiedName()}), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static List<Supplier<JavaReflectionReferenceUtil.ReflectiveType>> getLazyMethodSignature(@Nullable PsiExpression methodTypeExpression) {
        PsiExpression typeDefinition = JavaReflectionReferenceUtil.findDefinition(methodTypeExpression);
        if (typeDefinition instanceof PsiMethodCallExpression) {
            PsiExpression[] arguments;
            Pair.NonNull<Integer, Boolean> signature;
            PsiMethodCallExpression typeDefinitionCall = (PsiMethodCallExpression)typeDefinition;
            if (JavaReflectionReferenceUtil.isCallToMethod(typeDefinitionCall, "java.lang.invoke.MethodType", "methodType")) {
                Object[] arguments2 = typeDefinitionCall.getArgumentList().getExpressions();
                if (arguments2.length != 0) {
                    return ContainerUtil.map((Object[])arguments2, argument -> () -> JavaReflectionReferenceUtil.getReflectiveType(argument));
                }
            } else if (JavaReflectionReferenceUtil.isCallToMethod(typeDefinitionCall, "java.lang.invoke.MethodType", "genericMethodType") && (signature = JavaReflectionReferenceUtil.getGenericSignature(arguments = typeDefinitionCall.getArgumentList().getExpressions())) != null) {
                int objectArgCount = (Integer)signature.getFirst();
                boolean finalArray = (Boolean)signature.getSecond();
                if (objectArgCount == 0 && !finalArray) {
                    return Collections.emptyList();
                }
                PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)methodTypeExpression.getManager(), (GlobalSearchScope)methodTypeExpression.getResolveScope());
                JavaReflectionReferenceUtil.ReflectiveType objectType = JavaReflectionReferenceUtil.ReflectiveType.create((PsiType)javaLangObject, false);
                ArrayList<JavaReflectionReferenceUtil.ReflectiveType> argumentTypes = new ArrayList<JavaReflectionReferenceUtil.ReflectiveType>();
                argumentTypes.add(objectType);
                for (int i = 0; i < objectArgCount; ++i) {
                    argumentTypes.add(objectType);
                }
                if (finalArray) {
                    argumentTypes.add(JavaReflectionReferenceUtil.ReflectiveType.arrayOf(objectType));
                }
                return ContainerUtil.map(argumentTypes, type2 -> () -> type2);
            }
        }
        return null;
    }

    private static boolean checkGetter(@NotNull PsiMethodCallExpression invokeCall, @NotNull PsiExpression typeExpression, boolean isExact, int argumentOffset, ProblemsHolder holder) {
        PsiExpressionList argumentList;
        if (invokeCall == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(14);
        }
        if (typeExpression == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(15);
        }
        if (!JavaLangReflectHandleInvocationChecker.checkArgumentCount((argumentList = invokeCall.getArgumentList()).getExpressions(), argumentOffset, 0, (PsiElement)argumentList, holder)) {
            return false;
        }
        JavaReflectionReferenceUtil.ReflectiveType resultType = JavaReflectionReferenceUtil.getReflectiveType(typeExpression);
        if (resultType != null) {
            JavaLangReflectHandleInvocationChecker.checkReturnType(invokeCall, resultType, isExact, holder);
        }
        return true;
    }

    private static boolean checkSetter(@NotNull PsiMethodCallExpression invokeCall, @NotNull PsiExpression typeExpression, boolean isExact, int argumentOffset, ProblemsHolder holder) {
        PsiExpressionList argumentList;
        PsiExpression[] arguments;
        if (invokeCall == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(16);
        }
        if (typeExpression == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(17);
        }
        if (!JavaLangReflectHandleInvocationChecker.checkArgumentCount(arguments = (argumentList = invokeCall.getArgumentList()).getExpressions(), argumentOffset + 1, 0, (PsiElement)argumentList, holder)) {
            return false;
        }
        LOG.assertTrue(arguments.length == argumentOffset + 1);
        JavaReflectionReferenceUtil.ReflectiveType requiredType = JavaReflectionReferenceUtil.getReflectiveType(typeExpression);
        JavaLangReflectHandleInvocationChecker.checkArgumentType(arguments[argumentOffset], requiredType, argumentList, isExact, holder);
        PsiElement invokeParent = invokeCall.getParent();
        if (!(invokeParent instanceof PsiStatement)) {
            holder.registerProblem((PsiElement)invokeCall.getMethodExpression(), InspectionsBundle.message((String)(isExact ? "inspection.reflect.handle.invocation.result.void" : "inspection.reflect.handle.invocation.result.null"), (Object[])new Object[0]), new LocalQuickFix[0]);
        }
        return true;
    }

    static boolean checkArgumentCount(@NotNull PsiExpression[] arguments, int requiredArgumentCount, int argumentOffset, @NotNull PsiElement problemElement, @NotNull ProblemsHolder holder) {
        if (arguments == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(18);
        }
        if (problemElement == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(19);
        }
        if (holder == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(20);
        }
        if (requiredArgumentCount < 0) {
            return false;
        }
        if (arguments.length != requiredArgumentCount) {
            holder.registerProblem(problemElement, InspectionsBundle.message((String)"inspection.reflection.invocation.argument.count", (Object[])new Object[]{requiredArgumentCount + argumentOffset}), new LocalQuickFix[0]);
            return false;
        }
        return true;
    }

    private static boolean isCompatible(@NotNull JavaReflectionReferenceUtil.ReflectiveType requiredType, @NotNull PsiType actualType, boolean isExact) {
        if (requiredType == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(21);
        }
        if (actualType == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(22);
        }
        if (isExact) {
            return requiredType.isEqualTo(actualType);
        }
        return requiredType.isAssignableFrom(actualType) || actualType.isAssignableFrom(requiredType.getType());
    }

    private static boolean isCompatible(@NotNull PsiType expectedType, @Nullable PsiType actualType) {
        if (expectedType == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(23);
        }
        return actualType != null && (expectedType.isAssignableFrom(actualType) || actualType.isAssignableFrom(expectedType));
    }

    private static boolean isWithDynamicArguments(@NotNull PsiMethodCallExpression invokeCall) {
        PsiExpression[] arguments;
        if (invokeCall == null) {
            JavaLangReflectHandleInvocationChecker.$$$reportNull$$$0(24);
        }
        if (INVOKE_WITH_ARGUMENTS.equals(invokeCall.getMethodExpression().getReferenceName()) && (arguments = invokeCall.getArgumentList().getExpressions()).length == 1) {
            return JavaReflectionReferenceUtil.isVarargAsArray(arguments[0]) || InheritanceUtil.isInheritor((PsiType)arguments[0].getType(), (String)"java.util.List");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handleFactoryCall";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokeCall";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/JavaLangReflectHandleInvocationChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodHandleInvocation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCallReceiver";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodSignature";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArgumentType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReturnType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkGetter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSetter";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArgumentCount";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompatible";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "isWithDynamicArguments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

