/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.function.Predicate;

class InlinerUtil {
    InlinerUtil() {
    }

    static boolean isLambdaChainParameterReference(PsiExpression expression2, Predicate<? super PsiType> chainTypePredicate) {
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiParameter target = (PsiParameter)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression2).resolve(), PsiParameter.class);
        if (target == null) {
            return false;
        }
        if (!(target.getParent() instanceof PsiParameterList)) {
            return false;
        }
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)target.getParent().getParent(), PsiLambdaExpression.class);
        if (lambda2 == null) {
            return false;
        }
        PsiExpressionList list = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)lambda2.getParent()), PsiExpressionList.class);
        if (list == null) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)list.getParent(), PsiMethodCallExpression.class);
        if (call == null) {
            return false;
        }
        PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
        if (qualifierCall == null) {
            return false;
        }
        PsiType type2 = qualifierCall.getType();
        return type2 != null && chainTypePredicate.test((PsiType)type2);
    }
}

