/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class ControlFlow {
    private final List<Instruction> myInstructions = new ArrayList<Instruction>();
    private final TObjectIntHashMap<PsiElement> myElementToStartOffsetMap = new TObjectIntHashMap();
    private final TObjectIntHashMap<PsiElement> myElementToEndOffsetMap = new TObjectIntHashMap();
    private final DfaValueFactory myFactory;

    public ControlFlow(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    public Instruction[] getInstructions() {
        return this.myInstructions.toArray(new Instruction[0]);
    }

    public int getInstructionCount() {
        return this.myInstructions.size();
    }

    public ControlFlowOffset getNextOffset() {
        return new FixedOffset(this.myInstructions.size());
    }

    public void startElement(PsiElement psiElement) {
        this.myElementToStartOffsetMap.put((Object)psiElement, this.myInstructions.size());
    }

    public void finishElement(PsiElement psiElement) {
        this.myElementToEndOffsetMap.put((Object)psiElement, this.myInstructions.size());
    }

    public void addInstruction(Instruction instruction) {
        instruction.setIndex(this.myInstructions.size());
        this.myInstructions.add(instruction);
    }

    public void removeVariable(@Nullable PsiVariable variable) {
        if (variable == null) {
            return;
        }
        this.addInstruction(new FlushVariableInstruction(this.myFactory.getVarFactory().createVariableValue(variable)));
    }

    public Stream<DfaVariableValue> accessedVariables() {
        return ((StreamEx)StreamEx.of(this.myInstructions).select(PushInstruction.class).remove(PushInstruction::isReferenceWrite)).map(PushInstruction::getValue).select(DfaVariableValue.class).distinct();
    }

    public ControlFlowOffset getStartOffset(final PsiElement element) {
        return new ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return ControlFlow.this.myElementToStartOffsetMap.get((Object)element);
            }
        };
    }

    public ControlFlowOffset getEndOffset(final PsiElement element) {
        return new ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return ControlFlow.this.myElementToEndOffsetMap.get((Object)element);
            }
        };
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        List<Instruction> instructions = this.myInstructions;
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            result.append(i).append(": ").append(instruction.toString());
            result.append("\n");
        }
        return result.toString();
    }

    static ControlFlowOffset deltaOffset(final ControlFlowOffset delegate, final int delta) {
        return new ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return delegate.getInstructionOffset() + delta;
            }
        };
    }

    public static class DeferredOffset
    extends ControlFlowOffset {
        private int myOffset = -1;

        @Override
        public int getInstructionOffset() {
            if (this.myOffset == -1) {
                throw new IllegalStateException("Not set");
            }
            return this.myOffset;
        }

        public void setOffset(int offset) {
            if (this.myOffset != -1) {
                throw new IllegalStateException("Already set");
            }
            this.myOffset = offset;
        }

        @Override
        public String toString() {
            return this.myOffset == -1 ? "<not set>" : super.toString();
        }
    }

    public static class FixedOffset
    extends ControlFlowOffset {
        private final int myOffset;

        public FixedOffset(int offset) {
            this.myOffset = offset;
        }

        @Override
        public int getInstructionOffset() {
            return this.myOffset;
        }
    }

    public static abstract class ControlFlowOffset {
        public abstract int getInstructionOffset();

        public String toString() {
            return String.valueOf(this.getInstructionOffset());
        }
    }
}

