/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Analysis;
import com.intellij.codeInspection.bytecodeAnalysis.Conf;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.InOutInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.ResultUtil;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.TooComplexException;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import com.intellij.openapi.progress.ProgressManager;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

abstract class ContractAnalysis
extends Analysis<Result> {
    static final ResultUtil resultUtil = new ResultUtil(new ELattice<Value>(Value.Bot, Value.Top));
    private final State[] pending;
    final InOutInterpreter interpreter;
    final Value inValue;
    private final int generalizeShift;
    Result internalResult;
    boolean unsureOnly = true;
    private int id;
    private int pendingTop;

    protected ContractAnalysis(RichControlFlow richControlFlow, Direction direction, boolean[] resultOrigins, boolean stable, State[] pending) {
        super(richControlFlow, direction, stable);
        this.pending = pending;
        this.interpreter = new InOutInterpreter(direction, richControlFlow.controlFlow.methodNode.instructions, resultOrigins);
        this.inValue = direction instanceof Direction.ParamValueBasedDirection ? ((Direction.ParamValueBasedDirection)direction).inValue : null;
        this.generalizeShift = (this.methodNode.access & 8) == 0 ? 1 : 0;
        this.internalResult = Value.Bot;
    }

    @NotNull
    Equation mkEquation(Result res) {
        Equation equation = new Equation(this.aKey, res);
        if (equation == null) {
            ContractAnalysis.$$$reportNull$$$0(0);
        }
        return equation;
    }

    static Result checkLimit(Result result) throws AnalyzerException {
        int size;
        if (result instanceof Pending && (size = Arrays.stream(((Pending)result).delta).mapToInt(prod -> prod.ids.length).sum()) > 30) {
            throw new AnalyzerException(null, "Equation size is too big");
        }
        return result;
    }

    @Override
    @NotNull
    protected Equation analyze() throws AnalyzerException {
        this.pendingPush(this.createStartState());
        int steps = 0;
        while (this.pendingTop > 0 && this.earlyResult == null) {
            TooComplexException.check(this.method, ++steps);
            if (steps % 128 == 0) {
                ProgressManager.checkCanceled();
            }
            State state = this.pending[--this.pendingTop];
            int insnIndex = state.conf.insnIndex;
            Conf conf = state.conf;
            List<Conf> history = state.history;
            boolean fold = false;
            if (this.dfsTree.loopEnters[insnIndex]) {
                for (Conf prev : history) {
                    if (!AbstractValues.isInstance(conf, prev)) continue;
                    fold = true;
                    break;
                }
            }
            if (fold) {
                this.addComputed(insnIndex, state);
                continue;
            }
            State baseState = null;
            List thisComputed = this.computed[insnIndex];
            if (thisComputed != null) {
                for (State prevState : thisComputed) {
                    if (!ContractAnalysis.stateEquiv(state, prevState)) continue;
                    baseState = prevState;
                    break;
                }
            }
            if (baseState != null) continue;
            this.processState(state);
        }
        if (this.earlyResult != null) {
            Equation equation = this.mkEquation((Result)this.earlyResult);
            if (equation == null) {
                ContractAnalysis.$$$reportNull$$$0(1);
            }
            return equation;
        }
        if (this.unsureOnly) {
            Equation equation = this.mkEquation(Value.Bot);
            if (equation == null) {
                ContractAnalysis.$$$reportNull$$$0(2);
            }
            return equation;
        }
        Equation equation = this.mkEquation(this.internalResult);
        if (equation == null) {
            ContractAnalysis.$$$reportNull$$$0(3);
        }
        return equation;
    }

    void processState(State state) throws AnalyzerException {
        Conf preConf = state.conf;
        int insnIndex = preConf.insnIndex;
        boolean loopEnter = this.dfsTree.loopEnters[insnIndex];
        Conf conf = loopEnter ? this.generalize(preConf) : preConf;
        List<Conf> history = state.history;
        boolean taken = state.taken;
        Frame<BasicValue> frame = conf.frame;
        AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
        List<Conf> nextHistory = loopEnter ? ContractAnalysis.append(history, conf) : history;
        Frame<BasicValue> nextFrame = this.execute(frame, insnNode);
        this.addComputed(insnIndex, state);
        int opcode = insnNode.getOpcode();
        if (this.interpreter.deReferenced && this.controlFlow.npeTransitions.containsKey(insnIndex)) {
            this.interpreter.deReferenced = false;
            int npeTarget = this.controlFlow.npeTransitions.get(insnIndex);
            for (int nextInsnIndex : this.controlFlow.transitions[insnIndex]) {
                if (!this.controlFlow.errorTransitions.contains(new ControlFlowGraph.Edge(insnIndex, nextInsnIndex))) continue;
                Frame<BasicValue> nextFrame1 = ContractAnalysis.createCatchFrame(frame);
                boolean unsure = state.unsure || nextInsnIndex != npeTarget;
                this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, nextFrame1), nextHistory, taken, false, unsure));
            }
            return;
        }
        if (this.handleReturn(frame, opcode, state.unsure)) {
            return;
        }
        if (opcode == 199 && ContractAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = this.inValue == Value.Null ? insnIndex + 1 : this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, nextFrame), nextHistory, true, false, state.unsure);
            this.pendingPush(nextState);
            return;
        }
        if (opcode == 198 && ContractAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = this.inValue == Value.NotNull ? insnIndex + 1 : this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, nextFrame), nextHistory, true, false, state.unsure);
            this.pendingPush(nextState);
            return;
        }
        if (opcode == 153 && ContractAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = this.inValue == Value.True ? insnIndex + 1 : this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, nextFrame), nextHistory, true, false, state.unsure);
            this.pendingPush(nextState);
            return;
        }
        if (opcode == 154 && ContractAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = this.inValue == Value.False ? insnIndex + 1 : this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, nextFrame), nextHistory, true, false, state.unsure);
            this.pendingPush(nextState);
            return;
        }
        if (opcode == 153 && ContractAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue && this.inValue == Value.Null) {
            int nextInsnIndex = this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, nextFrame), nextHistory, true, false, state.unsure);
            this.pendingPush(nextState);
            return;
        }
        if (opcode == 154 && ContractAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue && this.inValue == Value.Null) {
            int nextInsnIndex = insnIndex + 1;
            State nextState = new State(++this.id, new Conf(nextInsnIndex, nextFrame), nextHistory, true, false, state.unsure);
            this.pendingPush(nextState);
            return;
        }
        for (int nextInsnIndex : this.controlFlow.transitions[insnIndex]) {
            Frame<BasicValue> nextFrame1 = nextFrame;
            boolean unsure = state.unsure;
            if (this.controlFlow.errors[nextInsnIndex] && this.controlFlow.errorTransitions.contains(new ControlFlowGraph.Edge(insnIndex, nextInsnIndex))) {
                nextFrame1 = ContractAnalysis.createCatchFrame(frame);
                unsure = true;
            }
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, nextFrame1), nextHistory, taken, false, unsure));
        }
    }

    abstract boolean handleReturn(Frame<BasicValue> var1, int var2, boolean var3) throws AnalyzerException;

    private void pendingPush(State st) {
        TooComplexException.check(this.method, this.pendingTop);
        this.pending[this.pendingTop++] = st;
    }

    private Frame<BasicValue> execute(Frame<BasicValue> frame, AbstractInsnNode insnNode) throws AnalyzerException {
        this.interpreter.deReferenced = false;
        switch (insnNode.getType()) {
            case 8: 
            case 14: 
            case 15: {
                return frame;
            }
        }
        Frame nextFrame = new Frame(frame);
        nextFrame.execute(insnNode, (Interpreter)this.interpreter);
        return nextFrame;
    }

    private Conf generalize(Conf conf) {
        Frame frame = new Frame(conf.frame);
        for (int i = this.generalizeShift; i < frame.getLocals(); ++i) {
            BasicValue value2 = (BasicValue)frame.getLocal(i);
            Class<?> valueClass = value2.getClass();
            if (valueClass == BasicValue.class || valueClass == AbstractValues.ParamValue.class) continue;
            frame.setLocal(i, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)new BasicValue(value2.getType()));
        }
        BasicValue[] stack = new BasicValue[frame.getStackSize()];
        for (int i = 0; i < frame.getStackSize(); ++i) {
            stack[i] = (BasicValue)frame.getStack(i);
        }
        frame.clearStack();
        for (BasicValue value3 : stack) {
            Class<?> valueClass = value3.getClass();
            if (valueClass != BasicValue.class && valueClass != AbstractValues.ParamValue.class) {
                frame.push((org.jetbrains.org.objectweb.asm.tree.analysis.Value)new BasicValue(value3.getType()));
                continue;
            }
            frame.push((org.jetbrains.org.objectweb.asm.tree.analysis.Value)value3);
        }
        return new Conf(conf.insnIndex, (Frame<BasicValue>)frame);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/bytecodeAnalysis/ContractAnalysis";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "mkEquation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "analyze";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

