/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.blockingCallsDetection.AnnotationBasedBlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.AnnotationBasedNonBlockingContextChecker;
import com.intellij.codeInspection.blockingCallsDetection.BlockingAnnotationsPanel;
import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.NonBlockingContextChecker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;

public class BlockingMethodInNonBlockingContextInspection
extends AbstractBaseUastLocalInspectionTool {
    public static final String DEFAULT_BLOCKING_ANNOTATION = "org.jetbrains.annotations.Blocking";
    public static final String DEFAULT_NONBLOCKING_ANNOTATION = "org.jetbrains.annotations.NonBlocking";
    public List<String> myBlockingAnnotations = new SmartList();
    public List<String> myNonBlockingAnnotations = new SmartList();

    @Nullable
    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JvmAnalysisBundle.message("jvm.inspections.blocking.method.display.name", new Object[0]);
        if (string == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(1);
        }
        List blockingMethodCheckers = ContainerUtil.append((List)BlockingMethodChecker.EP_NAME.getExtensionList(), (Object[])new BlockingMethodChecker[]{new AnnotationBasedBlockingMethodChecker(this.myBlockingAnnotations)});
        List nonBlockingContextCheckers = ContainerUtil.append((List)NonBlockingContextChecker.EP_NAME.getExtensionList(), (Object[])new NonBlockingContextChecker[]{new AnnotationBasedNonBlockingContextChecker(this.myNonBlockingAnnotations)});
        if (!BlockingMethodInNonBlockingContextInspection.isInspectionActive(holder.getFile(), blockingMethodCheckers, nonBlockingContextCheckers)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        BlockingMethodInNonBlockingContextVisitor blockingMethodInNonBlockingContextVisitor = new BlockingMethodInNonBlockingContextVisitor(holder, blockingMethodCheckers, nonBlockingContextCheckers);
        if (blockingMethodInNonBlockingContextVisitor == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(3);
        }
        return blockingMethodInNonBlockingContextVisitor;
    }

    private static boolean isInspectionActive(PsiFile file, List<BlockingMethodChecker> myBlockingMethodCheckers, List<NonBlockingContextChecker> myNonBlockingContextCheckers) {
        return myBlockingMethodCheckers.stream().anyMatch(extension -> extension.isApplicable(file)) && myNonBlockingContextCheckers.stream().anyMatch(extension -> extension.isApplicable(file));
    }

    @NotNull
    private static Project getCurrentProjectOrDefault(Component context) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(context));
        if (project == null) {
            IdeFrame lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            if (lastFocusedFrame != null) {
                project = lastFocusedFrame.getProject();
            }
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
        }
        Project project2 = project;
        if (project2 == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(4);
        }
        return project2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/blockingCallsDetection/BlockingMethodInNonBlockingContextInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/blockingCallsDetection/BlockingMethodInNonBlockingContextInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentProjectOrDefault";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BlockingMethodInNonBlockingContextVisitor
    extends PsiElementVisitor {
        private final ProblemsHolder myHolder;
        private final List<? extends BlockingMethodChecker> myBlockingMethodCheckers;
        private final List<? extends NonBlockingContextChecker> myNonBlockingContextCheckers;

        BlockingMethodInNonBlockingContextVisitor(@NotNull ProblemsHolder holder, List<? extends BlockingMethodChecker> blockingMethodCheckers, List<? extends NonBlockingContextChecker> nonBlockingContextCheckers) {
            if (holder == null) {
                BlockingMethodInNonBlockingContextVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
            this.myBlockingMethodCheckers = blockingMethodCheckers;
            this.myNonBlockingContextCheckers = nonBlockingContextCheckers;
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            UCallExpression callExpression = AnalysisUastUtil.getUCallExpression((PsiElement)element);
            if (callExpression == null) {
                return;
            }
            if (!this.isContextNonBlockingFor(element)) {
                return;
            }
            ProgressIndicatorProvider.checkCanceled();
            PsiMethod referencedMethod = callExpression.resolve();
            if (referencedMethod == null) {
                return;
            }
            if (!((Boolean)CachedValuesManager.getCachedValue((PsiElement)referencedMethod, BlockingMethodInNonBlockingContextVisitor.getIsBlockingProvider(referencedMethod, this.myBlockingMethodCheckers))).booleanValue()) {
                return;
            }
            PsiElement elementToHighLight = AnalysisUastUtil.getMethodIdentifierSourcePsi((UCallExpression)callExpression);
            if (elementToHighLight == null) {
                return;
            }
            this.myHolder.registerProblem(elementToHighLight, JvmAnalysisBundle.message("jvm.inspections.blocking.method.problem.descriptor", new Object[0]), new LocalQuickFix[0]);
        }

        private static CachedValueProvider<Boolean> getIsBlockingProvider(PsiMethod referencedMethod, List<? extends BlockingMethodChecker> blockingMethodCheckers) {
            return () -> {
                boolean isBlocking = StreamEx.of((Object)referencedMethod).append((Object[])referencedMethod.findDeepestSuperMethods()).anyMatch(method -> BlockingMethodInNonBlockingContextVisitor.isMethodBlocking(method, blockingMethodCheckers));
                return CachedValueProvider.Result.create((Object)isBlocking, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            };
        }

        private boolean isContextNonBlockingFor(PsiElement element) {
            return this.myNonBlockingContextCheckers.stream().anyMatch(extension -> {
                ProgressIndicatorProvider.checkCanceled();
                return extension.isContextNonBlockingFor(element);
            });
        }

        private static boolean isMethodBlocking(PsiMethod method, List<? extends BlockingMethodChecker> blockingMethodCheckers) {
            return blockingMethodCheckers.stream().anyMatch(extension -> {
                ProgressIndicatorProvider.checkCanceled();
                return extension.isMethodBlocking(method);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/blockingCallsDetection/BlockingMethodInNonBlockingContextInspection$BlockingMethodInNonBlockingContextVisitor", "<init>"));
        }
    }

    private class OptionsPanel
    extends JPanel {
        private OptionsPanel() {
            super(new BorderLayout());
            Splitter mainPanel = new Splitter(true);
            Project project = BlockingMethodInNonBlockingContextInspection.getCurrentProjectOrDefault(this);
            BlockingAnnotationsPanel blockingAnnotationsPanel = new BlockingAnnotationsPanel(project, JvmAnalysisBundle.message("jvm.inspections.blocking.method.annotation.blocking", new Object[0]), BlockingMethodInNonBlockingContextInspection.DEFAULT_BLOCKING_ANNOTATION, BlockingMethodInNonBlockingContextInspection.this.myBlockingAnnotations, Collections.singletonList(BlockingMethodInNonBlockingContextInspection.DEFAULT_BLOCKING_ANNOTATION), JvmAnalysisBundle.message("jvm.inspections.blocking.method.annotation.configure.empty.text", new Object[0]), JvmAnalysisBundle.message("jvm.inspections.blocking.method.annotation.configure.add.blocking.title", new Object[0]));
            BlockingAnnotationsPanel nonBlockingAnnotationsPanel = new BlockingAnnotationsPanel(project, JvmAnalysisBundle.message("jvm.inspections.blocking.method.annotation.non-blocking", new Object[0]), BlockingMethodInNonBlockingContextInspection.DEFAULT_NONBLOCKING_ANNOTATION, BlockingMethodInNonBlockingContextInspection.this.myNonBlockingAnnotations, Collections.singletonList(BlockingMethodInNonBlockingContextInspection.DEFAULT_NONBLOCKING_ANNOTATION), JvmAnalysisBundle.message("jvm.inspections.blocking.method.annotation.configure.empty.text", new Object[0]), JvmAnalysisBundle.message("jvm.inspections.blocking.method.annotation.configure.add.non-blocking.title", new Object[0]));
            mainPanel.setFirstComponent(blockingAnnotationsPanel.getComponent());
            mainPanel.setSecondComponent(nonBlockingAnnotationsPanel.getComponent());
            this.add((Component)mainPanel, "Center");
        }
    }
}

