/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantStreamOptionalCallInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(RedundantStreamOptionalCallInspection.class);
    private static final CallMatcher NATURAL_OR_REVERSED_COMPARATOR = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Comparator", "naturalOrder", "reverseOrder").parameterCount(0), CallMatcher.staticCall("java.util.Collections", "reverseOrder").parameterCount(0));
    private static final CallMatcher COMPARATOR_REVERSE = CallMatcher.instanceCall("java.util.Comparator", "reversed").parameterCount(0);
    private static final Set<String> INTERESTING_NAMES = ContainerUtil.set((Object[])new String[]{"map", "filter", "distinct", "sorted", "sequential", "parallel", "unordered", "flatMap"});
    private static final Set<String> CALLS_MAKING_SORT_USELESS = ContainerUtil.set((Object[])new String[]{"sorted", "anyMatch", "allMatch", "noneMatch", "count", "min", "max"});
    private static final Set<String> CALLS_KEEPING_SORT_ORDER = ContainerUtil.set((Object[])new String[]{"filter", "distinct", "boxed", "asLongStream", "asDoubleStream"});
    private static final Set<String> CALLS_KEEPING_ELEMENTS_DISTINCT = ContainerUtil.set((Object[])new String[]{"filter", "boxed", "asLongStream", "limit", "skip", "sorted", "takeWhile", "dropWhile"});
    private static final Set<String> CALLS_AFFECTING_PARALLELIZATION = ContainerUtil.set((Object[])new String[]{"sequential", "parallel"});
    private static final Set<String> CALLS_USELESS_FOR_SINGLE_ELEMENT_STREAM = ContainerUtil.set((Object[])new String[]{"sorted", "distinct"});
    private static final Set<String> BOX_UNBOX_NAMES = ContainerUtil.set((Object[])new String[]{"valueOf", "booleanValue", "byteValue", "charValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue"});
    private static final Set<String> STANDARD_STREAM_INTERMEDIATE_OPERATIONS = ContainerUtil.set((Object[])new String[]{"asDoubleStream", "asLongStream", "boxed", "distinct", "dropWhile", "filter", "flatMap", "flatMapToDouble", "flatMapToInt", "flatMapToLong", "flatMapToObj", "limit", "map", "mapToDouble", "mapToInt", "mapToLong", "mapToObj", "onClose", "parallel", "peek", "sequential", "skip", "takeWhile", "unordered"});
    private static final Set<String> STANDARD_STREAM_TERMINAL_OPERATIONS = ContainerUtil.set((Object[])new String[]{"allMatch", "anyMatch", "average", "collect", "count", "findAny", "findFirst", "forEach", "forEachOrdered", "max", "min", "noneMatch", "reduce", "sum", "summaryStatistics", "toArray"});
    private static final CallMatcher COLLECTOR_TO_SET = CallMatcher.staticCall("java.util.stream.Collectors", "toSet", "toUnmodifiableSet").parameterCount(0);
    private static final CallMatcher COLLECTOR_TO_COLLECTION = CallMatcher.staticCall("java.util.stream.Collectors", "toCollection").parameterCount(1);
    private static final CallMatcher COLLECTOR_TO_MAP = CallMatcher.staticCall("java.util.stream.Collectors", "toMap", "toUnmodifiableMap").parameterTypes("java.util.function.Function", "java.util.function.Function");
    private static final CallMatcher UNORDERED_COLLECTORS = CallMatcher.anyOf(COLLECTOR_TO_MAP, COLLECTOR_TO_SET);
    private static final Predicate<PsiMethodCallExpression> UNORDERED_COLLECTOR = UNORDERED_COLLECTORS.or(RedundantStreamOptionalCallInspection::isUnorderedToCollection);
    private static final CallMatcher STREAM_OF_SINGLE = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Stream", "of").parameterTypes("T"), CallMatcher.staticCall("java.util.stream.IntStream", "of").parameterTypes("int"), CallMatcher.staticCall("java.util.stream.LongStream", "of").parameterTypes("long"), CallMatcher.staticCall("java.util.stream.DoubleStream", "of").parameterTypes("double"));
    public boolean USELESS_BOXING_IN_STREAM_MAP = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.option.streamboxing", (Object[])new Object[0]), (InspectionProfileEntry)this, "USELESS_BOXING_IN_STREAM_MAP");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantStreamOptionalCallInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RedundantStreamOptionalCallInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiReferenceExpression methodExpression;
                String name;
                if (STREAM_OF_SINGLE.test(call)) {
                    this.handleSingleElementStream(call);
                }
                if ((name = (methodExpression = call.getMethodExpression()).getReferenceName()) == null || !INTERESTING_NAMES.contains(name)) {
                    return;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return;
                }
                String className = aClass.getQualifiedName();
                if (className == null) {
                    return;
                }
                boolean optional = OptionalUtil.isOptionalClassName(className);
                boolean stream = InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream");
                if (!optional && !stream) {
                    return;
                }
                if (!EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(qualifier.getType(), call.getType())) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                switch (name) {
                    case "filter": {
                        if (args.length != 1 || !RedundantStreamOptionalCallInspection.isTruePredicate(args[0])) break;
                        this.register(call, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.filter", (Object[])new Object[0]), new LocalQuickFix[0]);
                        break;
                    }
                    case "map": {
                        boolean allowBoxUnbox;
                        boolean bl = allowBoxUnbox = RedundantStreamOptionalCallInspection.this.USELESS_BOXING_IN_STREAM_MAP || optional || StreamApiUtil.getStreamElementType(call.getType()) instanceof PsiPrimitiveType;
                        if (args.length != 1 || !RedundantStreamOptionalCallInspection.isIdentityMapping(args[0], allowBoxUnbox)) break;
                        this.register(call, null, new LocalQuickFix[0]);
                        break;
                    }
                    case "flatMap": {
                        if (args.length != 1 || !optional || !FunctionalExpressionUtils.isFunctionalReferenceTo(args[0], "java.util.Optional", null, "of", new PsiType[1]) && !FunctionalExpressionUtils.isFunctionalReferenceTo(args[0], "java.util.Optional", null, "ofNullable", new PsiType[1])) break;
                        this.register(call, null, new LocalQuickFix[0]);
                        break;
                    }
                    case "sorted": {
                        if (args.length > 1) break;
                        PsiMethodCallExpression furtherCall = call;
                        while ((furtherCall = StreamApiUtil.findSubsequentCall(furtherCall, CALLS_MAKING_SORT_USELESS::contains, UNORDERED_COLLECTOR, CALLS_KEEPING_SORT_ORDER::contains)) != null && "sorted".equals(furtherCall.getMethodExpression().getReferenceName()) && !RedundantStreamOptionalCallInspection.sortingCancelsPreviousSorting(call, furtherCall)) {
                        }
                        if (furtherCall == null) break;
                        String furtherCallName = furtherCall.getMethodExpression().getReferenceName();
                        if (("max".equals(furtherCallName) || "min".equals(furtherCallName)) && !RedundantStreamOptionalCallInspection.sortingCancelsPreviousSorting(call, furtherCall)) {
                            return;
                        }
                        CollectToOrderedSetFix additionalFix = null;
                        if ("toSet".equals(furtherCallName) || "toCollection".equals(furtherCallName)) {
                            additionalFix = new CollectToOrderedSetFix();
                        }
                        String message2 = "sorted".equals(furtherCallName) ? InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.sorted.twice", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.sorted", (Object[])new Object[]{furtherCallName});
                        this.register(call, message2, additionalFix);
                        break;
                    }
                    case "distinct": {
                        if (args.length != 0) break;
                        PsiMethodCallExpression furtherCall = StreamApiUtil.findSubsequentCall(call, Predicate.isEqual("distinct"), CALLS_KEEPING_ELEMENTS_DISTINCT::contains);
                        if (furtherCall != null && furtherCall.getArgumentList().isEmpty()) {
                            this.register(furtherCall, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.distinct", (Object[])new Object[0]), new LocalQuickFix[0]);
                        }
                        Predicate<PsiMethodCallExpression> setCollector = COLLECTOR_TO_SET.or(RedundantStreamOptionalCallInspection::isToCollectionSet);
                        if (StreamApiUtil.findSubsequentCall(call, c -> false, setCollector, ContainerUtil.set((Object[])new String[]{"unordered", "parallel", "sequential", "sorted"})::contains) == null) break;
                        this.register(call, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.distinct.set", (Object[])new Object[0]), new LocalQuickFix[0]);
                        break;
                    }
                    case "unordered": {
                        PsiMethodCallExpression furtherCall;
                        if (args.length != 0 || (furtherCall = StreamApiUtil.findSubsequentCall(call, Predicate.isEqual("unordered"), n -> !n.equals("sorted"))) == null || !furtherCall.getArgumentList().isEmpty()) break;
                        this.register(furtherCall, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.unordered", (Object[])new Object[0]), new LocalQuickFix[0]);
                        break;
                    }
                    case "sequential": 
                    case "parallel": {
                        if (args.length != 0) break;
                        PsiMethodCallExpression furtherCall = StreamApiUtil.findSubsequentCall(call, CALLS_AFFECTING_PARALLELIZATION::contains, n -> true);
                        if (furtherCall == null || !furtherCall.getArgumentList().isEmpty()) break;
                        this.register(call, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.parallel", (Object[])new Object[]{furtherCall.getMethodExpression().getReferenceName()}), new LocalQuickFix[0]);
                    }
                }
            }

            private void handleSingleElementStream(PsiMethodCallExpression call) {
                PsiMethodCallExpression subsequentCall = StreamApiUtil.findSubsequentCall(call, CALLS_USELESS_FOR_SINGLE_ELEMENT_STREAM::contains, name -> STANDARD_STREAM_INTERMEDIATE_OPERATIONS.contains(name) && !name.startsWith("flatMap"));
                if (subsequentCall != null) {
                    this.register(subsequentCall, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.at.most.one", (Object[])new Object[0]), new LocalQuickFix[0]);
                    return;
                }
                Predicate<String> standardNoSorted = name -> STANDARD_STREAM_INTERMEDIATE_OPERATIONS.contains(name) && !name.equals("sorted");
                PsiMethodCallExpression parallelCall = StreamApiUtil.findSubsequentCall(call, "parallel"::equals, standardNoSorted);
                if (parallelCall != null) {
                    if (StreamApiUtil.findSubsequentCall(call, STANDARD_STREAM_TERMINAL_OPERATIONS::contains, standardNoSorted) != null) {
                        this.register(parallelCall, InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.explanation.parallel.single", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            private void register(PsiMethodCallExpression call, String explanation, LocalQuickFix ... additionalFixes) {
                String methodName = call.getMethodExpression().getReferenceName();
                String message2 = InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.message", (Object[])new Object[]{methodName});
                if (explanation != null) {
                    message2 = message2 + ": " + explanation;
                }
                holder.registerProblem((PsiElement)call, message2, ProblemHighlightType.LIKE_UNUSED_SYMBOL, RedundantStreamOptionalCallInspection.getRange(call), (LocalQuickFix[])ArrayUtil.prepend((Object)new RemoveCallFix(methodName), (Object[])additionalFixes));
            }
        };
        if (javaElementVisitor == null) {
            RedundantStreamOptionalCallInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static boolean sortingCancelsPreviousSorting(PsiMethodCallExpression call, PsiMethodCallExpression furtherCall) {
        PsiExpression comparator = RedundantStreamOptionalCallInspection.skipReversed((PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions()));
        PsiExpression nextComparator = RedundantStreamOptionalCallInspection.skipReversed((PsiExpression)ArrayUtil.getFirstElement((Object[])furtherCall.getArgumentList().getExpressions()));
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(comparator, nextComparator)) {
            return true;
        }
        boolean isNatural = comparator == null || NATURAL_OR_REVERSED_COMPARATOR.matches(comparator);
        boolean isNextNatural = nextComparator == null || NATURAL_OR_REVERSED_COMPARATOR.matches(nextComparator);
        return isNatural && isNextNatural;
    }

    private static PsiExpression skipReversed(PsiExpression comparator) {
        comparator = PsiUtil.skipParenthesizedExprDown((PsiExpression)comparator);
        while (comparator instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)comparator;
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (!COMPARATOR_REVERSE.test(call) || qualifier == null) break;
            comparator = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier);
        }
        return comparator;
    }

    static boolean isUnorderedToCollection(PsiMethodCallExpression call) {
        if (!COLLECTOR_TO_COLLECTION.test(call)) {
            return false;
        }
        PsiClass aClass = FunctionalExpressionUtils.getClassOfDefaultConstructorFunction(call.getArgumentList().getExpressions()[0]);
        return aClass != null && "java.util.HashSet".equals(aClass.getQualifiedName());
    }

    static boolean isToCollectionSet(PsiMethodCallExpression call) {
        if (!COLLECTOR_TO_COLLECTION.test(call)) {
            return false;
        }
        PsiClass aClass = FunctionalExpressionUtils.getClassOfDefaultConstructorFunction(call.getArgumentList().getExpressions()[0]);
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Set");
    }

    @NotNull
    static TextRange getRange(PsiMethodCallExpression call) {
        PsiReferenceExpression expression2 = call.getMethodExpression();
        PsiElement nameElement = expression2.getReferenceNameElement();
        LOG.assertTrue(nameElement != null);
        TextRange textRange = new TextRange(nameElement.getStartOffsetInParent(), call.getTextLength());
        if (textRange == null) {
            RedundantStreamOptionalCallInspection.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    static boolean isIdentityMapping(PsiExpression expression2, boolean allowBoxUnbox) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodCallExpression && MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)expression2, "java.util.function.Function", "identity", 0)) {
            return true;
        }
        if (expression2 instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression2;
            if (LambdaUtil.isIdentityLambda((PsiLambdaExpression)lambda2)) {
                return true;
            }
            if (!allowBoxUnbox) {
                return false;
            }
            PsiExpression body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 1) {
                return false;
            }
            PsiParameter parameter2 = parameters2[0];
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)body2), PsiMethodCallExpression.class);
            if (call == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            if (!BOX_UNBOX_NAMES.contains(methodExpression.getReferenceName())) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (ExpressionUtils.isReferenceTo(qualifier, (PsiVariable)parameter2) && args.length > 0) {
                return false;
            }
            if (args.length != 1 || !ExpressionUtils.isReferenceTo(args[0], (PsiVariable)parameter2)) {
                return false;
            }
            return RedundantStreamOptionalCallInspection.isBoxUnboxMethod(call.resolveMethod());
        }
        if (!allowBoxUnbox || !(expression2 instanceof PsiMethodReferenceExpression)) {
            return false;
        }
        PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression2;
        if (!BOX_UNBOX_NAMES.contains(methodRef.getReferenceName())) {
            return false;
        }
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
        return RedundantStreamOptionalCallInspection.isBoxUnboxMethod(method);
    }

    @Contract(value="null -> false")
    private static boolean isBoxUnboxMethod(PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        PsiType primitiveCandidate = null;
        PsiParameterList list = method.getParameterList();
        if (list.isEmpty()) {
            primitiveCandidate = method.getReturnType();
        } else if (list.getParametersCount() == 1) {
            primitiveCandidate = list.getParameters()[0].getType();
        }
        if (!(primitiveCandidate instanceof PsiPrimitiveType)) {
            return false;
        }
        return Objects.equals(((PsiPrimitiveType)primitiveCandidate).getBoxedTypeName(), aClass.getQualifiedName());
    }

    static boolean isTruePredicate(PsiExpression expression2) {
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiLambdaExpression.class);
        if (lambda2 != null) {
            PsiExpression body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            return ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)body2), Boolean.TRUE);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollectToOrderedSetFix
    implements LocalQuickFix {
        private CollectToOrderedSetFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.fix.collect.to.ordered.family.name", (Object[])new Object[0]);
            if (string == null) {
                CollectToOrderedSetFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression sortCall;
            if (project == null) {
                CollectToOrderedSetFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                CollectToOrderedSetFix.$$$reportNull$$$0(2);
            }
            if ((sortCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiMethodCallExpression collector = StreamApiUtil.findSubsequentCall(sortCall, c -> false, UNORDERED_COLLECTOR, CALLS_KEEPING_SORT_ORDER::contains);
            if (collector == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String replacementText = "java.util.stream.Collectors.toCollection(java.util.LinkedHashSet::new)";
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)collector, replacementText);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$CollectToOrderedSetFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$CollectToOrderedSetFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RemoveCallFix
    implements LocalQuickFix {
        private final String myMethodName;

        RemoveCallFix(String methodName) {
            this.myMethodName = methodName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.fix.name", (Object[])new Object[]{this.myMethodName});
            if (string == null) {
                RemoveCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.stream.optional.call.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call;
            if (project == null) {
                RemoveCallFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RemoveCallFix.$$$reportNull$$$0(3);
            }
            if ((call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$RemoveCallFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$RemoveCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

