/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class HighlightImportedElementsHandler
extends HighlightUsagesHandlerBase<PsiMember> {
    private final PsiElement myTarget;
    private final PsiImportStatementBase myImportStatement;
    private final boolean myImportStatic;
    private Map<PsiMember, List<PsiElement>> myClassReferenceListMap;

    public HighlightImportedElementsHandler(Editor editor, PsiFile file, PsiElement target, PsiImportStatementBase importStatement) {
        super(editor, file);
        this.myTarget = target;
        this.myImportStatement = importStatement;
        this.myImportStatic = this.myImportStatement instanceof PsiImportStaticStatement;
    }

    public List<PsiMember> getTargets() {
        PsiJavaCodeReferenceElement importReference2 = this.myImportStatement.getImportReference();
        if (importReference2 == null) {
            return Collections.emptyList();
        }
        PsiJavaFile javaFile = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)importReference2, PsiJavaFile.class);
        if (javaFile == null) {
            return Collections.emptyList();
        }
        JavaResolveResult[] resolveResults = importReference2.multiResolve(false);
        if (resolveResults.length == 0) {
            return Collections.emptyList();
        }
        PsiElement[] importedElements = new PsiElement[resolveResults.length];
        for (int i = 0; i < resolveResults.length; ++i) {
            JavaResolveResult resolveResult = resolveResults[i];
            importedElements[i] = resolveResult.getElement();
        }
        ReferenceCollector collector = new ReferenceCollector(importedElements, this.myImportStatement.isOnDemand(), this.myImportStatic);
        javaFile.accept((PsiElementVisitor)collector);
        this.myClassReferenceListMap = collector.getClassReferenceListMap();
        if (this.myClassReferenceListMap.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<PsiMember>(this.myClassReferenceListMap.keySet());
    }

    protected void selectTargets(List<PsiMember> targets, Consumer<List<PsiMember>> selectionConsumer) {
        if (targets.isEmpty()) {
            selectionConsumer.consume(Collections.emptyList());
            return;
        }
        if (targets.size() == 1) {
            selectionConsumer.consume(Collections.singletonList(targets.get(0)));
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            selectionConsumer.consume(targets);
            return;
        }
        Collections.sort(targets, new PsiMemberComparator());
        ArrayList<String> model = new ArrayList<String>();
        String allListed = CodeInsightBundle.message((String)"highlight.thrown.exceptions.chooser.all.entry", (Object[])new Object[0]);
        model.add(allListed);
        model.addAll(targets);
        NavigationItemListCellRenderer renderer = new NavigationItemListCellRenderer();
        JBPopupFactory.getInstance().createPopupChooserBuilder(model).setSelectionMode(0).setRenderer((ListCellRenderer)renderer).setNamerForFiltering(o -> {
            if (o instanceof PsiMember) {
                PsiMember member = (PsiMember)o;
                return member.getName();
            }
            return o.toString();
        }).setTitle(this.myImportStatic ? CodeInsightBundle.message((String)"highlight.imported.members.chooser.title", (Object[])new Object[0]) : CodeInsightBundle.message((String)"highlight.imported.classes.chooser.title", (Object[])new Object[0])).setItemChosenCallback(selectedValue -> {
            if (selectedValue.equals(allListed)) {
                selectionConsumer.consume((Object)targets);
            } else {
                selectionConsumer.consume(Collections.singletonList((PsiMember)selectedValue));
            }
        }).createPopup().showInBestPositionFor(this.myEditor);
    }

    public void computeUsages(List<PsiMember> targets) {
        if (targets.isEmpty()) {
            this.buildStatusText("import", 0);
            return;
        }
        if (this.myClassReferenceListMap == null) {
            return;
        }
        this.addOccurrence(this.myTarget);
        for (PsiMember target : targets) {
            List<PsiElement> elements = this.myClassReferenceListMap.get(target);
            for (PsiElement element : elements) {
                this.addOccurrence(element);
            }
        }
        this.buildStatusText("import", this.myReadUsages.size() - 1);
    }

    static class PsiMemberComparator
    implements Comparator<PsiMember> {
        PsiMemberComparator() {
        }

        @Override
        public int compare(PsiMember member1, PsiMember member2) {
            String name1 = member1.getName();
            if (name1 == null) {
                return -1;
            }
            String name2 = member2.getName();
            if (name2 == null) {
                return 1;
            }
            int i = name1.compareTo(name2);
            if (i != 0) {
                return i;
            }
            PsiJavaFile file1 = (PsiJavaFile)member1.getContainingFile();
            PsiJavaFile file2 = (PsiJavaFile)member2.getContainingFile();
            String packageName1 = file1.getPackageName();
            String packageName2 = file2.getPackageName();
            return packageName1.compareTo(packageName2);
        }
    }

    static class ReferenceCollector
    extends JavaRecursiveElementVisitor {
        private final Map<PsiMember, List<PsiElement>> classReferenceListMap;
        private final PsiElement[] myImportTargets;
        private final boolean myOnDemand;
        private final boolean myImportStatic;

        ReferenceCollector(@NotNull PsiElement[] importTargets, boolean onDemand, boolean importStatic) {
            if (importTargets == null) {
                ReferenceCollector.$$$reportNull$$$0(0);
            }
            this.classReferenceListMap = new HashMap<PsiMember, List<PsiElement>>();
            this.myImportTargets = importTargets;
            this.myOnDemand = onDemand;
            this.myImportStatic = importStatic;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (!this.myImportStatic && reference.getText().equals(reference.getQualifiedName())) {
                return;
            }
            PsiElement parent = reference.getParent();
            if (parent instanceof PsiImportStatementBase) {
                return;
            }
            while (parent instanceof PsiJavaCodeReferenceElement) {
                if (!((parent = parent.getParent()) instanceof PsiImportStatementBase)) continue;
                return;
            }
            if (this.myImportStatic) {
                this.checkStaticImportReference(reference);
            } else {
                this.checkImportReference(reference);
            }
        }

        private void checkStaticImportReference(PsiJavaCodeReferenceElement reference) {
            if (reference.isQualified()) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiMethod || target instanceof PsiClass || target instanceof PsiField)) {
                return;
            }
            PsiMember member = (PsiMember)target;
            for (PsiElement importTarget : this.myImportTargets) {
                if (importTarget instanceof PsiMethod) {
                    if (!member.equals(importTarget)) continue;
                    this.addReference(member, reference);
                    continue;
                }
                if (!(importTarget instanceof PsiClass)) continue;
                PsiClass importClass = (PsiClass)importTarget;
                if (this.myOnDemand) {
                    PsiClass containingClass = member.getContainingClass();
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)importClass, (PsiClass)containingClass, (boolean)true)) continue;
                    this.addReference(member, reference);
                    continue;
                }
                if (!importTarget.equals(member)) continue;
                this.addReference(member, reference);
            }
        }

        private void checkImportReference(PsiJavaCodeReferenceElement reference) {
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass referencedClass = (PsiClass)element;
            for (PsiElement importTarget : this.myImportTargets) {
                if (importTarget instanceof PsiPackage) {
                    if (referencedClass.getContainingClass() != null) {
                        return;
                    }
                    PsiFile file = referencedClass.getContainingFile();
                    if (!(file instanceof PsiJavaFile)) {
                        return;
                    }
                    PsiJavaFile javaFile = (PsiJavaFile)file;
                    PsiPackage aPackage = (PsiPackage)importTarget;
                    String packageName = aPackage.getQualifiedName();
                    String filePackage = javaFile.getPackageName();
                    if (!filePackage.equals(packageName)) continue;
                    this.addReference((PsiMember)referencedClass, reference);
                    continue;
                }
                if (!(importTarget instanceof PsiClass)) continue;
                PsiClass aClass = (PsiClass)importTarget;
                String name = aClass.getQualifiedName();
                if (name == null) {
                    return;
                }
                if (!this.myOnDemand) {
                    if (!name.equals(referencedClass.getQualifiedName())) continue;
                    this.addReference((PsiMember)referencedClass, reference);
                    continue;
                }
                PsiClass containingClass = referencedClass.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                if (!name.equals(containingClass.getQualifiedName())) continue;
                this.addReference((PsiMember)referencedClass, reference);
            }
        }

        private void addReference(PsiMember referencedMember, PsiJavaCodeReferenceElement reference) {
            List<PsiElement> referenceList = this.classReferenceListMap.get(referencedMember);
            if (referenceList == null) {
                referenceList = new ArrayList<PsiElement>();
                this.classReferenceListMap.put(referencedMember, referenceList);
            }
            referenceList.add(reference.getReferenceNameElement());
        }

        public Map<PsiMember, List<PsiElement>> getClassReferenceListMap() {
            return this.classReferenceListMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importTargets", "com/intellij/codeInsight/highlighting/HighlightImportedElementsHandler$ReferenceCollector", "<init>"));
        }
    }
}

