/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.MissingMethodBodyFixer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemicolonFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        if (SemicolonFixer.fixReturn(editor, psiElement)) {
            return;
        }
        if (SemicolonFixer.fixForUpdate(editor, psiElement)) {
            return;
        }
        SemicolonFixer.fixAfterLastValidElement(editor, psiElement);
    }

    private static boolean fixReturn(@NotNull Editor editor, @Nullable PsiElement psiElement) {
        PsiReturnStatement stmt;
        PsiMethod method;
        if (editor == null) {
            SemicolonFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiReturnStatement && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class})) != null && PsiType.VOID.equals((Object)method.getReturnType()) && (stmt = (PsiReturnStatement)psiElement).getReturnValue() != null) {
            Document doc = editor.getDocument();
            doc.insertString(stmt.getTextRange().getStartOffset() + "return".length(), (CharSequence)";");
            return true;
        }
        return false;
    }

    private static boolean fixForUpdate(@NotNull Editor editor, @Nullable PsiElement psiElement) {
        if (editor == null) {
            SemicolonFixer.$$$reportNull$$$0(1);
        }
        if (!(psiElement instanceof PsiForStatement)) {
            return false;
        }
        PsiForStatement forStatement = (PsiForStatement)psiElement;
        PsiExpression condition2 = forStatement.getCondition();
        if (forStatement.getUpdate() != null || condition2 == null) {
            return false;
        }
        TextRange range = condition2.getTextRange();
        Document document = editor.getDocument();
        CharSequence text2 = document.getCharsSequence();
        int max = forStatement.getTextRange().getEndOffset();
        for (int i = range.getEndOffset() - 1; i < max; ++i) {
            if (text2.charAt(i) != ';') continue;
            return false;
        }
        String toInsert = ";";
        if (CodeStyle.getSettings((PsiFile)psiElement.getContainingFile()).getCommonSettings((Language)JavaLanguage.INSTANCE).SPACE_AFTER_SEMICOLON) {
            toInsert = toInsert + " ";
        }
        document.insertString(range.getEndOffset(), (CharSequence)toInsert);
        return true;
    }

    private static boolean fixAfterLastValidElement(@NotNull Editor editor, @Nullable PsiElement psiElement) {
        if (editor == null) {
            SemicolonFixer.$$$reportNull$$$0(2);
        }
        if (psiElement instanceof PsiExpressionStatement || psiElement instanceof PsiDeclarationStatement || psiElement instanceof PsiImportStatementBase || psiElement instanceof PsiDoWhileStatement || psiElement instanceof PsiReturnStatement || psiElement instanceof PsiThrowStatement || psiElement instanceof PsiBreakStatement || psiElement instanceof PsiContinueStatement || psiElement instanceof PsiAssertStatement || psiElement instanceof PsiPackageStatement || SemicolonFixer.isStandaloneField(psiElement) || psiElement instanceof PsiMethod && ((PsiMethod)psiElement).getBody() == null && !MissingMethodBodyFixer.shouldHaveBody((PsiMethod)psiElement) || psiElement instanceof PsiRequiresStatement || psiElement instanceof PsiPackageAccessibilityStatement || psiElement instanceof PsiUsesStatement || psiElement instanceof PsiProvidesStatement) {
            String text2 = psiElement.getText();
            int tailLength = 0;
            ASTNode leaf = TreeUtil.findLastLeaf((ASTNode)psiElement.getNode());
            while (leaf != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(leaf.getElementType())) {
                tailLength += leaf.getTextLength();
                leaf = TreeUtil.prevLeaf((ASTNode)leaf);
            }
            if (leaf == null) {
                return false;
            }
            if (tailLength > 0) {
                text2 = text2.substring(0, text2.length() - tailLength);
            }
            int insertionOffset = leaf.getTextRange().getEndOffset();
            Document doc = editor.getDocument();
            if (psiElement instanceof PsiField && ((PsiField)psiElement).hasModifierProperty("abstract")) {
                doc.insertString(insertionOffset, (CharSequence)"()");
                insertionOffset += "()".length();
            }
            if (!StringUtil.endsWithChar((CharSequence)text2, (char)';')) {
                PsiElement parent = psiElement.getParent();
                String toInsert = ";";
                if (parent instanceof PsiForStatement) {
                    if (((PsiForStatement)parent).getUpdate() == psiElement) {
                        return false;
                    }
                    if (CodeStyle.getSettings((PsiFile)psiElement.getContainingFile()).getCommonSettings((Language)JavaLanguage.INSTANCE).SPACE_AFTER_SEMICOLON) {
                        toInsert = toInsert + " ";
                    }
                }
                doc.insertString(insertionOffset, (CharSequence)toInsert);
                return true;
            }
        }
        return false;
    }

    private static boolean isStandaloneField(@Nullable PsiElement psiElement) {
        return psiElement instanceof PsiField && !(psiElement instanceof PsiEnumConstant) && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().beforeLeaf((ElementPattern)PsiJavaPatterns.psiElement().withText(","))).accepts((Object)psiElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/SemicolonFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fixReturn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fixForUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fixAfterLastValidElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

