/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseBlockMover
extends StatementUpDownMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        LineRange range2;
        PsiElement lastToMove2;
        PsiElement firstToMove2;
        if (editor == null) {
            CaseBlockMover.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CaseBlockMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            CaseBlockMover.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiElement startElement = CaseBlockMover.firstNonWhiteElement((int)editor.getSelectionModel().getSelectionStart(), (PsiFile)file, (boolean)true);
        if (startElement == null) {
            return false;
        }
        PsiElement endElement = CaseBlockMover.firstNonWhiteElement((int)editor.getSelectionModel().getSelectionEnd(), (PsiFile)file, (boolean)false);
        if (endElement == null) {
            return false;
        }
        PsiSwitchLabelStatement caseStatement = (PsiSwitchLabelStatement)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement), PsiSwitchLabelStatement.class, (boolean)false);
        if (caseStatement == null) {
            return false;
        }
        PsiSwitchLabelStatement firstToMove = CaseBlockMover.getThisCaseBlockStart(caseStatement);
        PsiElement nextCaseBlockStart = CaseBlockMover.getNextCaseBlockStart(caseStatement);
        PsiElement lastToMove = PsiTreeUtil.skipWhitespacesBackward((PsiElement)nextCaseBlockStart);
        assert (lastToMove != null);
        LineRange range = CaseBlockMover.createRange(editor.getDocument(), (PsiElement)firstToMove, lastToMove);
        if (range == null) {
            return info.prohibitMove();
        }
        info.toMove = range;
        if (down) {
            if (!(nextCaseBlockStart instanceof PsiSwitchLabelStatement) || nextCaseBlockStart == caseStatement) {
                return info.prohibitMove();
            }
            firstToMove2 = nextCaseBlockStart;
            nextCaseBlockStart = CaseBlockMover.getNextCaseBlockStart((PsiSwitchLabelStatement)firstToMove2);
            lastToMove2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)nextCaseBlockStart);
            assert (lastToMove2 != null);
        } else {
            lastToMove2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)firstToMove);
            if (lastToMove2 == null) {
                return info.prohibitMove();
            }
            firstToMove2 = PsiTreeUtil.getPrevSiblingOfType((PsiElement)lastToMove2, PsiSwitchLabelStatement.class);
            if (firstToMove2 == null) {
                return info.prohibitMove();
            }
            firstToMove2 = CaseBlockMover.getThisCaseBlockStart((PsiSwitchLabelStatement)firstToMove2);
        }
        if ((range2 = CaseBlockMover.createRange(editor.getDocument(), firstToMove2, lastToMove2)) == null) {
            return info.prohibitMove();
        }
        info.toMove2 = range2;
        return true;
    }

    @NotNull
    private static PsiSwitchLabelStatement getThisCaseBlockStart(PsiSwitchLabelStatement element) {
        PsiElement tmp;
        while ((tmp = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element)) instanceof PsiSwitchLabelStatement) {
            element = (PsiSwitchLabelStatement)tmp;
        }
        PsiSwitchLabelStatement psiSwitchLabelStatement = element;
        if (psiSwitchLabelStatement == null) {
            CaseBlockMover.$$$reportNull$$$0(3);
        }
        return psiSwitchLabelStatement;
    }

    @NotNull
    private static PsiElement getNextCaseBlockStart(PsiSwitchLabelStatement element) {
        PsiElement tmp;
        PsiSwitchLabelStatement result = element;
        while ((tmp = PsiTreeUtil.skipWhitespacesForward((PsiElement)result)) instanceof PsiSwitchLabelStatement) {
            result = tmp;
        }
        tmp = PsiTreeUtil.getNextSiblingOfType((PsiElement)result, PsiSwitchLabelStatement.class);
        PsiElement psiElement = tmp == null ? result.getParent().getLastChild() : tmp;
        if (psiElement == null) {
            CaseBlockMover.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @Nullable
    private static LineRange createRange(@NotNull Document document, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        int endLine;
        int startOffset;
        int startLine;
        CharSequence text2;
        if (document == null) {
            CaseBlockMover.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            CaseBlockMover.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            CaseBlockMover.$$$reportNull$$$0(7);
        }
        if (!CharArrayUtil.isEmptyOrSpaces((CharSequence)(text2 = document.getImmutableCharSequence()), (int)document.getLineStartOffset(startLine = document.getLineNumber(startOffset = startElement.getTextRange().getStartOffset())), (int)startOffset)) {
            return null;
        }
        int endOffset = endElement.getTextRange().getEndOffset();
        if (!CharArrayUtil.isEmptyOrSpaces((CharSequence)text2, (int)endOffset, (int)document.getLineEndOffset(endLine = document.getLineNumber(endOffset)))) {
            return null;
        }
        return new LineRange(startLine, endLine + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/moveUpDown/CaseBlockMover";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/moveUpDown/CaseBlockMover";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThisCaseBlockStart";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextCaseBlockStart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

