/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StaticImportMemberFix<T extends PsiMember>
implements IntentionAction,
HintAction {
    private List<T> candidates;

    @NotNull
    protected abstract String getBaseText();

    @NotNull
    protected abstract String getMemberPresentableText(T var1);

    @NotNull
    public String getText() {
        String text2 = this.getBaseText();
        text2 = this.candidates != null && this.candidates.size() == 1 ? text2 + " '" + this.getMemberPresentableText((PsiMember)this.candidates.get(0)) + "'" : text2 + "...";
        String string = text2;
        if (string == null) {
            StaticImportMemberFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            StaticImportMemberFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        List<T> list;
        if (project == null) {
            StaticImportMemberFix.$$$reportNull$$$0(2);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)file)) return false;
        if (!(file instanceof PsiJavaFile)) return false;
        if (this.getElement() == null) return false;
        if (!this.getElement().isValid()) return false;
        if (this.getQualifierExpression() != null) return false;
        if (this.resolveRef() != null) return false;
        if (!BaseIntentionAction.canModify((PsiElement)file)) return false;
        if (this.candidates == null) {
            this.candidates = this.getMembersToImport(false, StaticMembersProcessor.SearchMode.MAX_2_MEMBERS);
            list = this.candidates;
        } else {
            list = this.candidates;
        }
        if (list.isEmpty()) return false;
        return true;
    }

    @NotNull
    protected abstract List<T> getMembersToImport(boolean var1, @NotNull StaticMembersProcessor.SearchMode var2);

    protected abstract boolean toAddStaticImports();

    public static boolean isExcluded(PsiMember method) {
        String name = PsiUtil.getMemberQualifiedName((PsiMember)method);
        return name != null && JavaProjectCodeInsightSettings.getSettings(method.getProject()).isExcluded(name);
    }

    @NotNull
    protected abstract QuestionAction createQuestionAction(List<? extends T> var1, @NotNull Project var2, Editor var3);

    @Nullable
    protected abstract PsiElement getElement();

    @Nullable
    protected abstract PsiElement getQualifierExpression();

    @Nullable
    protected abstract PsiElement resolveRef();

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            StaticImportMemberFix.$$$reportNull$$$0(3);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            List<T> methodsToImport;
            if (project == null) {
                StaticImportMemberFix.$$$reportNull$$$0(5);
            }
            if ((methodsToImport = this.getMembersToImport(false, StaticMembersProcessor.SearchMode.MAX_100_MEMBERS)).isEmpty()) {
                return;
            }
            this.createQuestionAction(methodsToImport, project, editor).execute();
        });
    }

    private ImportClassFixBase.Result doFix(Editor editor) {
        if (!CodeInsightSettings.getInstance().ADD_MEMBER_IMPORTS_ON_THE_FLY) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        List<T> candidates = this.getMembersToImport(true, StaticMembersProcessor.SearchMode.MAX_100_MEMBERS);
        if (candidates.isEmpty()) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        if (this.toAddStaticImports() && candidates.size() == 1 && PsiTreeUtil.isAncestor((PsiElement)element.getContainingFile(), (PsiElement)((PsiElement)candidates.get(0)), (boolean)true)) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        QuestionAction action = this.createQuestionAction(candidates, element.getProject(), editor);
        String hintText = ShowAutoImportPass.getMessage((candidates.size() > 1 ? 1 : 0) != 0, (String)this.getMemberPresentableText((PsiMember)candidates.get(0)));
        if (!ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            TextRange textRange = element.getTextRange();
            HintManager.getInstance().showQuestionHint(editor, hintText, textRange.getStartOffset(), textRange.getEndOffset(), action);
        }
        return ImportClassFixBase.Result.POPUP_SHOWN;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean showHint(@NotNull Editor editor) {
        PsiElement callExpression;
        if (editor == null) {
            StaticImportMemberFix.$$$reportNull$$$0(4);
        }
        if ((callExpression = this.getElement()) == null || this.getQualifierExpression() != null) {
            return false;
        }
        ImportClassFixBase.Result result = this.doFix(editor);
        return result == ImportClassFixBase.Result.POPUP_SHOWN || result == ImportClassFixBase.Result.CLASS_AUTO_IMPORTED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMemberFix";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMemberFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

