/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateServiceClassFixBase;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateServiceInterfaceOrClassFix
extends CreateServiceClassFixBase {
    private String myInterfaceName;

    public CreateServiceInterfaceOrClassFix(PsiJavaCodeReferenceElement referenceElement) {
        referenceElement = CreateServiceInterfaceOrClassFix.findTopmostReference(referenceElement);
        PsiElement parent = referenceElement.getParent();
        if ((parent instanceof PsiUsesStatement && ((PsiUsesStatement)parent).getClassReference() == referenceElement || parent instanceof PsiProvidesStatement && ((PsiProvidesStatement)parent).getInterfaceReference() == referenceElement) && referenceElement.isQualified()) {
            this.myInterfaceName = referenceElement.getQualifiedName();
        }
    }

    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("create.service.interface.fix.name", this.myInterfaceName);
        if (string == null) {
            CreateServiceInterfaceOrClassFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.service.interface.fix.family.name", new Object[0]);
        if (string == null) {
            CreateServiceInterfaceOrClassFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        GlobalSearchScope projectScope;
        if (project == null) {
            CreateServiceInterfaceOrClassFix.$$$reportNull$$$0(2);
        }
        if (this.myInterfaceName == null) {
            return false;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        return psiFacade.findClass(this.myInterfaceName, projectScope = GlobalSearchScope.projectScope((Project)project)) == null && CreateServiceInterfaceOrClassFix.isQualifierInProject(this.myInterfaceName, project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Map<Module, PsiDirectory[]> psiRootDirs;
        PsiPackage psiPackage;
        if (project == null) {
            CreateServiceInterfaceOrClassFix.$$$reportNull$$$0(3);
        }
        String qualifierText = StringUtil.getPackageName((String)this.myInterfaceName);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass outerClass = psiFacade.findClass(qualifierText, GlobalSearchScope.projectScope((Project)project));
        if (outerClass != null) {
            this.createClassInOuter(qualifierText, outerClass);
            return;
        }
        do {
            psiPackage = psiFacade.findPackage(qualifierText);
            qualifierText = StringUtil.getPackageName((String)qualifierText);
        } while (psiPackage == null && !StringUtil.isEmpty((String)qualifierText));
        if (psiPackage != null && !(psiRootDirs = CreateServiceInterfaceOrClassFix.getModuleRootDirs(psiPackage)).isEmpty()) {
            PsiDirectory rootDir;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                PsiDirectory rootDir2 = (PsiDirectory)file.getUserData(SERVICE_ROOT_DIR);
                CreateClassKind classKind = (CreateClassKind)file.getUserData(SERVICE_CLASS_KIND);
                if (rootDir2 != null && classKind != null) {
                    WriteAction.run(() -> CreateServiceInterfaceOrClassFix.createClassInRoot(this.myInterfaceName, classKind, rootDir2, (PsiElement)file, null));
                }
                return;
            }
            CreateServiceInterfaceDialog dialog = new CreateServiceInterfaceDialog(project, psiRootDirs);
            if (dialog.showAndGet() && (rootDir = dialog.getRootDir()) != null) {
                CreateClassKind classKind = dialog.getClassKind();
                PsiClass psiClass = (PsiClass)WriteAction.compute(() -> CreateServiceInterfaceOrClassFix.createClassInRoot(this.myInterfaceName, classKind, rootDir, (PsiElement)file, null));
                CreateServiceInterfaceOrClassFix.positionCursor(psiClass);
            }
        }
    }

    @NotNull
    private static Map<Module, PsiDirectory[]> getModuleRootDirs(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            CreateServiceInterfaceOrClassFix.$$$reportNull$$$0(4);
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)psiPackage.getProject());
        Map map2 = ((StreamEx)StreamEx.of((Object[])psiPackage.getDirectories()).map(PsiDirectory::getVirtualFile).map(arg_0 -> ((ProjectFileIndex)index).getSourceRootForFile(arg_0)).nonNull().map(arg_0 -> ((ProjectFileIndex)index).getModuleForFile(arg_0)).nonNull().distinct()).mapToEntry(CreateServiceClassFixBase::getModuleRootDirs).filterValues(dirs -> !ArrayUtil.isEmpty((Object[])dirs)).toMap();
        if (map2 == null) {
            CreateServiceInterfaceOrClassFix.$$$reportNull$$$0(5);
        }
        return map2;
    }

    private void createClassInOuter(@NotNull String qualifierText, @NotNull PsiClass outerClass) {
        if (qualifierText == null) {
            CreateServiceInterfaceOrClassFix.$$$reportNull$$$0(6);
        }
        if (outerClass == null) {
            CreateServiceInterfaceOrClassFix.$$$reportNull$$$0(7);
        }
        String name = this.myInterfaceName.substring(qualifierText.length() + 1);
        PsiClass psiClass = (PsiClass)WriteAction.compute(() -> {
            if (outerClass == null) {
                CreateServiceInterfaceOrClassFix.$$$reportNull$$$0(8);
            }
            return CreateServiceInterfaceOrClassFix.createClassInOuterImpl(name, outerClass, null);
        });
        CreateServiceInterfaceOrClassFix.positionCursor(psiClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateServiceInterfaceOrClassFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierText";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateServiceInterfaceOrClassFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRootDirs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRootDirs";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createClassInOuter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createClassInOuter$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CreateServiceInterfaceDialog
    extends DialogWrapper {
        private final ComboBoxWithWidePopup<Module> myModuleCombo;
        private final ComboBoxWithWidePopup<PsiDirectory> myRootDirCombo;
        private final TemplateKindCombo myKindCombo;

        protected CreateServiceInterfaceDialog(@NotNull Project project, Map<Module, PsiDirectory[]> psiRootDirs) {
            if (psiRootDirs == null) {
                CreateServiceInterfaceDialog.$$$reportNull$$$0(0);
            }
            super(project);
            this.myModuleCombo = new ComboBoxWithWidePopup();
            this.myRootDirCombo = new ComboBoxWithWidePopup();
            this.myKindCombo = new TemplateKindCombo();
            this.setTitle("Create Service");
            this.myModuleCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Module>(){

                public void customize(JList list, Module module, int index, boolean selected, boolean hasFocus) {
                    this.setText(module.getName());
                }
            });
            this.myRootDirCombo.setRenderer((ListCellRenderer)((Object)new CreateServiceClassFixBase.PsiDirectoryListCellRenderer()));
            this.myModuleCombo.addActionListener(e -> {
                if (psiRootDirs == null) {
                    CreateServiceInterfaceDialog.$$$reportNull$$$0(3);
                }
                this.updateRootDirsCombo(psiRootDirs);
            });
            Module[] modules = psiRootDirs.keySet().toArray(Module.EMPTY_ARRAY);
            Arrays.sort(modules, Comparator.comparing(Module::getName));
            this.myModuleCombo.setModel(new DefaultComboBoxModel<Module>(modules));
            this.updateRootDirsCombo(psiRootDirs);
            this.myKindCombo.addItem(CommonRefactoringUtil.capitalize((String)CreateClassKind.CLASS.getDescription()), PlatformIcons.CLASS_ICON, CreateClassKind.CLASS.name());
            this.myKindCombo.addItem(CommonRefactoringUtil.capitalize((String)CreateClassKind.INTERFACE.getDescription()), PlatformIcons.INTERFACE_ICON, CreateClassKind.INTERFACE.name());
            this.myKindCombo.addItem(CommonRefactoringUtil.capitalize((String)CreateClassKind.ANNOTATION.getDescription()), PlatformIcons.ANNOTATION_TYPE_ICON, CreateClassKind.ANNOTATION.name());
            this.init();
        }

        private void updateRootDirsCombo(@NotNull Map<Module, PsiDirectory[]> psiRootDirs) {
            if (psiRootDirs == null) {
                CreateServiceInterfaceDialog.$$$reportNull$$$0(1);
            }
            Module module = (Module)this.myModuleCombo.getSelectedItem();
            PsiDirectory[] moduleRootDirs = psiRootDirs.getOrDefault(module, PsiDirectory.EMPTY_ARRAY);
            this.myRootDirCombo.setModel(new DefaultComboBoxModel<PsiDirectory>(moduleRootDirs));
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                CreateServiceInterfaceDialog.$$$reportNull$$$0(2);
            }
            return actionArray;
        }

        protected JComponent createCenterPanel() {
            return null;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            JTextField nameTextField = new JTextField(CreateServiceInterfaceOrClassFix.this.myInterfaceName);
            nameTextField.setEditable(false);
            PanelGridBuilder builder = UI.PanelFactory.grid();
            builder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)nameTextField).withLabel("Name:"));
            if (this.myModuleCombo.getModel().getSize() > 1) {
                builder.add((PanelBuilder)UI.PanelFactory.panel(this.myModuleCombo).withLabel("Module:"));
            }
            if (this.myRootDirCombo.getModel().getSize() > 1) {
                builder.add((PanelBuilder)UI.PanelFactory.panel(this.myRootDirCombo).withLabel("Source root:"));
            }
            builder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myKindCombo).withLabel("Kind:"));
            return builder.createPanel();
        }

        @Nullable
        public PsiDirectory getRootDir() {
            return (PsiDirectory)this.myRootDirCombo.getSelectedItem();
        }

        public CreateClassKind getClassKind() {
            return CreateClassKind.valueOf(this.myKindCombo.getSelectedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiRootDirs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateServiceInterfaceOrClassFix$CreateServiceInterfaceDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateServiceInterfaceOrClassFix$CreateServiceInterfaceDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "updateRootDirsCombo";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$new$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

