/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import org.jetbrains.annotations.NotNull;

public class CreateLocalFromUsageFix
extends CreateVarFromUsageFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateLocalFromUsageFix");

    public CreateLocalFromUsageFix(PsiReferenceExpression referenceExpression) {
        super(referenceExpression);
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.local.from.usage.text", varName);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        if (!super.isAvailableImpl(offset)) {
            return false;
        }
        if (this.myReferenceExpression.isQualified()) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)this.myReferenceExpression, PsiCodeBlock.class) != null) {
            PsiMethod method;
            PsiExpression expression2;
            PsiStatement anchor = CreateLocalFromUsageFix.getAnchor(new PsiExpression[]{this.myReferenceExpression});
            return !(anchor instanceof PsiExpressionStatement) || !((expression2 = ((PsiExpressionStatement)anchor).getExpression()) instanceof PsiMethodCallExpression) || (method = ((PsiMethodCallExpression)expression2).resolveMethod()) == null || !method.isConstructor();
        }
        return false;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        PsiAssignmentExpression assignment;
        PsiType type2;
        if (CreateFromUsageUtils.isValidReference((PsiReference)this.myReferenceExpression, false)) {
            return;
        }
        final Project project = this.myReferenceExpression.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        final PsiFile targetFile = targetClass.getContainingFile();
        PsiType[] expectedTypes = CreateFromUsageUtils.guessType((PsiExpression)this.myReferenceExpression, false);
        final SmartTypePointer defaultType = SmartTypePointerManager.getInstance((Project)project).createSmartTypePointer(expectedTypes[0]);
        PsiType preferredType = TypeSelectorManagerImpl.getPreferredType(expectedTypes, expectedTypes[0]);
        PsiType psiType = type2 = preferredType != null ? preferredType : expectedTypes[0];
        if (LambdaUtil.notInferredType((PsiType)type2)) {
            type2 = PsiType.getJavaLangObject((PsiManager)this.myReferenceExpression.getManager(), (GlobalSearchScope)targetClass.getResolveScope());
        }
        String varName = this.myReferenceExpression.getReferenceName();
        PsiExpression initializer = null;
        boolean isInline = false;
        PsiReferenceExpression[] expressions2 = CreateFromUsageUtils.collectExpressions((PsiExpression)this.myReferenceExpression, PsiMember.class, PsiFile.class);
        PsiStatement anchor = CreateLocalFromUsageFix.getAnchor((PsiExpression[])expressions2);
        if (anchor instanceof PsiExpressionStatement && ((PsiExpressionStatement)anchor).getExpression() instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)((PsiExpressionStatement)anchor).getExpression()).getLExpression().textMatches((PsiElement)this.myReferenceExpression)) {
            initializer = assignment.getRExpression();
            isInline = true;
        }
        PsiDeclarationStatement decl = factory.createVariableDeclarationStatement(varName, type2, initializer);
        TypeExpression expression2 = new TypeExpression(project, expectedTypes);
        if (isInline) {
            PsiElement nextSibling;
            PsiExpression expr = ((PsiExpressionStatement)anchor).getExpression();
            PsiElement semicolon = expr.getNextSibling();
            if (semicolon != null && (nextSibling = semicolon.getNextSibling()) != null) {
                decl.addRange(nextSibling, anchor.getLastChild());
            }
            decl = (PsiDeclarationStatement)anchor.replace((PsiElement)decl);
        } else {
            decl = (PsiDeclarationStatement)anchor.getParent().addBefore((PsiElement)decl, (PsiElement)anchor);
        }
        PsiVariable var = (PsiVariable)decl.getDeclaredElements()[0];
        boolean isFinal = JavaCodeStyleSettings.getInstance((PsiFile)targetFile).GENERATE_FINAL_LOCALS && !CreateFromUsageUtils.isAccessedForWriting((PsiExpression[])expressions2);
        PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)isFinal);
        var = (PsiVariable)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)var);
        if (var == null) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)var);
        PsiTypeElement typeElement = var.getTypeElement();
        LOG.assertTrue(typeElement != null);
        builder.replaceElement((PsiElement)typeElement, AbstractJavaInplaceIntroducer.createExpression(expression2, typeElement.getText()));
        builder.setEndVariableAfter((PsiElement)var.getNameIdentifier());
        Template template = builder.buildTemplate();
        final Editor newEditor = CreateLocalFromUsageFix.positionCursor(project, targetFile, (PsiElement)var);
        if (newEditor == null) {
            return;
        }
        TextRange range = var.getTextRange();
        newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        CreateLocalFromUsageFix.startTemplate(newEditor, template, project, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(newEditor.getDocument());
                int offset = newEditor.getCaretModel().getOffset();
                PsiLocalVariable localVariable = (PsiLocalVariable)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)targetFile, (int)offset, PsiLocalVariable.class, (boolean)false);
                if (localVariable != null) {
                    TypeSelectorManagerImpl.typeSelected(localVariable.getType(), defaultType.getType());
                    ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance((Project)project).reformat((PsiElement)localVariable));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalFromUsageFix$1", "templateFinished"));
            }
        });
    }

    @Override
    protected boolean isAllowOuterTargetClass() {
        return false;
    }

    private static PsiStatement getAnchor(PsiExpression ... expressionOccurences) {
        PsiExpression parent = expressionOccurences[0];
        int minOffset = expressionOccurences[0].getTextRange().getStartOffset();
        for (int i = 1; i < expressionOccurences.length; ++i) {
            LOG.assertTrue((parent = PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)expressionOccurences[i])) != null);
            minOffset = Math.min(minOffset, expressionOccurences[i].getTextRange().getStartOffset());
        }
        PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class, (boolean)false);
        LOG.assertTrue(block != null && !block.isEmpty(), (Object)("block: " + block + "; parent: " + parent));
        PsiStatement[] statements = block.getStatements();
        for (int i = 1; i < statements.length; ++i) {
            if (statements[i].getTextRange().getStartOffset() <= minOffset) continue;
            return statements[i - 1];
        }
        return statements[statements.length - 1];
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.local.from.usage.family", new Object[0]);
        if (string == null) {
            CreateLocalFromUsageFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalFromUsageFix", "getFamilyName"));
    }
}

