/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SwitchStatementBranch;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BreakConverter;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConvertSwitchToIfIntention
implements IntentionAction {
    private final PsiSwitchStatement mySwitchExpression;

    public ConvertSwitchToIfIntention(@NotNull PsiSwitchStatement switchStatement) {
        if (switchStatement == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(0);
        }
        this.mySwitchExpression = switchStatement;
    }

    @NotNull
    public String getText() {
        String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"switch", "if"});
        if (string == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(3);
        }
        return ConvertSwitchToIfIntention.isAvailable(this.mySwitchExpression);
    }

    public static boolean isAvailable(PsiSwitchStatement switchStatement) {
        PsiCodeBlock body2 = switchStatement.getBody();
        return body2 != null && !body2.isEmpty() && BreakConverter.from(switchStatement) != null && !ConvertSwitchToIfIntention.mayFallThroughNonTerminalDefaultCase(body2);
    }

    private static boolean mayFallThroughNonTerminalDefaultCase(PsiCodeBlock body2) {
        List labels = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)body2, PsiSwitchLabelStatement.class);
        return StreamEx.of((Collection)labels).pairMap((prev, next) -> {
            if (prev.isDefaultCase()) {
                Set<PsiSwitchLabelStatement> targets = ConvertSwitchToIfIntention.getFallThroughTargets(body2);
                return targets.contains(prev) || targets.contains(next);
            }
            return false;
        }).has((Object)true);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(4);
        }
        ConvertSwitchToIfIntention.doProcessIntention(this.mySwitchExpression);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(5);
        }
        PsiSwitchStatement psiSwitchStatement = this.mySwitchExpression;
        if (psiSwitchStatement == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(6);
        }
        return psiSwitchStatement;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void doProcessIntention(@NotNull PsiSwitchStatement switchStatement) {
        String ifStatementText;
        String declarationString;
        String expressionText;
        boolean hadSideEffects;
        PsiCodeBlock body2;
        boolean isSwitchOnString;
        PsiExpression switchExpression;
        if (switchStatement == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(7);
        }
        if ((switchExpression = switchStatement.getExpression()) == null) {
            return;
        }
        PsiType switchExpressionType = RefactoringUtil.getTypeByExpressionWithExpectedType(switchExpression);
        if (switchExpressionType == null) {
            return;
        }
        CommentTracker commentTracker = new CommentTracker();
        commentTracker.markUnchanged(switchExpression);
        boolean useEquals = isSwitchOnString = switchExpressionType.equalsToText("java.lang.String");
        if (!useEquals) {
            PsiClass aClass = PsiUtil.resolveClassInType((PsiType)switchExpressionType);
            boolean bl = useEquals = aClass != null && !aClass.isEnum() && !TypeConversionUtil.isPrimitiveWrapper((String)aClass.getQualifiedName());
        }
        if ((body2 = switchStatement.getBody()) == null) {
            return;
        }
        Set<PsiSwitchLabelStatement> fallThroughTargets = ConvertSwitchToIfIntention.getFallThroughTargets(body2);
        boolean mayCompleteNormally = ControlFlowUtils.statementMayCompleteNormally((PsiStatement)switchStatement);
        BreakConverter converter = BreakConverter.from(switchStatement);
        if (converter == null) {
            return;
        }
        converter.process();
        List<SwitchStatementBranch> allBranches = ConvertSwitchToIfIntention.extractBranches(commentTracker, body2, fallThroughTargets);
        Project project = switchStatement.getProject();
        if (allBranches.stream().mapToInt(br -> br.getCaseValues().size()).sum() > 1 && RemoveUnusedVariableUtil.checkSideEffects(switchExpression, null, new ArrayList())) {
            hadSideEffects = true;
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            String variableName = isSwitchOnString ? javaCodeStyleManager.suggestUniqueVariableName("s", (PsiElement)switchExpression, true) : javaCodeStyleManager.suggestUniqueVariableName("i", (PsiElement)switchExpression, true);
            expressionText = variableName;
            declarationString = switchExpressionType.getCanonicalText() + ' ' + variableName + " = " + switchExpression.getText() + ';';
        } else {
            hadSideEffects = false;
            declarationString = null;
            expressionText = ParenthesesUtils.getPrecedence(switchExpression) > 9 ? '(' + switchExpression.getText() + ')' : switchExpression.getText();
        }
        StringBuilder ifStatementBuilder = new StringBuilder();
        boolean firstBranch = true;
        SwitchStatementBranch defaultBranch = null;
        for (SwitchStatementBranch branch : allBranches) {
            if (branch.isDefault()) {
                defaultBranch = branch;
                continue;
            }
            ConvertSwitchToIfIntention.dumpBranch(branch, expressionText, firstBranch, useEquals, ifStatementBuilder, commentTracker);
            firstBranch = false;
        }
        boolean unwrapDefault = false;
        if (defaultBranch != null && defaultBranch.hasStatements()) {
            boolean bl = unwrapDefault = defaultBranch.isAlwaysExecuted() || switchStatement.getParent() instanceof PsiCodeBlock && !mayCompleteNormally;
            if (!unwrapDefault) {
                ifStatementBuilder.append("else ");
                ConvertSwitchToIfIntention.dumpBody(defaultBranch, ifStatementBuilder, commentTracker);
            }
        }
        if ((ifStatementText = ifStatementBuilder.toString()).isEmpty()) {
            if (!unwrapDefault) {
                return;
            }
            ifStatementText = ";";
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiCodeBlock parent = (PsiCodeBlock)ObjectUtils.tryCast((Object)switchStatement.getParent(), PsiCodeBlock.class);
        if ((unwrapDefault || hadSideEffects) && parent == null) {
            commentTracker.grabComments((PsiElement)switchStatement);
            switchStatement = BlockUtils.expandSingleStatementToBlockStatement(switchStatement);
            parent = (PsiCodeBlock)switchStatement.getParent();
        }
        if (hadSideEffects) {
            PsiStatement declarationStatement = factory.createStatementFromText(declarationString, (PsiElement)switchStatement);
            parent.addBefore((PsiElement)declarationStatement, (PsiElement)switchStatement);
        }
        PsiStatement ifStatement = factory.createStatementFromText(ifStatementText, (PsiElement)switchStatement);
        if (unwrapDefault) {
            PsiElement addedIf = parent.addBefore((PsiElement)ifStatement, (PsiElement)switchStatement);
            StringBuilder sb = new StringBuilder();
            ConvertSwitchToIfIntention.dumpBody(defaultBranch, sb, commentTracker);
            PsiBlockStatement defaultBody = (PsiBlockStatement)factory.createStatementFromText(sb.toString(), (PsiElement)switchStatement);
            if (!BlockUtils.containsConflictingDeclarations(Objects.requireNonNull(switchStatement.getBody()), parent)) {
                BlockUtils.inlineCodeBlock((PsiStatement)switchStatement, defaultBody.getCodeBlock());
            } else {
                switchStatement.replace((PsiElement)defaultBody);
            }
            commentTracker.insertCommentsBefore(addedIf);
            if (ifStatementText.equals(";")) {
                addedIf.delete();
            } else {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(addedIf);
            }
        } else {
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(commentTracker.replaceAndRestoreComments((PsiElement)switchStatement, (PsiElement)ifStatement));
        }
    }

    @NotNull
    private static List<SwitchStatementBranch> extractBranches(CommentTracker commentTracker, PsiCodeBlock body2, Set<PsiSwitchLabelStatement> fallThroughTargets) {
        ArrayList<SwitchStatementBranch> openBranches = new ArrayList<SwitchStatementBranch>();
        HashSet declaredElements = new HashSet();
        ArrayList<SwitchStatementBranch> allBranches = new ArrayList<SwitchStatementBranch>();
        SwitchStatementBranch currentBranch = null;
        PsiElement[] children = body2.getChildren();
        boolean defaultAlwaysExecuted = true;
        for (int i = 1; i < children.length - 1; ++i) {
            PsiElement statement = children[i];
            if (statement instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)statement;
                if (currentBranch == null || !fallThroughTargets.contains(statement)) {
                    if (currentBranch != null) {
                        defaultAlwaysExecuted = false;
                    }
                    openBranches.clear();
                    currentBranch = new SwitchStatementBranch();
                    currentBranch.addPendingDeclarations(declaredElements);
                    allBranches.add(currentBranch);
                    openBranches.add(currentBranch);
                } else if (currentBranch.hasStatements()) {
                    currentBranch = new SwitchStatementBranch();
                    allBranches.add(currentBranch);
                    openBranches.add(currentBranch);
                }
                if (label.isDefaultCase()) {
                    currentBranch.setDefault();
                    currentBranch.setAlwaysExecuted(defaultAlwaysExecuted);
                    if (!defaultAlwaysExecuted) continue;
                    openBranches.retainAll(Collections.singleton(currentBranch));
                    continue;
                }
                PsiExpression value2 = label.getCaseValue();
                String valueText = ConvertSwitchToIfIntention.getCaseValueText(value2, commentTracker);
                currentBranch.addCaseValue(valueText);
                continue;
            }
            if (statement instanceof PsiStatement) {
                if (statement instanceof PsiDeclarationStatement) {
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    Collections.addAll(declaredElements, declarationStatement.getDeclaredElements());
                }
                for (SwitchStatementBranch branch : openBranches) {
                    branch.addStatement((PsiStatement)statement);
                }
                continue;
            }
            for (SwitchStatementBranch branch : openBranches) {
                if (statement instanceof PsiWhiteSpace) {
                    branch.addWhiteSpace(statement);
                    continue;
                }
                branch.addComment(statement);
            }
        }
        ArrayList<SwitchStatementBranch> arrayList = allBranches;
        if (arrayList == null) {
            ConvertSwitchToIfIntention.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static Set<PsiSwitchLabelStatement> getFallThroughTargets(PsiCodeBlock body2) {
        return StreamEx.of((Object[])body2.getStatements()).pairMap((s1, s2) -> s2 instanceof PsiSwitchLabelStatement && ControlFlowUtils.statementMayCompleteNormally(s1) ? (PsiSwitchLabelStatement)s2 : null).nonNull().toSet();
    }

    private static String getCaseValueText(PsiExpression value2, CommentTracker commentTracker) {
        if ((value2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)value2)) == null) {
            return "";
        }
        if (!(value2 instanceof PsiReferenceExpression)) {
            return commentTracker.text((PsiElement)value2);
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value2;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiEnumConstant)) {
            return commentTracker.text((PsiElement)value2);
        }
        PsiEnumConstant enumConstant = (PsiEnumConstant)target;
        PsiClass aClass = enumConstant.getContainingClass();
        if (aClass == null) {
            return commentTracker.text((PsiElement)value2);
        }
        return aClass.getQualifiedName() + '.' + commentTracker.text((PsiElement)referenceExpression);
    }

    private static void dumpBranch(SwitchStatementBranch branch, String expressionText, boolean firstBranch, boolean useEquals, @NonNls StringBuilder out, CommentTracker commentTracker) {
        if (!firstBranch) {
            out.append("else ");
        }
        ConvertSwitchToIfIntention.dumpCaseValues(expressionText, branch.getCaseValues(), useEquals, out);
        ConvertSwitchToIfIntention.dumpBody(branch, out, commentTracker);
    }

    private static void dumpCaseValues(String expressionText, List<String> caseValues2, boolean useEquals, @NonNls StringBuilder out) {
        out.append("if(");
        boolean firstCaseValue = true;
        for (String caseValue : caseValues2) {
            if (!firstCaseValue) {
                out.append("||");
            }
            firstCaseValue = false;
            if (useEquals) {
                out.append(caseValue).append(".equals(").append(expressionText).append(')');
                continue;
            }
            out.append(expressionText).append("==").append(caseValue);
        }
        out.append(')');
    }

    private static void dumpBody(SwitchStatementBranch branch, @NonNls StringBuilder out, CommentTracker commentTracker) {
        List<PsiElement> bodyStatements = branch.getBodyElements();
        out.append('{');
        for (PsiElement element : branch.getPendingDeclarations()) {
            if (ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope(bodyStatements.toArray(PsiElement.EMPTY_ARRAY))).findFirst() == null) continue;
            if (element instanceof PsiVariable) {
                PsiVariable var = (PsiVariable)element;
                out.append(var.getType().getCanonicalText()).append(' ').append(var.getName()).append(';');
                continue;
            }
            out.append(element.getText());
        }
        for (PsiElement bodyStatement : bodyStatements) {
            if (bodyStatement instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)bodyStatement;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                for (PsiStatement statement : codeBlock.getStatements()) {
                    out.append(commentTracker.text((PsiElement)statement));
                }
                continue;
            }
            out.append(commentTracker.text(bodyStatement));
        }
        out.append("\n").append("}");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertSwitchToIfIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertSwitchToIfIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doProcessIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

