/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToThrowsFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddExceptionFromFieldInitializerToConstructorThrowsFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(AddExceptionFromFieldInitializerToConstructorThrowsFix.class);
    private final PsiElement myWrongElement;

    public AddExceptionFromFieldInitializerToConstructorThrowsFix(PsiElement element) {
        this.myWrongElement = element;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddExceptionFromFieldInitializerToConstructorThrowsFix.$$$reportNull$$$0(0);
        }
        if (!this.myWrongElement.isValid()) {
            return false;
        }
        NavigatablePsiElement maybeField = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, (Class[])new Class[]{PsiMethod.class, PsiFunctionalExpression.class, PsiField.class});
        if (!(maybeField instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)maybeField;
        if (field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null || containingClass instanceof PsiAnonymousClass || containingClass.isInterface()) {
            return false;
        }
        List<PsiClassType> exceptions = ExceptionUtil.getUnhandledExceptions((PsiElement)field);
        if (exceptions.isEmpty()) {
            return false;
        }
        PsiMethod[] existedConstructors = containingClass.getConstructors();
        this.setText(QuickFixBundle.message("add.exception.from.field.initializer.to.constructor.throws.text", existedConstructors.length));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiClass aClass;
        if (project == null) {
            AddExceptionFromFieldInitializerToConstructorThrowsFix.$$$reportNull$$$0(1);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        NavigatablePsiElement field = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, (Class[])new Class[]{PsiMethod.class, PsiFunctionalExpression.class, PsiField.class});
        if (field instanceof PsiField && (aClass = ((PsiField)field).getContainingClass()) != null) {
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                AddDefaultConstructorFix defaultConstructorFix = new AddDefaultConstructorFix(aClass);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        AddExceptionFromFieldInitializerToConstructorThrowsFix.$$$reportNull$$$0(3);
                    }
                    defaultConstructorFix.invoke(project, null, file);
                });
                constructors = aClass.getConstructors();
                LOG.assertTrue(constructors.length != 0);
            }
            THashSet unhandledExceptions = new THashSet(ExceptionUtil.getUnhandledExceptions((PsiElement)field));
            for (PsiMethod constructor : constructors) {
                AddExceptionToThrowsFix.addExceptionsToThrowsList(project, constructor, (Set<? extends PsiClassType>)unhandledExceptions);
            }
        }
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.exception.from.field.initializer.to.constructor.throws.family.text", new Object[0]);
        if (string == null) {
            AddExceptionFromFieldInitializerToConstructorThrowsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionFromFieldInitializerToConstructorThrowsFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionFromFieldInitializerToConstructorThrowsFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

