/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeArgumentCompletionProvider
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> IN_TYPE_ARGS = PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.TypeArgumentCompletionProvider");
    private final boolean mySmart;
    @Nullable
    private final JavaCompletionSession mySession;

    TypeArgumentCompletionProvider(boolean smart, @Nullable JavaCompletionSession session) {
        this.mySmart = smart;
        this.mySession = session;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet resultSet) {
        if (parameters2 == null) {
            TypeArgumentCompletionProvider.$$$reportNull$$$0(0);
        }
        if (processingContext == null) {
            TypeArgumentCompletionProvider.$$$reportNull$$$0(1);
        }
        if (resultSet == null) {
            TypeArgumentCompletionProvider.$$$reportNull$$$0(2);
        }
        this.addTypeArgumentVariants(parameters2, (Consumer<? super LookupElement>)resultSet, resultSet.getPrefixMatcher());
    }

    void addTypeArgumentVariants(CompletionParameters parameters2, Consumer<? super LookupElement> result, PrefixMatcher matcher) {
        Pair<PsiTypeParameterListOwner, Integer> pair = TypeArgumentCompletionProvider.getTypeParameterInfo(parameters2.getPosition());
        if (pair == null) {
            return;
        }
        PsiTypeParameterListOwner paramOwner = (PsiTypeParameterListOwner)pair.first;
        if (this.suggestByExpectedType(result, parameters2.getPosition(), paramOwner, (Integer)pair.second)) {
            return;
        }
        if (this.mySmart && paramOwner instanceof PsiClass) {
            TypeArgumentCompletionProvider.addInheritors(parameters2, result, (PsiClass)paramOwner, (Integer)pair.second, matcher);
        }
    }

    private boolean suggestByExpectedType(Consumer<? super LookupElement> result, PsiElement context, PsiTypeParameterListOwner paramOwner, int index) {
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)context, PsiExpression.class, (boolean)true);
        ExpectedTypeInfo[] types = ExpectedTypesProvider.getExpectedTypes(expression2, true, false, false);
        if (expression2 == null || types.length == 0) {
            return false;
        }
        for (ExpectedTypeInfo info : types) {
            PsiType type2 = info.getType();
            if (!(type2 instanceof PsiClassType) || type2.equals(expression2.getType())) continue;
            JBIterable remainingParams = JBIterable.of((Object[])paramOwner.getTypeParameters()).skip(index);
            List<PsiType> expectedArgs = CodeInsightUtil.getExpectedTypeArgs(context, paramOwner, (Iterable<? extends PsiTypeParameter>)remainingParams, (PsiClassType)type2);
            this.createLookupItems(result, context, info, expectedArgs, paramOwner);
        }
        return true;
    }

    private void createLookupItems(Consumer<? super LookupElement> result, PsiElement context, ExpectedTypeInfo info, List<? extends PsiType> expectedArgs, PsiTypeParameterListOwner paramOwner) {
        if (expectedArgs.contains(null)) {
            PsiType arg = expectedArgs.get(0);
            if (arg != null) {
                result.consume((Object)TailTypeDecorator.withTail((LookupElement)PsiTypeLookupItem.createLookupItem(arg, context), (TailType)TypeArgumentCompletionProvider.getTail(expectedArgs.size() == 1)));
            }
        } else {
            this.fillAllArgs(result, context, info, expectedArgs, paramOwner);
        }
    }

    private void fillAllArgs(Consumer<? super LookupElement> resultSet, PsiElement context, ExpectedTypeInfo info, List<? extends PsiType> expectedArgs, PsiTypeParameterListOwner paramOwner) {
        List typeItems = ContainerUtil.map(expectedArgs, arg -> PsiTypeLookupItem.createLookupItem(arg, context));
        TailType globalTail = this.mySmart ? info.getTailType() : TailType.NONE;
        TypeArgsLookupElement element = new TypeArgsLookupElement(typeItems, globalTail, TypeArgumentCompletionProvider.hasParameters(paramOwner, context));
        element.registerSingleClass(this.mySession);
        resultSet.consume((Object)element);
    }

    private static boolean hasParameters(PsiTypeParameterListOwner paramOwner, PsiElement context) {
        return paramOwner instanceof PsiClass && ConstructorInsertHandler.hasConstructorParameters((PsiClass)paramOwner, context);
    }

    private static void addInheritors(CompletionParameters parameters2, Consumer<? super LookupElement> resultSet, PsiClass referencedClass, int parameterIndex, PrefixMatcher matcher) {
        List<PsiClassType> typeList = Collections.singletonList((PsiClassType)TypeConversionUtil.typeParameterErasure((PsiTypeParameter)referencedClass.getTypeParameters()[parameterIndex]));
        JavaInheritorsGetter.processInheritors(parameters2, typeList, matcher, (Consumer<? super PsiType>)((Consumer)type2 -> {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
            if (psiClass == null) {
                return;
            }
            resultSet.consume((Object)TailTypeDecorator.withTail((LookupElement)new JavaPsiClassReferenceElement(psiClass), (TailType)TypeArgumentCompletionProvider.getTail(parameterIndex == referencedClass.getTypeParameters().length - 1)));
        }));
    }

    private static TailType getTail(boolean last) {
        return last ? new CharTailType('>') : TailType.COMMA;
    }

    @Nullable
    static Pair<PsiTypeParameterListOwner, Integer> getTypeParameterInfo(PsiElement context) {
        int parameterIndex;
        PsiReferenceParameterList parameterList = (PsiReferenceParameterList)PsiTreeUtil.getContextOfType((PsiElement)context, PsiReferenceParameterList.class, (boolean)true);
        if (parameterList == null) {
            return null;
        }
        PsiElement parent = parameterList.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return null;
        }
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
        int index = 0;
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getContextOfType((PsiElement)context, PsiTypeElement.class, (boolean)true);
        if (typeElement != null) {
            PsiTypeElement element;
            PsiTypeElement[] elements = referenceElement.getParameterList().getTypeParameterElements();
            while (index < elements.length && (element = elements[index++]) != typeElement) {
            }
        }
        if ((parameterIndex = index - 1) < 0) {
            return null;
        }
        PsiElement target = referenceElement.resolve();
        if (!(target instanceof PsiClass) && !(target instanceof PsiMethod)) {
            return null;
        }
        PsiTypeParameterListOwner referencedClass = (PsiTypeParameterListOwner)target;
        PsiTypeParameter[] typeParameters = referencedClass.getTypeParameters();
        if (typeParameters.length <= parameterIndex) {
            return null;
        }
        return Pair.create((Object)referencedClass, (Object)parameterIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processingContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "resultSet";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/TypeArgumentCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TypeArgsLookupElement
    extends LookupElement {
        private final String myLookupString;
        private final List<? extends PsiTypeLookupItem> myTypeItems;
        private final TailType myGlobalTail;
        private final boolean myHasParameters;

        public TypeArgsLookupElement(List<? extends PsiTypeLookupItem> typeItems, TailType globalTail, boolean hasParameters) {
            this.myTypeItems = typeItems;
            this.myGlobalTail = globalTail;
            this.myHasParameters = hasParameters;
            this.myLookupString = StringUtil.join(this.myTypeItems, item -> item.getType().getPresentableText(), (String)", ");
        }

        @NotNull
        public Object getObject() {
            Object object = this.myTypeItems.get(0).getObject();
            if (object == null) {
                TypeArgsLookupElement.$$$reportNull$$$0(0);
            }
            return object;
        }

        public void registerSingleClass(@Nullable JavaCompletionSession inheritors) {
            PsiType type2;
            PsiClass aClass;
            if (inheritors != null && this.myTypeItems.size() == 1 && (aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(type2 = this.myTypeItems.get(0).getType()))) != null && !aClass.hasTypeParameters()) {
                this.myTypeItems.get(0).setShowPackage();
                inheritors.registerClass(aClass);
            }
        }

        @NotNull
        public String getLookupString() {
            String string = this.myLookupString;
            if (string == null) {
                TypeArgsLookupElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void renderElement(LookupElementPresentation presentation) {
            this.myTypeItems.get(0).renderElement(presentation);
            presentation.setItemText(this.getLookupString());
            if (this.myTypeItems.size() > 1) {
                presentation.setTailText(null);
                presentation.setTypeText(null);
            }
        }

        public void handleInsert(@NotNull InsertionContext context) {
            PsiTypeElement[] typeElements;
            if (context == null) {
                TypeArgsLookupElement.$$$reportNull$$$0(2);
            }
            context.commitDocument();
            PsiReferenceParameterList list = (PsiReferenceParameterList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiReferenceParameterList.class, (boolean)false);
            PsiTypeElement[] psiTypeElementArray = typeElements = list != null ? list.getTypeParameterElements() : PsiTypeElement.EMPTY_ARRAY;
            if (typeElements.length == 0) {
                return;
            }
            int listEnd = typeElements[typeElements.length - 1].getTextRange().getEndOffset();
            context.setTailOffset(listEnd);
            context.getDocument().deleteString(context.getStartOffset(), listEnd);
            for (int i = 0; i < this.myTypeItems.size(); ++i) {
                PsiTypeLookupItem typeItem = this.myTypeItems.get(i);
                CompletionUtil.emulateInsertion((InsertionContext)context, (int)context.getTailOffset(), (LookupElement)typeItem);
                if (context.getTailOffset() < 0) {
                    LOG.error("tail offset spoiled by " + typeItem);
                    return;
                }
                context.setTailOffset(TypeArgumentCompletionProvider.getTail(i == this.myTypeItems.size() - 1).processTail(context.getEditor(), context.getTailOffset()));
            }
            context.setAddCompletionChar(false);
            context.commitDocument();
            PsiElement leaf = context.getFile().findElementAt(context.getTailOffset() - 1);
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceParameterList.class, PsiJavaCodeReferenceElement.class, PsiNewExpression.class})).accepts((Object)leaf)) {
                ParenthesesInsertHandler.getInstance((boolean)this.myHasParameters).handleInsert(context, (LookupElement)this);
                this.myGlobalTail.processTail(context.getEditor(), context.getTailOffset());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TypeArgsLookupElement element = (TypeArgsLookupElement)((Object)o);
            return this.myTypeItems.equals(element.myTypeItems);
        }

        public int hashCode() {
            return this.myTypeItems.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/TypeArgumentCompletionProvider$TypeArgsLookupElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/TypeArgumentCompletionProvider$TypeArgsLookupElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

