/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.BaseExternalAnnotationsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadableExternalAnnotationsManager
extends BaseExternalAnnotationsManager {
    @Nullable
    private Set<VirtualFile> myAnnotationsRoots;

    public ReadableExternalAnnotationsManager(PsiManager psiManager) {
        super(psiManager);
    }

    @Override
    protected boolean hasAnyAnnotationsRoots() {
        return !this.initRoots().isEmpty();
    }

    @NotNull
    private synchronized Set<VirtualFile> initRoots() {
        if (this.myAnnotationsRoots == null) {
            Module[] modules;
            this.myAnnotationsRoots = new HashSet<VirtualFile>();
            for (Module module : modules = ModuleManager.getInstance((Project)this.myPsiManager.getProject()).getModules()) {
                for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                    VirtualFile[] files = AnnotationOrderRootType.getFiles((OrderEntry)entry);
                    if (files.length <= 0) continue;
                    Collections.addAll(this.myAnnotationsRoots, files);
                }
            }
        }
        Set<VirtualFile> set = this.myAnnotationsRoots;
        if (set == null) {
            ReadableExternalAnnotationsManager.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    protected List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile libraryFile) {
        if (libraryFile == null) {
            ReadableExternalAnnotationsManager.$$$reportNull$$$0(1);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myPsiManager.getProject()).getFileIndex();
        LinkedHashSet result = new LinkedHashSet();
        for (OrderEntry entry : fileIndex.getOrderEntriesForFile(libraryFile)) {
            if (entry instanceof ModuleOrderEntry) continue;
            Collections.addAll(result, AnnotationOrderRootType.getFiles((OrderEntry)entry));
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(result);
        if (arrayList == null) {
            ReadableExternalAnnotationsManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    protected synchronized void dropCache() {
        this.myAnnotationsRoots = null;
        super.dropCache();
    }

    public boolean isUnderAnnotationRoot(VirtualFile file) {
        return VfsUtilCore.isUnder((VirtualFile)file, this.initRoots());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ReadableExternalAnnotationsManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ReadableExternalAnnotationsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalAnnotationsRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExternalAnnotationsRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

