/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExcludeTable
extends ListTableWithButtons<Item> {
    private static final Pattern ourPackagePattern = Pattern.compile("([\\w*]+\\.)*[\\w*]+");
    private static final ColumnInfo<Item, String> NAME_COLUMN = new ColumnInfo<Item, String>("Class/package/member qualified name mask"){

        @Nullable
        public String valueOf(Item pair) {
            return pair.exclude;
        }

        public TableCellEditor getEditor(Item pair) {
            final JTextField field = GuiUtils.createUndoableTextField();
            field.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    field.putClientProperty("JComponent.outline", ourPackagePattern.matcher(field.getText()).matches() ? null : "error");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/editor/ExcludeTable$1$1", "textChanged"));
                }
            });
            return new DefaultCellEditor(field);
        }

        public TableCellRenderer getRenderer(Item pair) {
            return new DefaultTableCellRenderer(){

                @Override
                @NotNull
                public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                    if (!ourPackagePattern.matcher((String)value2).matches()) {
                        component.setForeground((Color)JBColor.RED);
                    }
                    Component component2 = component;
                    if (component2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return component2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/editor/ExcludeTable$1$2", "getTableCellRendererComponent"));
                }
            };
        }

        public boolean isCellEditable(Item pair) {
            return true;
        }

        public void setValue(Item item, String value2) {
            item.exclude = value2;
        }
    };
    private static final ColumnInfo<Item, ExclusionScope> SCOPE_COLUMN = new ColumnInfo<Item, ExclusionScope>("Scope"){

        @Nullable
        public ExclusionScope valueOf(Item pair) {
            return pair.scope;
        }

        public TableCellRenderer getRenderer(Item pair) {
            return new ComboBoxTableRenderer((Object[])ExclusionScope.values());
        }

        public TableCellEditor getEditor(Item pair) {
            return new ComboBoxTableRenderer((Object[])ExclusionScope.values());
        }

        public boolean isCellEditable(Item pair) {
            return true;
        }

        public void setValue(Item pair, ExclusionScope value2) {
            pair.scope = value2;
        }

        public String getMaxStringValue() {
            return "Project";
        }

        public int getAdditionalWidth() {
            return JBUI.scale((int)12) + AllIcons.General.ArrowDown.getIconWidth();
        }
    };
    private final Project myProject;

    ExcludeTable(@NotNull Project project) {
        if (project == null) {
            ExcludeTable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.getTableView().getEmptyText().setText(ApplicationBundle.message((String)"exclude.from.imports.no.exclusions", (Object[])new Object[0]));
    }

    protected ListTableModel createListModel() {
        return new ListTableModel(new ColumnInfo[]{NAME_COLUMN, SCOPE_COLUMN});
    }

    protected Item createElement() {
        return new Item("", ExclusionScope.IDE);
    }

    protected boolean isEmpty(Item element) {
        return element.exclude.isEmpty();
    }

    protected Item cloneElement(Item variable) {
        return new Item(variable.exclude, variable.scope);
    }

    protected boolean canDeleteElement(Item selection) {
        return true;
    }

    void addExcludePackage(String packageName) {
        int index;
        if (packageName == null) {
            return;
        }
        for (index = 0; index < this.getTableView().getListTableModel().getRowCount() && ((Item)this.getTableView().getListTableModel().getItem((int)index)).exclude.compareTo(packageName) <= 0; ++index) {
        }
        this.getTableView().getListTableModel().insertRow(index, (Object)new Item(packageName, ExclusionScope.IDE));
        this.getTableView().clearSelection();
        this.getTableView().addRowSelectionInterval(index, index);
        ScrollingUtil.ensureIndexIsVisible((JTable)this.getTableView(), (int)index, (int)0);
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getTableView(), false);
    }

    void reset() {
        ArrayList rows = ContainerUtil.newArrayList();
        for (String s : CodeInsightSettings.getInstance().EXCLUDED_PACKAGES) {
            rows.add(new Item(s, ExclusionScope.IDE));
        }
        for (String s : JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames) {
            rows.add(new Item(s, ExclusionScope.Project));
        }
        Collections.sort(rows, Comparator.comparing(o -> o.exclude));
        this.setValues(rows);
    }

    void apply() {
        CodeInsightSettings.getInstance().EXCLUDED_PACKAGES = ArrayUtil.toStringArray(this.getExcludedPackages(ExclusionScope.IDE));
        JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames = this.getExcludedPackages(ExclusionScope.Project);
    }

    private List<String> getExcludedPackages(ExclusionScope scope) {
        ArrayList result = ContainerUtil.newArrayList();
        for (Item pair : this.getTableView().getListTableModel().getItems()) {
            if (scope != pair.scope) continue;
            result.add(pair.exclude);
        }
        Collections.sort(result);
        return result;
    }

    boolean isModified() {
        return !this.getExcludedPackages(ExclusionScope.IDE).equals(Arrays.asList(CodeInsightSettings.getInstance().EXCLUDED_PACKAGES)) || !this.getExcludedPackages(ExclusionScope.Project).equals(JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/application/options/editor/ExcludeTable", "<init>"));
    }

    static class Item {
        String exclude;
        ExclusionScope scope;

        Item(@NotNull String exclude, ExclusionScope scope) {
            if (exclude == null) {
                Item.$$$reportNull$$$0(0);
            }
            this.exclude = exclude;
            this.scope = scope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exclude", "com/intellij/application/options/editor/ExcludeTable$Item", "<init>"));
        }
    }

    private static enum ExclusionScope {
        Project,
        IDE;

    }
}

