/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.builder.MutableMethodImplementation;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.EndLocal;
import org.jf.dexlib2.iface.debug.LineNumber;
import org.jf.dexlib2.iface.debug.RestartLocal;
import org.jf.dexlib2.iface.debug.SetSourceFile;
import org.jf.dexlib2.iface.debug.StartLocal;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.util.EncodedValueUtils;
import org.jf.dexlib2.writer.ClassSection;
import org.jf.dexlib2.writer.DebugWriter;
import org.jf.dexlib2.writer.builder.BaseBuilderPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSet;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderMethodParameter;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.util.AbstractForwardSequentialList;
import org.jf.util.CollectionUtils;
import org.jf.util.ExceptionWithContext;

public class BuilderClassPool
extends BaseBuilderPool
implements ClassSection<BuilderStringReference, BuilderTypeReference, BuilderTypeList, BuilderClassDef, BuilderField, BuilderMethod, BuilderAnnotationSet, BuilderEncodedValues.BuilderEncodedValue> {
    @Nonnull
    private final ConcurrentMap<String, BuilderClassDef> internedItems = Maps.newConcurrentMap();
    private ImmutableList<BuilderClassDef> sortedClasses = null;
    private static final Predicate<Field> HAS_INITIALIZER = new Predicate<Field>(){

        public boolean apply(Field input) {
            EncodedValue encodedValue = input.getInitialValue();
            return encodedValue != null && !EncodedValueUtils.isDefaultValue(encodedValue);
        }
    };
    private static final Function<BuilderField, BuilderEncodedValues.BuilderEncodedValue> GET_INITIAL_VALUE = new Function<BuilderField, BuilderEncodedValues.BuilderEncodedValue>(){

        public BuilderEncodedValues.BuilderEncodedValue apply(BuilderField input) {
            BuilderEncodedValues.BuilderEncodedValue initialValue = input.getInitialValue();
            if (initialValue == null) {
                return BuilderEncodedValues.defaultValueForType(input.getType());
            }
            return initialValue;
        }
    };
    private static final Predicate<BuilderMethodParameter> HAS_PARAMETER_ANNOTATIONS = new Predicate<BuilderMethodParameter>(){

        public boolean apply(BuilderMethodParameter input) {
            return input.getAnnotations().size() > 0;
        }
    };
    private static final Function<BuilderMethodParameter, BuilderAnnotationSet> PARAMETER_ANNOTATIONS = new Function<BuilderMethodParameter, BuilderAnnotationSet>(){

        public BuilderAnnotationSet apply(BuilderMethodParameter input) {
            return input.getAnnotations();
        }
    };

    public BuilderClassPool(@Nonnull DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    @Nonnull
    BuilderClassDef internClass(@Nonnull BuilderClassDef classDef) {
        BuilderClassDef prev = this.internedItems.put(classDef.getType(), classDef);
        if (prev != null) {
            throw new ExceptionWithContext("Class %s has already been interned", new Object[]{classDef.getType()});
        }
        return classDef;
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderClassDef> getSortedClasses() {
        if (this.sortedClasses == null) {
            this.sortedClasses = Ordering.natural().immutableSortedCopy(this.internedItems.values());
        }
        return this.sortedClasses;
    }

    @Override
    @Nullable
    public Map.Entry<? extends BuilderClassDef, Integer> getClassEntryByType(@Nullable BuilderTypeReference type) {
        if (type == null) {
            return null;
        }
        final BuilderClassDef classDef = (BuilderClassDef)this.internedItems.get(type.getType());
        if (classDef == null) {
            return null;
        }
        return new Map.Entry<BuilderClassDef, Integer>(){

            @Override
            public BuilderClassDef getKey() {
                return classDef;
            }

            @Override
            public Integer getValue() {
                return classDef.classDefIndex;
            }

            @Override
            public Integer setValue(Integer value) {
                classDef.classDefIndex = value;
                return classDef.classDefIndex;
            }
        };
    }

    @Override
    @Nonnull
    public BuilderTypeReference getType(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.type;
    }

    @Override
    public int getAccessFlags(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.accessFlags;
    }

    @Override
    @Nullable
    public BuilderTypeReference getSuperclass(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.superclass;
    }

    @Override
    @Nullable
    public BuilderTypeList getInterfaces(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.interfaces;
    }

    @Override
    @Nullable
    public BuilderStringReference getSourceFile(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.sourceFile;
    }

    @Override
    @Nullable
    public Collection<? extends BuilderEncodedValues.BuilderEncodedValue> getStaticInitializers(@Nonnull BuilderClassDef classDef) {
        Iterable sortedStaticFields = classDef.getStaticFields();
        int lastIndex = CollectionUtils.lastIndexOf((Iterable)sortedStaticFields, HAS_INITIALIZER);
        if (lastIndex > -1) {
            return new AbstractCollection<BuilderEncodedValues.BuilderEncodedValue>((SortedSet)sortedStaticFields, lastIndex){
                final /* synthetic */ SortedSet val$sortedStaticFields;
                final /* synthetic */ int val$lastIndex;
                {
                    this.val$sortedStaticFields = sortedSet;
                    this.val$lastIndex = n;
                }

                @Override
                @Nonnull
                public Iterator<BuilderEncodedValues.BuilderEncodedValue> iterator() {
                    return FluentIterable.from((Iterable)this.val$sortedStaticFields).limit(this.val$lastIndex + 1).transform(GET_INITIAL_VALUE).iterator();
                }

                @Override
                public int size() {
                    return this.val$lastIndex + 1;
                }
            };
        }
        return null;
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderField> getSortedStaticFields(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.getStaticFields();
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderField> getSortedInstanceFields(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.getInstanceFields();
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderField> getSortedFields(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.getFields();
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderMethod> getSortedDirectMethods(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.getDirectMethods();
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderMethod> getSortedVirtualMethods(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.getVirtualMethods();
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderMethod> getSortedMethods(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.getMethods();
    }

    @Override
    public int getFieldAccessFlags(@Nonnull BuilderField builderField) {
        return builderField.accessFlags;
    }

    @Override
    public int getMethodAccessFlags(@Nonnull BuilderMethod builderMethod) {
        return builderMethod.accessFlags;
    }

    @Override
    @Nullable
    public BuilderAnnotationSet getClassAnnotations(@Nonnull BuilderClassDef builderClassDef) {
        if (builderClassDef.annotations.isEmpty()) {
            return null;
        }
        return builderClassDef.annotations;
    }

    @Override
    @Nullable
    public BuilderAnnotationSet getFieldAnnotations(@Nonnull BuilderField builderField) {
        if (builderField.annotations.isEmpty()) {
            return null;
        }
        return builderField.annotations;
    }

    @Override
    @Nullable
    public BuilderAnnotationSet getMethodAnnotations(@Nonnull BuilderMethod builderMethod) {
        if (builderMethod.annotations.isEmpty()) {
            return null;
        }
        return builderMethod.annotations;
    }

    @Override
    @Nullable
    public List<? extends BuilderAnnotationSet> getParameterAnnotations(@Nonnull BuilderMethod method) {
        final List<? extends BuilderMethodParameter> parameters = method.getParameters();
        boolean hasParameterAnnotations = Iterables.any(parameters, HAS_PARAMETER_ANNOTATIONS);
        if (hasParameterAnnotations) {
            return new AbstractForwardSequentialList<BuilderAnnotationSet>(){

                @Nonnull
                public Iterator<BuilderAnnotationSet> iterator() {
                    return FluentIterable.from((Iterable)parameters).transform(PARAMETER_ANNOTATIONS).iterator();
                }

                public int size() {
                    return parameters.size();
                }
            };
        }
        return null;
    }

    @Override
    @Nullable
    public Iterable<? extends DebugItem> getDebugItems(@Nonnull BuilderMethod builderMethod) {
        MethodImplementation impl = builderMethod.getImplementation();
        if (impl == null) {
            return null;
        }
        return impl.getDebugItems();
    }

    @Override
    @Nullable
    public Iterable<? extends BuilderStringReference> getParameterNames(@Nonnull BuilderMethod method) {
        return Iterables.transform(method.getParameters(), (Function)new Function<BuilderMethodParameter, BuilderStringReference>(){

            @Nullable
            public BuilderStringReference apply(BuilderMethodParameter input) {
                return input.name;
            }
        });
    }

    @Override
    public int getRegisterCount(@Nonnull BuilderMethod builderMethod) {
        MethodImplementation impl = builderMethod.getImplementation();
        if (impl == null) {
            return 0;
        }
        return impl.getRegisterCount();
    }

    @Override
    @Nullable
    public Iterable<? extends Instruction> getInstructions(@Nonnull BuilderMethod builderMethod) {
        MethodImplementation impl = builderMethod.getImplementation();
        if (impl == null) {
            return null;
        }
        return impl.getInstructions();
    }

    @Override
    @Nonnull
    public List<? extends TryBlock<? extends ExceptionHandler>> getTryBlocks(@Nonnull BuilderMethod builderMethod) {
        MethodImplementation impl = builderMethod.getImplementation();
        if (impl == null) {
            return ImmutableList.of();
        }
        return impl.getTryBlocks();
    }

    @Override
    @Nullable
    public BuilderTypeReference getExceptionType(@Nonnull ExceptionHandler handler) {
        return this.checkTypeReference(handler.getExceptionTypeReference());
    }

    @Override
    @Nonnull
    public MutableMethodImplementation makeMutableMethodImplementation(@Nonnull BuilderMethod builderMethod) {
        MethodImplementation impl = builderMethod.getImplementation();
        if (impl instanceof MutableMethodImplementation) {
            return (MutableMethodImplementation)impl;
        }
        return new MutableMethodImplementation(impl);
    }

    @Override
    public void setEncodedArrayOffset(@Nonnull BuilderClassDef builderClassDef, int offset) {
        builderClassDef.encodedArrayOffset = offset;
    }

    @Override
    public int getEncodedArrayOffset(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.encodedArrayOffset;
    }

    @Override
    public void setAnnotationDirectoryOffset(@Nonnull BuilderClassDef builderClassDef, int offset) {
        builderClassDef.annotationDirectoryOffset = offset;
    }

    @Override
    public int getAnnotationDirectoryOffset(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.annotationDirectoryOffset;
    }

    @Override
    public void setAnnotationSetRefListOffset(@Nonnull BuilderMethod builderMethod, int offset) {
        builderMethod.annotationSetRefListOffset = offset;
    }

    @Override
    public int getAnnotationSetRefListOffset(@Nonnull BuilderMethod builderMethod) {
        return builderMethod.annotationSetRefListOffset;
    }

    @Override
    public void setCodeItemOffset(@Nonnull BuilderMethod builderMethod, int offset) {
        builderMethod.codeItemOffset = offset;
    }

    @Override
    public int getCodeItemOffset(@Nonnull BuilderMethod builderMethod) {
        return builderMethod.codeItemOffset;
    }

    @Nullable
    private BuilderStringReference checkStringReference(@Nullable StringReference stringReference) {
        if (stringReference == null) {
            return null;
        }
        try {
            return (BuilderStringReference)stringReference;
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException("Only StringReference instances returned by DexBuilder.internStringReference or DexBuilder.internNullableStringReference may be used.");
        }
    }

    @Nullable
    private BuilderTypeReference checkTypeReference(@Nullable TypeReference typeReference) {
        if (typeReference == null) {
            return null;
        }
        try {
            return (BuilderTypeReference)typeReference;
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException("Only TypeReference instances returned by DexBuilder.internTypeReference or DexBuilder.internNullableTypeReference may be used.");
        }
    }

    @Override
    public void writeDebugItem(@Nonnull DebugWriter<BuilderStringReference, BuilderTypeReference> writer, DebugItem debugItem) throws IOException {
        switch (debugItem.getDebugItemType()) {
            case 3: {
                StartLocal startLocal = (StartLocal)debugItem;
                writer.writeStartLocal(startLocal.getCodeAddress(), startLocal.getRegister(), this.checkStringReference(startLocal.getNameReference()), this.checkTypeReference(startLocal.getTypeReference()), this.checkStringReference(startLocal.getSignatureReference()));
                break;
            }
            case 5: {
                EndLocal endLocal = (EndLocal)debugItem;
                writer.writeEndLocal(endLocal.getCodeAddress(), endLocal.getRegister());
                break;
            }
            case 6: {
                RestartLocal restartLocal = (RestartLocal)debugItem;
                writer.writeRestartLocal(restartLocal.getCodeAddress(), restartLocal.getRegister());
                break;
            }
            case 7: {
                writer.writePrologueEnd(debugItem.getCodeAddress());
                break;
            }
            case 8: {
                writer.writeEpilogueBegin(debugItem.getCodeAddress());
                break;
            }
            case 10: {
                LineNumber lineNumber = (LineNumber)debugItem;
                writer.writeLineNumber(lineNumber.getCodeAddress(), lineNumber.getLineNumber());
                break;
            }
            case 9: {
                SetSourceFile setSourceFile = (SetSourceFile)debugItem;
                writer.writeSetSourceFile(setSourceFile.getCodeAddress(), this.checkStringReference(setSourceFile.getSourceFileReference()));
                break;
            }
            default: {
                throw new ExceptionWithContext("Unexpected debug item type: %d", new Object[]{debugItem.getDebugItemType()});
            }
        }
    }

    @Override
    public int getItemIndex(@Nonnull BuilderClassDef builderClassDef) {
        return builderClassDef.classDefIndex;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderClassDef, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderClassDef>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderClassDef key) {
                return key.classDefIndex;
            }

            @Override
            protected int setValue(@Nonnull BuilderClassDef key, int value) {
                int prev = key.classDefIndex;
                key.classDefIndex = value;
                return prev;
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }
}

