/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.JavaCreatePropertyFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidPropertyKeyInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.PROPERTIES_GROUP_NAME;
        if (string == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = CodeInsightBundle.message((String)"inspection.unresolved.property.key.reference.name", (Object[])new Object[0]);
        if (string == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("UnresolvedPropertyKey" == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(2);
        }
        return "UnresolvedPropertyKey";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(5);
        }
        return InvalidPropertyKeyInspection.checkElement((PsiElement)method, manager, isOnTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(7);
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        SmartList result = new SmartList();
        for (PsiClassInitializer initializer : initializers) {
            Object[] descriptors = InvalidPropertyKeyInspection.checkElement((PsiElement)initializer.getBody(), manager, isOnTheFly);
            if (descriptors == null) continue;
            ContainerUtil.addAll((Collection)result, (Object[])descriptors);
        }
        return result.isEmpty() ? null : result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(9);
        }
        SmartList result = new SmartList();
        InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, (List<? super ProblemDescriptor>)result, (PsiElement)field.getInitializer());
        InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, (List<? super ProblemDescriptor>)result, (PsiElement)field.getModifierList());
        if (field instanceof PsiEnumConstant) {
            InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, (List<? super ProblemDescriptor>)result, (PsiElement)((PsiEnumConstant)field).getArgumentList());
        }
        return result.isEmpty() ? null : result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static void appendProblems(InspectionManager manager, boolean isOnTheFly, List<? super ProblemDescriptor> result, PsiElement element) {
        ProblemDescriptor[] descriptors;
        if (element != null && (descriptors = InvalidPropertyKeyInspection.checkElement(element, manager, isOnTheFly)) != null) {
            Collections.addAll(result, descriptors);
        }
    }

    @Nullable
    private static ProblemDescriptor[] checkElement(PsiElement element, InspectionManager manager, boolean onTheFly) {
        UnresolvedPropertyVisitor visitor = new UnresolvedPropertyVisitor(manager, onTheFly);
        element.accept((PsiElementVisitor)visitor);
        Map<PsiElement, ProblemDescriptor> problems = visitor.getProblems();
        return problems.isEmpty() ? null : problems.values().toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnresolvedPropertyVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final InspectionManager myManager;
        private final Map<PsiElement, ProblemDescriptor> myProblems = new THashMap();
        private final boolean onTheFly;

        UnresolvedPropertyVisitor(InspectionManager manager, boolean onTheFly) {
            this.myManager = manager;
            this.onTheFly = onTheFly;
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
            PsiExpressionList argList = aClass.getArgumentList();
            if (argList != null) {
                argList.accept((PsiElementVisitor)this);
            }
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitField(PsiField field) {
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            if (UnresolvedPropertyVisitor.isComputedPropertyExpression((PsiExpression)expression)) {
                return;
            }
            PsiElement resolvedExpression = expression.resolve();
            if (resolvedExpression instanceof PsiField) {
                PsiField field = (PsiField)resolvedExpression;
                if (!field.hasModifierProperty("final")) {
                    return;
                }
                PsiExpression initializer = field.getInitializer();
                String key = UnresolvedPropertyVisitor.computeStringValue(initializer);
                this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, key, (PsiExpression)(field.getContainingFile() == expression.getContainingFile() ? initializer : expression));
            } else if (resolvedExpression instanceof PsiLocalVariable) {
                this.checkLocalVariable((PsiLocalVariable)resolvedExpression, expression);
            }
        }

        private void checkLocalVariable(@NotNull PsiLocalVariable variable, PsiReferenceExpression expression) {
            PsiElement[] defs;
            PsiCodeBlock block;
            if (variable == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(0);
            }
            if ((block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class)) == null) {
                return;
            }
            for (PsiElement def : defs = DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)variable, (PsiElement)expression)) {
                PsiAssignmentExpression assignment;
                if (def instanceof PsiLocalVariable) {
                    PsiExpression initializer = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiLocalVariable)def).getInitializer());
                    this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, UnresolvedPropertyVisitor.computeStringValue(initializer), initializer);
                    continue;
                }
                if (!(def instanceof PsiReferenceExpression) || (assignment = ExpressionUtils.getAssignment((PsiElement)def.getParent())) == null || assignment.getLExpression() != def) continue;
                PsiExpression rhs = PsiUtil.deparenthesizeExpression((PsiExpression)assignment.getRExpression());
                if (rhs instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)rhs;
                    PsiExpression thenExpression = conditionalExpression.getThenExpression();
                    PsiExpression elseExpression = conditionalExpression.getElseExpression();
                    this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, UnresolvedPropertyVisitor.computeStringValue(thenExpression), thenExpression);
                    this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, UnresolvedPropertyVisitor.computeStringValue(elseExpression), elseExpression);
                    continue;
                }
                this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, UnresolvedPropertyVisitor.computeStringValue(rhs), rhs);
            }
        }

        private static String computeStringValue(PsiExpression expression) {
            Object value;
            if (expression instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)expression).getValue()) instanceof String) {
                return (String)value;
            }
            return null;
        }

        private void visitPropertyKeyAnnotationParameter(PsiExpression expression, String key, PsiExpression highlightedExpression) {
            block7: {
                Ref resourceBundleName;
                block8: {
                    List propFiles;
                    block6: {
                        if (key == null) {
                            return;
                        }
                        resourceBundleName = new Ref();
                        if (JavaI18nUtil.isValidPropertyReference(this.myManager.getProject(), expression, key, (Ref<? super String>)resourceBundleName)) break block6;
                        String bundleName = (String)resourceBundleName.get();
                        if (bundleName == null) break block7;
                        UnresolvedPropertyVisitor.appendPropertyKeyNotFoundProblem(bundleName, key, highlightedExpression, this.myManager, this.myProblems, this.onTheFly);
                        break block7;
                    }
                    if (!(expression.getParent() instanceof PsiNameValuePair)) break block8;
                    PsiNameValuePair nvp = (PsiNameValuePair)expression.getParent();
                    if (!Comparing.equal((String)nvp.getName(), (String)"resourceBundle")) break block7;
                    PropertiesReferenceManager manager = PropertiesReferenceManager.getInstance((Project)expression.getProject());
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression);
                    if (module != null && (propFiles = manager.findPropertiesFiles(module, key)).isEmpty()) {
                        String description = CodeInsightBundle.message((String)"inspection.invalid.resource.bundle.reference", (Object[])new Object[]{key});
                        ProblemDescriptor problem = this.myManager.createProblemDescriptor((PsiElement)expression, description, (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, this.onTheFly);
                        this.myProblems.putIfAbsent((PsiElement)expression, problem);
                    }
                    break block7;
                }
                if (expression.getParent() instanceof PsiExpressionList && expression.getParent().getParent() instanceof PsiMethodCallExpression) {
                    if (!JavaI18nUtil.mustBePropertyKey(expression, null)) {
                        return;
                    }
                    SortedSet<Integer> paramsCount = JavaI18nUtil.getPropertyValueParamsCount(highlightedExpression, (String)resourceBundleName.get());
                    if (paramsCount.isEmpty() || paramsCount.size() != 1 && resourceBundleName.get() == null) {
                        return;
                    }
                    int maxParamCount = paramsCount.last();
                    PsiExpressionList expressions = (PsiExpressionList)expression.getParent();
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expressions.getParent();
                    PsiMethod method = methodCall.resolveMethod();
                    PsiExpression[] args = expressions.getExpressions();
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] != expression) continue;
                        if (i + maxParamCount < args.length || method == null || method.getParameterList().getParametersCount() != i + 2 || !method.getParameterList().getParameters()[i + 1].isVarArgs() || UnresolvedPropertyVisitor.hasArrayTypeAt(i + 1, methodCall)) break;
                        this.myProblems.putIfAbsent((PsiElement)methodCall, this.myManager.createProblemDescriptor((PsiElement)methodCall, CodeInsightBundle.message((String)"property.has.more.parameters.than.passed", (Object[])new Object[]{key, maxParamCount, args.length - i - 1}), this.onTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR));
                        break;
                    }
                }
            }
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            if (UnresolvedPropertyVisitor.isComputedPropertyExpression((PsiExpression)expression)) {
                return;
            }
            this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, UnresolvedPropertyVisitor.computeStringValue((PsiExpression)expression), (PsiExpression)expression);
        }

        private static void appendPropertyKeyNotFoundProblem(@NotNull String bundleName, @NotNull String key, @NotNull PsiExpression expression, @NotNull InspectionManager manager, @NotNull Map<PsiElement, ProblemDescriptor> problems, boolean onTheFly) {
            if (bundleName == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(1);
            }
            if (key == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(2);
            }
            if (expression == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(3);
            }
            if (manager == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(4);
            }
            if (problems == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(5);
            }
            String description = CodeInsightBundle.message((String)"inspection.unresolved.property.key.reference.message", (Object[])new Object[]{key});
            List<PropertiesFile> propertiesFiles = UnresolvedPropertyVisitor.filterNotInLibrary(expression.getProject(), I18nUtil.propertiesFilesByBundleName((String)bundleName, (PsiElement)expression));
            if (problems.containsKey(expression)) {
                return;
            }
            problems.put((PsiElement)expression, manager.createProblemDescriptor((PsiElement)expression, description, (LocalQuickFix)(propertiesFiles.isEmpty() ? null : new JavaCreatePropertyFix((PsiElement)expression, key, propertiesFiles)), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly));
        }

        @NotNull
        private static List<PropertiesFile> filterNotInLibrary(@NotNull Project project, @NotNull List<? extends PropertiesFile> propertiesFiles) {
            if (project == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(6);
            }
            if (propertiesFiles == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(7);
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            ArrayList<PropertiesFile> result = new ArrayList<PropertiesFile>(propertiesFiles.size());
            for (PropertiesFile propertiesFile : propertiesFiles) {
                if (fileIndex.isInLibraryClasses(propertiesFile.getVirtualFile()) || fileIndex.isInLibrarySource(propertiesFile.getVirtualFile())) continue;
                result.add(propertiesFile);
            }
            ArrayList<PropertiesFile> arrayList = result;
            if (arrayList == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        private static boolean hasArrayTypeAt(int i, PsiMethodCallExpression methodCall) {
            return methodCall != null && methodCall.getArgumentList().getExpressionTypes().length > i && methodCall.getArgumentList().getExpressionTypes()[i] instanceof PsiArrayType;
        }

        private static boolean isComputedPropertyExpression(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression && (expression == ((PsiConditionalExpression)parent).getThenExpression() || expression == ((PsiConditionalExpression)parent).getElseExpression())) {
                expression = (PsiExpression)parent;
                parent = expression.getParent();
            }
            return parent instanceof PsiExpression;
        }

        public Map<PsiElement, ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bundleName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problems";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertiesFiles";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterNotInLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "checkLocalVariable";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "appendPropertyKeyNotFoundProblem";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "filterNotInLibrary";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

